/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.references;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.xtext.common.types.JvmSynonymTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.TypeReferenceVisitor;
import org.eclipse.xtext.xbase.typesystem.references.TypeReferenceVisitorWithParameter;
import org.eclipse.xtext.xbase.typesystem.references.TypeReferenceVisitorWithParameterAndResult;
import org.eclipse.xtext.xbase.typesystem.references.TypeReferenceVisitorWithResult;
import org.eclipse.xtext.xbase.typesystem.util.IVisibilityHelper;
import org.eclipse.xtext.xbase.typesystem.util.TypeParameterSubstitutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonNullByDefault
public class CompoundTypeReference
extends LightweightTypeReference {
    private boolean synonym;
    private List<LightweightTypeReference> components;
    private boolean resolved;

    public CompoundTypeReference(ITypeReferenceOwner owner, boolean synonym) {
        super(owner);
        this.synonym = synonym;
        this.resolved = true;
    }

    @Override
    public int getKind() {
        return 4;
    }

    @Override
    public JvmTypeReference toTypeReference() {
        JvmSynonymTypeReference result;
        Object object = result = this.synonym ? this.getTypesFactory().createJvmSynonymTypeReference() : this.getTypesFactory().createJvmMultiTypeReference();
        if (this.components != null) {
            for (LightweightTypeReference component : this.components) {
                result.getReferences().add((Object)component.toTypeReference());
            }
        }
        return result;
    }

    @Override
    public boolean isVisible(IVisibilityHelper visibilityHelper) {
        if (this.components != null && !this.components.isEmpty()) {
            for (LightweightTypeReference component : this.components) {
                if (component.isVisible(visibilityHelper)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public JvmTypeReference toJavaCompliantTypeReference(IVisibilityHelper visibilityHelper) {
        List<LightweightTypeReference> nonInterfaceTypes;
        if (!this.isSynonym() && (nonInterfaceTypes = this.getNonInterfaceTypes(this.components)) != null) {
            return this.toJavaCompliantTypeReference(nonInterfaceTypes, visibilityHelper);
        }
        return this.toJavaCompliantTypeReference(this.components, visibilityHelper);
    }

    @Override
    public List<LightweightTypeReference> getTypeArguments() {
        if (this.components != null && this.components.size() == 1) {
            return this.components.get(0).getTypeArguments();
        }
        return super.getTypeArguments();
    }

    @Override
    public boolean isRawType() {
        for (LightweightTypeReference component : this.expose(this.components)) {
            if (!component.isRawType()) continue;
            return true;
        }
        return false;
    }

    @Override
    public LightweightTypeReference getRawTypeReference() {
        if (this.isAllRawType()) {
            return this;
        }
        CompoundTypeReference result = new CompoundTypeReference(this.getOwner(), this.isSynonym());
        for (LightweightTypeReference component : this.expose(this.components)) {
            result.addComponent(component.getRawTypeReference());
        }
        return result;
    }

    private boolean isAllRawType() {
        for (LightweightTypeReference component : this.expose(this.components)) {
            if (component.isRawType()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isOwnedBy(ITypeReferenceOwner owner) {
        if (super.isOwnedBy(owner)) {
            for (LightweightTypeReference parameterType : this.expose(this.components)) {
                if (parameterType.isOwnedBy(owner)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public JvmType getType() {
        if (this.components != null && this.components.size() == 1) {
            return this.components.get(0).getType();
        }
        return null;
    }

    @Override
    protected List<LightweightTypeReference> getSuperTypes(TypeParameterSubstitutor<?> substitutor) {
        if (!this.isSynonym()) {
            if (this.components == null || this.components.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList result = Lists.newArrayListWithCapacity((int)this.components.size());
            for (LightweightTypeReference component : this.components) {
                result.add(substitutor.substitute(component));
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    @Nullable
    public LightweightTypeReference getSuperType(JvmType rawType) {
        if (this.components == null || this.components.isEmpty()) {
            return null;
        }
        for (LightweightTypeReference component : this.components) {
            LightweightTypeReference result = component.getSuperType(rawType);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    @Nullable
    public LightweightTypeReference getSuperType(Class<?> rawType) {
        if (this.components == null || this.components.isEmpty()) {
            return null;
        }
        for (LightweightTypeReference component : this.components) {
            LightweightTypeReference result = component.getSuperType(rawType);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public boolean isType(Class<?> clazz) {
        if (this.components == null) {
            return false;
        }
        if (this.isSynonym()) {
            for (LightweightTypeReference component : this.components) {
                if (!component.isType(clazz)) continue;
                return true;
            }
            return false;
        }
        for (LightweightTypeReference component : this.components) {
            if (component.isType(clazz)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected LightweightTypeReference doCopyInto(ITypeReferenceOwner owner) {
        CompoundTypeReference result = new CompoundTypeReference(owner, this.synonym);
        if (this.components != null && !this.components.isEmpty()) {
            for (LightweightTypeReference typeArgument : this.components) {
                result.addComponent(typeArgument.copyInto(owner));
            }
        }
        return result;
    }

    @Override
    public boolean isResolved() {
        return this.resolved;
    }

    @Override
    public boolean isSynonym() {
        return this.synonym;
    }

    public void addComponent(LightweightTypeReference component) {
        if (component == null) {
            throw new NullPointerException("component may not be null");
        }
        if (!component.isOwnedBy(this.getOwner())) {
            throw new NullPointerException("component is not valid in current context");
        }
        if (this.components == null) {
            this.components = Lists.newArrayListWithCapacity((int)2);
        }
        this.components.add(component);
        this.resolved = this.resolved && component.isResolved();
    }

    @Override
    public String getSimpleName() {
        return this.getAsString(LightweightTypeReference.SimpleNameFunction.INSTANCE);
    }

    @Override
    public String getIdentifier() {
        return this.getAsString(LightweightTypeReference.IdentifierFunction.INSTANCE);
    }

    @Override
    public String getUniqueIdentifier() {
        return this.getAsString(LightweightTypeReference.UniqueIdentifierFunction.INSTANCE);
    }

    @Override
    public String getJavaIdentifier() {
        return this.toJavaType().getJavaIdentifier();
    }

    private String getAsString(Function<? super LightweightTypeReference, ? extends String> format) {
        return Joiner.on((String)(this.synonym ? " | " : " & ")).join(Iterables.transform(this.expose(this.components), format));
    }

    @Override
    public void accept(TypeReferenceVisitor visitor) {
        if (this.isSynonym()) {
            visitor.doVisitSynonymTypeReference(this);
        } else {
            visitor.doVisitMultiTypeReference(this);
        }
    }

    @Override
    public <Param> void accept(TypeReferenceVisitorWithParameter<Param> visitor, Param param) {
        if (this.isSynonym()) {
            visitor.doVisitSynonymTypeReference(this, param);
        } else {
            visitor.doVisitMultiTypeReference(this, param);
        }
    }

    @Override
    @Nullable
    public <Result> Result accept(TypeReferenceVisitorWithResult<Result> visitor) {
        if (this.isSynonym()) {
            return visitor.doVisitSynonymTypeReference(this);
        }
        return visitor.doVisitMultiTypeReference(this);
    }

    @Override
    @Nullable
    public <Param, Result> Result accept(TypeReferenceVisitorWithParameterAndResult<Param, Result> visitor, Param param) {
        if (this.isSynonym()) {
            return visitor.doVisitSynonymTypeReference(this, param);
        }
        return visitor.doVisitMultiTypeReference(this, param);
    }

    @Override
    public CompoundTypeReference toMultiType(LightweightTypeReference reference) {
        if (!this.isSynonym()) {
            if (reference == null) {
                throw new NullPointerException("reference may not be null");
            }
            CompoundTypeReference result = new CompoundTypeReference(this.getOwner(), false);
            for (LightweightTypeReference component : this.getMultiTypeComponents()) {
                result.addComponent(component);
            }
            result.addComponent(reference);
            return result;
        }
        return super.toMultiType(reference);
    }

    @Override
    public boolean isMultiType() {
        return !this.synonym;
    }

    @Override
    public LightweightTypeReference toJavaType() {
        LightweightTypeReference result = this.getServices().getTypeConformanceComputer().getCommonSuperType(this.getMultiTypeComponents(), this.getOwner());
        if (result == null) {
            throw new IllegalStateException("Cannot expression " + this + " as Java type reference");
        }
        return result.toJavaType();
    }

    @Override
    public List<LightweightTypeReference> getMultiTypeComponents() {
        return this.expose(this.components);
    }
}

