/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.outline.quickoutline;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.xtext.ui.editor.contentassist.PrefixMatcher;
import org.eclipse.xtext.ui.editor.outline.quickoutline.StringMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrefixMatcherOutlineAdapter
extends StringMatcher {
    private final PrefixMatcher strategy;
    private final List<String> prefixParts;
    private final List<StringMatcher> stringMatchers;
    private final String prefix;
    private final StringMatcher prefixStringMatcher;

    public PrefixMatcherOutlineAdapter(String prefix, PrefixMatcher strategy) {
        super("", true);
        this.prefix = prefix;
        this.prefixParts = this.splitIntoParts(prefix);
        this.strategy = strategy;
        boolean ignoreCase = prefix.equals(prefix.toLowerCase());
        this.prefixStringMatcher = new StringMatcher(prefix, ignoreCase);
        this.stringMatchers = Lists.newArrayList();
        for (String part : this.prefixParts) {
            this.stringMatchers.add(new StringMatcher(part, ignoreCase));
        }
    }

    protected List<String> splitIntoParts(String prefix) {
        ArrayList result = Lists.newArrayList();
        int nextStart = 0;
        int i = 0;
        while (i < prefix.length()) {
            char c = prefix.charAt(i);
            if (this.isStructuralDelimiter(c) || c == '.' || c == ' ' || c == '\t') {
                if (nextStart != i) {
                    result.add(prefix.substring(nextStart, i).trim());
                }
                if (c != ' ' && c != '\t') {
                    result.add(Character.toString(c));
                }
                nextStart = i + 1;
            }
            ++i;
        }
        if (nextStart != prefix.length()) {
            result.add(prefix.substring(nextStart).trim());
        }
        return result;
    }

    protected boolean isStructuralDelimiter(char c) {
        return c == '(' || c == ')' || c == '{' || c == '}' || c == '[' || c == ']' || c == ':' || c == ',';
    }

    @Override
    protected String translatePattern(String pattern) {
        return pattern;
    }

    @Override
    public boolean match(String label) {
        if (this.prefixParts.isEmpty()) {
            return true;
        }
        if (this.strategy.isCandidateMatchingPrefix(label, this.prefix)) {
            return true;
        }
        if (this.prefixStringMatcher.match(label)) {
            return true;
        }
        List<String> labelParts = this.splitIntoParts(label);
        if (labelParts.size() < this.prefixParts.size()) {
            return false;
        }
        if (this.prefixParts.size() == 1 && labelParts.size() == 1) {
            return false;
        }
        int labelIdx = 0;
        int prefixIdx = 0;
        boolean ignoreStructuralDelimiterGuard = false;
        while (prefixIdx < this.prefixParts.size()) {
            String prefixPart = this.prefixParts.get(prefixIdx);
            StringMatcher partMatcher = this.stringMatchers.get(prefixIdx);
            boolean didMatch = false;
            while (labelIdx < labelParts.size()) {
                String labelPart = labelParts.get(labelIdx).trim();
                ++labelIdx;
                if (this.strategy.isCandidateMatchingPrefix(labelPart, prefixPart)) {
                    didMatch = true;
                    ignoreStructuralDelimiterGuard = prefixPart.endsWith("*");
                    break;
                }
                if (partMatcher.match(labelPart)) {
                    ignoreStructuralDelimiterGuard = prefixPart.endsWith("*");
                    didMatch = true;
                    break;
                }
                if (ignoreStructuralDelimiterGuard || labelPart.length() != 1 || !this.isStructuralDelimiter(labelPart.charAt(0))) continue;
                return false;
            }
            if (!didMatch) {
                return false;
            }
            if (++prefixIdx < this.prefixParts.size()) continue;
            return true;
        }
        return false;
    }
}

