/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.documentation.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.xtext.documentation.IJavaDocTypeReferenceProvider;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.util.ReplaceRegion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiLineJavaDocTypeReferenceProvider
implements IJavaDocTypeReferenceProvider {
    protected String lineDelimiter = System.getProperty("line.separator");

    @Override
    public List<ReplaceRegion> computeTypeRefRegions(INode node) {
        ArrayList regions = Lists.newArrayList();
        Iterable<ILeafNode> leafNodes = node.getLeafNodes();
        this.computeRegions(regions, leafNodes, "@link ", "#", " ", "}");
        this.computeRegions(regions, leafNodes, "@see ", "#", " ", this.lineDelimiter);
        return regions;
    }

    @Override
    public List<ReplaceRegion> computeParameterTypeRefRegions(INode node) {
        ArrayList regions = Lists.newArrayList();
        Iterable<ILeafNode> leafNodes = node.getLeafNodes();
        this.computeRegions(regions, leafNodes, "@param ", " ", "-", this.lineDelimiter);
        return regions;
    }

    protected void computeRegions(List<ReplaceRegion> regions, Iterable<ILeafNode> leafNodes, String toSearch, String end, String optionalEnd, String optionalEnd2) {
        block0: for (ILeafNode leafNode : leafNodes) {
            String text = leafNode.getText();
            int offset = leafNode.getOffset();
            int position = text.indexOf(toSearch);
            int textLength = text.length();
            while (position != -1) {
                int lastEndLink;
                int beginIndex = position + toSearch.length();
                if (Character.isWhitespace(text.charAt(beginIndex))) {
                    while (beginIndex < textLength && Character.isWhitespace(text.charAt(beginIndex))) {
                        ++beginIndex;
                    }
                }
                int endLink = -1;
                if (end != null && endLink == -1) {
                    endLink = text.indexOf(end, beginIndex);
                }
                if (optionalEnd != null && endLink == -1) {
                    endLink = text.indexOf(optionalEnd, beginIndex);
                }
                if (optionalEnd2 != null && (lastEndLink = text.indexOf(optionalEnd2, beginIndex)) != -1) {
                    if (endLink != -1) {
                        if (endLink > lastEndLink) {
                            endLink = lastEndLink;
                        }
                    } else {
                        endLink = lastEndLink;
                    }
                }
                if (endLink == -1) continue block0;
                String simpleName = text.substring(beginIndex, endLink).replaceAll(" ", "");
                if (simpleName.length() > 0 && simpleName.matches("[0-9a-zA-Z\\.\\$_]*")) {
                    ReplaceRegion region = new ReplaceRegion(offset + beginIndex, simpleName.length(), simpleName);
                    regions.add(region);
                }
                position = text.indexOf(toSearch, endLink);
            }
        }
    }
}

