/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.resource;

import com.google.inject.Inject;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.xtext.diagnostics.DiagnosticMessage;
import org.eclipse.xtext.diagnostics.ExceptionDiagnostic;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.CompilerPhases;
import org.eclipse.xtext.resource.DerivedStateAwareResource;
import org.eclipse.xtext.resource.ISynchronizable;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.Triple;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.xbase.resource.BatchLinkingService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchLinkableResource
extends DerivedStateAwareResource
implements ISynchronizable<BatchLinkableResource> {
    private static final Logger log = Logger.getLogger(BatchLinkableResource.class);
    @Inject
    private BatchLinkingService batchLinkingService;
    @Inject
    private CompilerPhases compilerPhases;

    @NonNull
    public Object getLock() {
        ResourceSet resourceSet = this.getResourceSet();
        if (resourceSet instanceof ISynchronizable) {
            return ((ISynchronizable)resourceSet).getLock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <Result> Result execute(@NonNull IUnitOfWork<Result, ? super BatchLinkableResource> unit) throws Exception {
        Object object = this.getLock();
        synchronized (object) {
            return (Result)unit.exec((Object)this);
        }
    }

    public EObject getEObject(String uriFragment) {
        Object object = this.getLock();
        synchronized (object) {
            try {
                if (this.getEncoder().isCrossLinkFragment((Resource)this, uriFragment)) {
                    Triple triple = this.getEncoder().decode((Resource)this, uriFragment);
                    if (this.batchLinkingService.isBatchLinkable((EReference)triple.getSecond())) {
                        if (this.compilerPhases.isIndexing((Notifier)this)) {
                            log.error((Object)"Don't resolve expressions during indexing!", (Throwable)new IllegalStateException("Resource URI : " + this.getURI() + ", fragment : " + uriFragment));
                        }
                        return this.batchLinkingService.resolveBatched((EObject)triple.getFirst(), (EReference)triple.getSecond(), uriFragment);
                    }
                    return super.getEObject(uriFragment, triple);
                }
                return this.basicGetEObject(uriFragment);
            }
            catch (RuntimeException e) {
                this.getErrors().add((Object)new ExceptionDiagnostic((Exception)e));
                log.error((Object)("resolution of uriFragment '" + uriFragment + "' failed."), (Throwable)e);
                throw new WrappedException((Exception)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList<EObject> getContents() {
        Object object = this.getLock();
        synchronized (object) {
            if (!(!this.isLoaded || this.isLoading || this.isInitializing || this.isUpdating || this.fullyInitialized)) {
                try {
                    this.eSetDeliver(false);
                    this.installDerivedState(false);
                }
                finally {
                    this.eSetDeliver(true);
                }
            }
            return this.doGetContents();
        }
    }

    public void resolveLazyCrossReferences(CancelIndicator monitor) {
        IParseResult parseResult = this.getParseResult();
        if (parseResult != null) {
            this.batchLinkingService.resolveBatched(parseResult.getRootASTElement());
        }
        if (monitor == null || !monitor.isCanceled()) {
            super.resolveLazyCrossReferences(monitor);
        }
    }

    protected EObject handleCyclicResolution(Triple<EObject, EReference, INode> triple) throws AssertionError {
        Resource.Diagnostic diagnostic;
        DiagnosticMessage message;
        List list;
        if (!this.isValidationDisabled() && !(list = this.getDiagnosticList(message = new DiagnosticMessage("Cyclic linking detected : " + this.getReferences(triple, this.resolving), Severity.ERROR, "cyclic-resolution", new String[0]))).contains(diagnostic = this.createDiagnostic(triple, message))) {
            list.add(diagnostic);
        }
        return null;
    }
}

