/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.resource.containers;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.containers.IContainerState;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsBasedContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StateBasedContainer
extends ResourceDescriptionsBasedContainer {
    private final IContainerState state;

    public StateBasedContainer(IResourceDescriptions descriptions, IContainerState state) {
        super(descriptions);
        this.state = state;
    }

    @Override
    protected Iterable<IEObjectDescription> filterByURI(Iterable<IEObjectDescription> unfiltered) {
        return Iterables.filter(unfiltered, (Predicate)new Predicate<IEObjectDescription>(){
            private Collection<URI> contents = null;

            public boolean apply(IEObjectDescription input) {
                if (this.contents == null) {
                    this.contents = StateBasedContainer.this.state.getContents();
                }
                URI resourceURI = input.getEObjectURI().trimFragment();
                return this.contents.contains(resourceURI);
            }
        });
    }

    @Override
    public boolean hasResourceDescription(URI uri) {
        return this.state.contains(uri);
    }

    @Override
    public int getResourceDescriptionCount() {
        return this.state.getContents().size();
    }

    @Override
    public boolean isEmpty() {
        return this.state.isEmpty();
    }

    @Override
    public IResourceDescription getResourceDescription(URI uri) {
        if (this.state.contains(uri)) {
            return this.getDescriptions().getResourceDescription(uri);
        }
        return null;
    }

    @Override
    public Iterable<IResourceDescription> getResourceDescriptions() {
        if (this.state.getContents().isEmpty()) {
            return Collections.emptyList();
        }
        return this.getUriToDescription().values();
    }

    @Override
    protected Map<URI, IResourceDescription> doGetUriToDescription() {
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (URI uri : this.state.getContents()) {
            IResourceDescription description = this.getDescriptions().getResourceDescription(uri);
            if (description == null) continue;
            result.put(uri, description);
        }
        return result;
    }

    @Override
    public Iterable<IEObjectDescription> getExportedObjects() {
        if (this.state.getContents().isEmpty()) {
            return Collections.emptyList();
        }
        return super.getExportedObjects();
    }

    @Override
    public Iterable<IEObjectDescription> getExportedObjectsByType(EClass type) {
        if (this.state.getContents().isEmpty()) {
            return Collections.emptyList();
        }
        return super.getExportedObjectsByType(type);
    }

    @Override
    public Iterable<IEObjectDescription> getExportedObjectsByObject(EObject object) {
        if (this.state.getContents().isEmpty()) {
            return Collections.emptyList();
        }
        return super.getExportedObjectsByObject(object);
    }

    @Override
    public Iterable<IEObjectDescription> getExportedObjects(EClass type, QualifiedName qualifiedName, boolean ignoreCase) {
        if (this.state.getContents().isEmpty()) {
            return Collections.emptyList();
        }
        return super.getExportedObjects(type, qualifiedName, ignoreCase);
    }
}

