/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.refactoring.impl;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.ibm.icu.text.MessageFormat;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.ltk.core.refactoring.FileStatusContext;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.RefactoringStatusEntry;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.resource.ILocationInFileProvider;
import org.eclipse.xtext.ui.refactoring.impl.ProjectUtil;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.PolymorphicDispatcher;
import org.eclipse.xtext.util.SimpleAttributeResolver;
import org.eclipse.xtext.util.Strings;

public class StatusWrapper {
    @Inject
    private RefactoringStatus status;
    @Inject
    private ProjectUtil projectUtil;
    @Inject
    private ILocationInFileProvider locationInFileProvider;
    private PolymorphicDispatcher<String> toString = PolymorphicDispatcher.createForSingleTarget((String)"_toString", (Object)this);

    protected RefactoringStatusContext createContext(EObject eObject) {
        if (eObject != null) {
            ITextRegion textRegion = this.locationInFileProvider.getSignificantTextRegion(eObject);
            return this.createContext(eObject, textRegion);
        }
        return null;
    }

    protected RefactoringStatusContext createContext(EObject eObject, ITextRegion textRegion) {
        IFile file;
        Region region = null;
        if (textRegion != null) {
            region = new Region(textRegion.getOffset(), textRegion.getLength());
        }
        if ((file = this.projectUtil.findFileStorage(EcoreUtil2.getNormalizedURI((EObject)eObject), false)) == null) {
            return null;
        }
        return new FileStatusContext(file, (IRegion)region);
    }

    protected RefactoringStatusContext createContext(URI uri, ResourceSet resourceSet) {
        EObject eObject = null;
        if (resourceSet != null && uri.hasFragment()) {
            eObject = resourceSet.getEObject(uri, true);
        }
        if (eObject != null) {
            return this.createContext(eObject);
        }
        return this.createContext(this.projectUtil.findFileStorage(uri, false), null);
    }

    protected RefactoringStatusContext createContext(IFile file, ITextRegion textRegion) {
        if (file == null) {
            return null;
        }
        Region region = textRegion == null ? null : new Region(textRegion.getOffset(), textRegion.getLength());
        return new FileStatusContext(file, (IRegion)region);
    }

    protected String _toString(URI uri) {
        IFile file = this.projectUtil.findFileStorage(uri, false);
        return file != null ? file.getFullPath().toString() : uri.toString();
    }

    protected String _toString(EObject element) {
        return String.valueOf(element.eClass().getName()) + " '" + Strings.notNull((Object)SimpleAttributeResolver.NAME_RESOLVER.apply(element)) + "' in " + this._toString(element.eResource().getURI());
    }

    protected String _toString(Exception exc) {
        return Strings.notNull((Object)exc.getMessage());
    }

    protected String _toString(Object element) {
        return Strings.notNull((Object)element);
    }

    public RefactoringStatus getRefactoringStatus() {
        return this.status;
    }

    protected String format(String message, Object ... elements) {
        Object[] strings = Iterables.toArray((Iterable)Lists.transform((List)Lists.newArrayList((Object[])elements), (Function)new Function<Object, String>(){

            public String apply(Object from) {
                return (String)StatusWrapper.this.toString.invoke(new Object[]{from});
            }
        }), String.class);
        return MessageFormat.format((String)message, (Object[])strings);
    }

    public void add(int severity, String message, URI uri, ResourceSet resourceSet) {
        this.status.addEntry(new RefactoringStatusEntry(severity, this.format(message, uri), this.createContext(uri, resourceSet)));
    }

    public void add(int severity, String message, URI resourceUri) {
        this.status.addEntry(new RefactoringStatusEntry(severity, this.format(message, resourceUri), this.createContext(resourceUri, null)));
    }

    public void add(int severity, String message, EObject element) {
        this.status.addEntry(new RefactoringStatusEntry(severity, this.format(message, element), this.createContext(element)));
    }

    public void add(int severity, String message, EObject element, ITextRegion region) {
        this.status.addEntry(new RefactoringStatusEntry(severity, Strings.notNull((Object)message), this.createContext(element, region)));
    }

    public void add(int severity, String message, Exception exc, Logger log) {
        String formatted = this.format(message, exc);
        this.status.addEntry(new RefactoringStatusEntry(severity, String.valueOf(formatted) + ".\nSee log for details."));
        log.error((Object)formatted, (Throwable)exc);
    }

    public void add(int severity, String message, Object ... params) {
        this.status.addEntry(new RefactoringStatusEntry(severity, this.format(message, params)));
    }

    public void merge(RefactoringStatus status) {
        this.status.merge(status);
    }

    public void merge(StatusWrapper status) {
        this.status.merge(status.getRefactoringStatus());
    }
}

