/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator.serializer;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.generator.Naming;
import org.eclipse.xtext.generator.serializer.SyntacticSequencerPDA2ExtendedDot;
import org.eclipse.xtext.serializer.analysis.Context2NameFunction;
import org.eclipse.xtext.serializer.analysis.IContextPDAProvider;
import org.eclipse.xtext.serializer.analysis.IContextProvider;
import org.eclipse.xtext.serializer.analysis.IContextTypePDAProvider;
import org.eclipse.xtext.serializer.analysis.ISemanticSequencerNfaProvider;
import org.eclipse.xtext.serializer.analysis.ISyntacticSequencerPDAProvider;
import org.eclipse.xtext.util.formallang.Nfa;
import org.eclipse.xtext.util.formallang.NfaToDot;
import org.eclipse.xtext.util.formallang.Pda;
import org.eclipse.xtext.util.formallang.PdaToDot;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DebugGraphGenerator {
    @Inject
    private IContextProvider contextProvider;
    @Inject
    private Grammar grammar;
    @Inject
    private Naming naming;
    @Inject
    private Context2NameFunction nameFunction;
    @Inject
    private IContextPDAProvider contextPDAProvider;
    @Inject
    private IContextTypePDAProvider contextTypePDAProvider;
    @Inject
    private ISyntacticSequencerPDAProvider syntacticSequencerPDAProvider;
    @Inject
    private ISemanticSequencerNfaProvider semanticSequencerNFAProvider;
    @Inject
    private SyntacticSequencerPDA2ExtendedDot syntacticSequencerPDA2Dot;
    @Inject
    private PdaToDot pdaToDot;
    @Inject
    private NfaToDot nfaToDot;

    public Iterable<Pair<String, String>> generateDebugGraphs() {
        ArrayList _xblockexpression = null;
        ArrayList result = CollectionLiterals.newArrayList((Object[])new Pair[0]);
        List _allContexts = this.contextProvider.getAllContexts(this.grammar);
        for (EObject context : _allContexts) {
            try {
                String _file = this.file("context", context);
                Pda _contextPDA = this.contextPDAProvider.getContextPDA(context);
                String _draw = this.pdaToDot.draw((Object)_contextPDA);
                Pair _mappedTo = Pair.of((Object)_file, (Object)_draw);
                result.add(_mappedTo);
                Set _typesForContext = this.contextProvider.getTypesForContext(context);
                for (EClass type : _typesForContext) {
                    try {
                        String _file_1 = this.file("context_type", context, type);
                        Pda _contextTypePDA = this.contextTypePDAProvider.getContextTypePDA(context, type);
                        String _draw_1 = this.pdaToDot.draw((Object)_contextTypePDA);
                        Pair _mappedTo_1 = Pair.of((Object)_file_1, (Object)_draw_1);
                        result.add(_mappedTo_1);
                        String _file_2 = this.file("syntactic_sequencer", context, type);
                        ISyntacticSequencerPDAProvider.ISynAbsorberState _pDA = this.syntacticSequencerPDAProvider.getPDA(context, type);
                        String _draw_2 = this.syntacticSequencerPDA2Dot.draw(_pDA);
                        Pair _mappedTo_2 = Pair.of((Object)_file_2, (Object)_draw_2);
                        result.add(_mappedTo_2);
                        String _file_3 = this.file("semantic_sequencer", context, type);
                        Nfa _nFA = this.semanticSequencerNFAProvider.getNFA(context, type);
                        String _draw_3 = this.nfaToDot.draw((Object)_nFA);
                        Pair _mappedTo_3 = Pair.of((Object)_file_3, (Object)_draw_3);
                        result.add(_mappedTo_3);
                    }
                    catch (Throwable _t) {
                        if (_t instanceof Throwable) {
                            Throwable t = _t;
                            String _contextName = this.nameFunction.getContextName(context);
                            String _plus = "Context: " + _contextName;
                            String _plus_1 = String.valueOf(_plus) + " Type:";
                            String _name = type == null ? null : type.getName();
                            String _plus_2 = String.valueOf(_plus_1) + _name;
                            System.out.println(_plus_2);
                            t.printStackTrace();
                            continue;
                        }
                        throw Exceptions.sneakyThrow((Throwable)_t);
                    }
                }
            }
            catch (Throwable _t_1) {
                if (_t_1 instanceof Throwable) {
                    Throwable t_1 = _t_1;
                    String _contextName_1 = this.nameFunction.getContextName(context);
                    String _plus_3 = "Context: " + _contextName_1;
                    System.out.println(_plus_3);
                    t_1.printStackTrace();
                    continue;
                }
                throw Exceptions.sneakyThrow((Throwable)_t_1);
            }
        }
        _xblockexpression = result;
        return _xblockexpression;
    }

    public String directory(String name) {
        String _basePackageRuntime = this.naming.basePackageRuntime(this.grammar);
        String _asPath = this.naming.asPath(_basePackageRuntime);
        String _plus = String.valueOf(_asPath) + "/serializer/";
        String _name = this.grammar.getName();
        String _simpleName = this.naming.toSimpleName(_name);
        String _lowerCase = _simpleName.toLowerCase();
        String _plus_1 = String.valueOf(_plus) + _lowerCase;
        String _plus_2 = String.valueOf(_plus_1) + "_";
        String _plus_3 = String.valueOf(_plus_2) + name;
        String _plus_4 = String.valueOf(_plus_3) + "/";
        return _plus_4;
    }

    public String file(String name, EObject ctx, EClass type) {
        String _directory = this.directory(name);
        String _contextName = this.nameFunction.getContextName(ctx);
        String _plus = String.valueOf(_directory) + _contextName;
        String _plus_1 = String.valueOf(_plus) + "_";
        String _name = type == null ? null : type.getName();
        String _plus_2 = String.valueOf(_plus_1) + _name;
        String _plus_3 = String.valueOf(_plus_2) + ".dot";
        return _plus_3;
    }

    public String file(String name, EObject ctx) {
        String _directory = this.directory(name);
        String _contextName = this.nameFunction.getContextName(ctx);
        String _plus = String.valueOf(_directory) + _contextName;
        String _plus_1 = String.valueOf(_plus) + ".dot";
        return _plus_1;
    }
}

