/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.validation;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmTypeConstraint;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.common.types.util.Primitives;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.validation.AbstractDeclarativeValidator;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.xtype.XtypePackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JvmTypeReferencesValidator
extends AbstractDeclarativeValidator {
    @Inject
    private TypeReferences typeReferences;
    @Inject
    private Primitives primitives;

    protected List<EPackage> getEPackages() {
        return Lists.newArrayList((Object[])new EPackage[]{TypesPackage.eINSTANCE, XtypePackage.eINSTANCE});
    }

    @Check
    public void checkTypeArgumentsNotPrimitive(JvmParameterizedTypeReference typeRef) {
        EList arguments = typeRef.getArguments();
        int i = 0;
        while (i < arguments.size()) {
            JvmTypeReference jvmTypeReference = (JvmTypeReference)arguments.get(i);
            this.checkNotPrimitive(jvmTypeReference);
            ++i;
        }
    }

    @Check
    public void checkTypeArgumentsNotPrimitive(JvmTypeConstraint typeRef) {
        this.checkNotPrimitive(typeRef.getTypeReference());
    }

    protected void checkNotPrimitive(JvmTypeReference jvmTypeReference) {
        if (this.primitives.isPrimitive(jvmTypeReference)) {
            this.error("The primitive '" + jvmTypeReference.getQualifiedName('.') + "' cannot be a type argument", (EObject)jvmTypeReference, null, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_use_of_void", new String[0]);
        }
    }

    @Check
    public void checkJvmFormalParameterNotPrimitiveVoid(JvmFormalParameter param) {
        if (this.typeReferences.is(param.getParameterType(), Void.TYPE)) {
            this.error("The primitive 'void' cannot be the type of a parameter", (EObject)param.getParameterType(), null, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_use_of_void", new String[0]);
        }
    }
}

