/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtend2.ui.launching;

import com.google.inject.Inject;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.xtext.builder.DerivedResourceMarkers;
import org.eclipse.xtext.resource.FileExtensionProvider;

public class JavaElementDelegate
implements IAdaptable {
    private static final Logger log = Logger.getLogger(JavaElementDelegate.class);
    private IFileEditorInput editorInput;
    private IResource resource;
    @Inject
    private DerivedResourceMarkers derivedResourceMarkers;
    @Inject
    private FileExtensionProvider fileExtensionProvider;

    public void initializeWith(IFileEditorInput editorInput) {
        this.editorInput = editorInput;
    }

    public void initializeWith(IResource resource) {
        this.resource = resource;
    }

    public Object getAdapter(Class adapter) {
        if (IJavaElement.class.equals((Object)adapter)) {
            if (this.editorInput != null) {
                IFile file = this.editorInput.getFile();
                if (this.fileExtensionProvider.isValid(file.getFileExtension())) {
                    return this.getJavaElementForResource((IResource)file);
                }
            } else if (this.resource != null && this.fileExtensionProvider.isValid(this.resource.getFileExtension())) {
                return this.getJavaElementForResource(this.resource);
            }
        }
        return null;
    }

    protected IJavaElement getJavaElementForResource(IResource resource) {
        block3: {
            try {
                String getSourcePath = URI.createPlatformResourceURI((String)resource.getFullPath().toString(), (boolean)true).toString();
                List resources = this.derivedResourceMarkers.findDerivedResources((IContainer)resource.getProject(), getSourcePath);
                if (resources.size() >= 1) {
                    return JavaCore.create((IFile)((IFile)resources.get(0)));
                }
            }
            catch (CoreException e) {
                if (!log.isDebugEnabled()) break block3;
                log.debug((Object)e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }
}

