/*
* generated by Xtext
*/
package org.eclipse.xtext.xtend2.ui.refactoring;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.ltk.core.refactoring.resource.RenameResourceChange;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.ui.refactoring.IRefactoringUpdateAcceptor;
import org.eclipse.xtext.ui.refactoring.impl.RefactoringException;
import org.eclipse.xtext.xbase.ui.jvmmodel.refactoring.AbstractJvmModelRenameStrategy;
import org.eclipse.xtext.xtend2.xtend2.XtendClass;

/**
 * Encapsulates the model changes of a rename refactoring.
 */
@SuppressWarnings("restriction")
public class Xtend2RenameStrategy extends AbstractJvmModelRenameStrategy {

	@Override
	public void createDeclarationUpdates(String newName, ResourceSet resourceSet,
			IRefactoringUpdateAcceptor updateAcceptor) {
		super.createDeclarationUpdates(newName, resourceSet, updateAcceptor);
		IPath path = getPathToRename(getTargetElementOriginalURI(), resourceSet);
		if (path != null)
			updateAcceptor.accept(getTargetElementOriginalURI().trimFragment(), new RenameResourceChange(path, newName
					+ "." + path.getFileExtension()));
	}

	protected IPath getPathToRename(URI elementURI, ResourceSet resourceSet) {
		EObject targetObject = resourceSet.getEObject(elementURI, false);
		if (targetObject instanceof XtendClass) {
			URI resourceURI = EcoreUtil2.getNormalizedResourceURI(targetObject);
			if (!resourceURI.isPlatformResource())
				throw new RefactoringException("Renamed class does not reside in the workspace");
			IPath path = new Path("/").append(new Path(resourceURI.path()).removeFirstSegments(1));
			return path;
		}
		return null;

	}
}
