/*
* generated by Xtext
*/
package org.eclipse.xtext.xtend2.ui.labeling;

import static org.eclipse.xtext.xtend2.xtend2.Xtend2Package.Literals.*;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.ui.label.DefaultDescriptionLabelProvider;
import org.eclipse.xtext.xtend2.resource.DescriptionFlags;

import com.google.inject.Inject;

/**
 * Provides labels for a IEObjectDescriptions and IResourceDescriptions.
 * 
 * see http://www.eclipse.org/Xtext/documentation/latest/xtext.html#labelProvider
 */
public class Xtend2DescriptionLabelProvider extends DefaultDescriptionLabelProvider {

	@Inject
	private Xtend2Images images;

	@Inject
	private DescriptionFlags descriptionFlags;

	@Override
	public Object image(IEObjectDescription element) {
		EClass eClass = element.getEClass();
		if (eClass == XTEND_FILE)
			return images.forFile();
		else if (eClass == XTEND_IMPORT)
			return images.forImport();
		else if (eClass == XTEND_CLASS || eClass == TypesPackage.Literals.JVM_GENERIC_TYPE)
			return images.forClass(JvmVisibility.PUBLIC);
		else if (eClass == XTEND_FUNCTION)
			return images.forFunction(JvmVisibility.PUBLIC);
		else if (eClass == XTEND_FIELD)
			return images.forField(JvmVisibility.PUBLIC, false);
		else if (eClass == TypesPackage.Literals.JVM_OPERATION)
			return (descriptionFlags.isDispatcherOperation(element)) ? images.forDispatcherFunction(JvmVisibility.PUBLIC) : images
					.forFunction(JvmVisibility.PUBLIC);
		else
			return super.image(element);
	}

}
