/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.util;

import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XBinaryOperation;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.typing.ITypeProvider;
import org.eclipse.xtext.xbase.typing.XbaseTypeConformanceComputer;

public class XExpressionHelper {
    @Inject
    private ITypeProvider typeProvider;
    @Inject
    private XbaseTypeConformanceComputer conformanceComputer;
    @Inject
    private TypeReferences typeReferences;

    public boolean isLiteral(XExpression expr) {
        if (expr.eClass().getEPackage() != XbasePackage.eINSTANCE) {
            return false;
        }
        switch (expr.eClass().getClassifierID()) {
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 22: {
                return true;
            }
        }
        return false;
    }

    public String getAndOperator() {
        return "&&";
    }

    public String getOrOperator() {
        return "||";
    }

    public boolean isShortCircuiteBooleanOperation(XAbstractFeatureCall featureCall) {
        if (featureCall instanceof XBinaryOperation) {
            XExpression leftOperand = ((XBinaryOperation)featureCall).getLeftOperand();
            String op = featureCall.getConcreteSyntaxFeatureName();
            if (this.getAndOperator().equals(op) || this.getOrOperator().equals(op)) {
                JvmTypeReference booleanType = this.typeReferences.getTypeForName(Boolean.TYPE, (EObject)leftOperand, new JvmTypeReference[0]);
                JvmTypeReference leftOperandType = this.typeProvider.getType(leftOperand);
                JvmTypeReference operationReturnType = this.typeProvider.getType(featureCall);
                return this.conformanceComputer.isConformant(booleanType, leftOperandType) && this.conformanceComputer.isConformant(booleanType, operationReturnType);
            }
        }
        return false;
    }
}

