/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder;

import com.google.common.base.Function;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.builder.DerivedResourceMarkers;
import org.eclipse.xtext.builder.EclipseOutputConfigurationProvider;
import org.eclipse.xtext.builder.EclipseResourceFileSystemAccess2;
import org.eclipse.xtext.builder.IXtextBuilderParticipant;
import org.eclipse.xtext.builder.preferences.BuilderPreferenceAccess;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.IGenerator;
import org.eclipse.xtext.generator.OutputConfiguration;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.ui.resource.IStorage2UriMapper;
import org.eclipse.xtext.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuilderParticipant
implements IXtextBuilderParticipant {
    @Inject
    private Provider<EclipseResourceFileSystemAccess2> fileSystemAccessProvider;
    @Inject
    private IGenerator generator;
    @Inject
    private IResourceServiceProvider resourceServiceProvider;
    @Inject
    private IStorage2UriMapper storage2UriMapper;
    @Inject
    private DerivedResourceMarkers derivedResourceMarkers;
    private EclipseOutputConfigurationProvider outputConfigurationProvider;
    private BuilderPreferenceAccess builderPreferenceAccess;

    public BuilderPreferenceAccess getBuilderPreferenceAccess() {
        return this.builderPreferenceAccess;
    }

    @Inject
    public void setBuilderPreferenceAccess(BuilderPreferenceAccess builderPreferenceAccess) {
        this.builderPreferenceAccess = builderPreferenceAccess;
    }

    public EclipseOutputConfigurationProvider getOutputConfigurationProvider() {
        return this.outputConfigurationProvider;
    }

    @Inject
    public void setOutputConfigurationProvider(EclipseOutputConfigurationProvider outputConfigurationProvider) {
        this.outputConfigurationProvider = outputConfigurationProvider;
    }

    @Override
    public void build(final IXtextBuilderParticipant.IBuildContext context, IProgressMonitor monitor) throws CoreException {
        if (!this.isEnabled(context)) {
            return;
        }
        int numberOfDeltas = context.getDeltas().size();
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(numberOfDeltas + 3));
        EclipseResourceFileSystemAccess2 access = (EclipseResourceFileSystemAccess2)((Object)this.fileSystemAccessProvider.get());
        IProject builtProject = context.getBuiltProject();
        access.setProject(builtProject);
        Map<String, OutputConfiguration> outputConfigurations = this.getOutputConfigurations(context);
        this.refreshOutputFolders(context, outputConfigurations, (IProgressMonitor)subMonitor.newChild(1));
        access.setOutputConfigurations(outputConfigurations);
        if (context.getBuildType() == IXtextBuilderParticipant.BuildType.CLEAN || context.getBuildType() == IXtextBuilderParticipant.BuildType.RECOVERY) {
            SubMonitor cleanMonitor = SubMonitor.convert((IProgressMonitor)subMonitor.newChild(1), (int)outputConfigurations.size());
            for (OutputConfiguration config : outputConfigurations.values()) {
                this.cleanOutput(context, config, (IProgressMonitor)cleanMonitor.newChild(1));
            }
            if (context.getBuildType() == IXtextBuilderParticipant.BuildType.CLEAN) {
                return;
            }
        }
        int i = 0;
        while (i < numberOfDeltas) {
            IResourceDescription.Delta delta = context.getDeltas().get(i);
            if (subMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            subMonitor.subTask("Compiling " + delta.getUri().lastSegment() + " (" + i + " of " + numberOfDeltas + ")");
            access.setMonitor((IProgressMonitor)subMonitor.newChild(1));
            final String uri = delta.getUri().toString();
            final LinkedHashSet derivedResources = Sets.newLinkedHashSet();
            for (OutputConfiguration config : outputConfigurations.values()) {
                if (!config.isCleanUpDerivedResources()) continue;
                List<IFile> resources = this.derivedResourceMarkers.findDerivedResources((IContainer)builtProject.getFolder(config.getOutputDirectory()), uri);
                derivedResources.addAll(resources);
            }
            access.setPostProcessor(new EclipseResourceFileSystemAccess2.IFileCallback(){

                public boolean beforeFileDeletion(IFile file) {
                    derivedResources.remove(file);
                    context.needRebuild();
                    return true;
                }

                public void afterFileUpdate(IFile file) {
                    this.handleFileAccess(file);
                }

                public void afterFileCreation(IFile file) {
                    this.handleFileAccess(file);
                }

                protected void handleFileAccess(IFile file) {
                    try {
                        derivedResources.remove(file);
                        BuilderParticipant.this.derivedResourceMarkers.installMarker(file, uri);
                        context.needRebuild();
                    }
                    catch (CoreException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            if (delta.getNew() != null) {
                this.handleChangedContents(delta, context, access);
            }
            SubMonitor deleteMonitor = SubMonitor.convert((IProgressMonitor)subMonitor.newChild(1), (int)derivedResources.size());
            for (IFile iFile : derivedResources) {
                IMarker marker = this.derivedResourceMarkers.findDerivedResourceMarker(iFile, uri);
                if (marker != null) {
                    marker.delete();
                }
                if (this.derivedResourceMarkers.findDerivedResourceMarkers(iFile).length != 0) continue;
                iFile.delete(2, (IProgressMonitor)deleteMonitor.newChild(1));
                context.needRebuild();
            }
            ++i;
        }
    }

    protected boolean isEnabled(IXtextBuilderParticipant.IBuildContext context) {
        return this.builderPreferenceAccess.isAutoBuildEnabled(context.getBuiltProject());
    }

    protected void refreshOutputFolders(IXtextBuilderParticipant.IBuildContext ctx, Map<String, OutputConfiguration> outputConfigurations, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)outputConfigurations.size());
        for (OutputConfiguration config : outputConfigurations.values()) {
            SubMonitor child = subMonitor.newChild(1);
            IProject project = ctx.getBuiltProject();
            IFolder folder = project.getFolder(config.getOutputDirectory());
            folder.refreshLocal(2, (IProgressMonitor)child);
        }
    }

    protected void cleanOutput(IXtextBuilderParticipant.IBuildContext ctx, OutputConfiguration config, IProgressMonitor monitor) throws CoreException {
        block4: {
            IFolder folder;
            block3: {
                IProject project = ctx.getBuiltProject();
                folder = project.getFolder(config.getOutputDirectory());
                if (!folder.exists()) {
                    return;
                }
                if (!config.isCanClearOutputDirectory()) break block3;
                IResource[] iResourceArray = folder.members();
                int n = iResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource resource = iResourceArray[n2];
                    resource.delete(2, monitor);
                    ++n2;
                }
                break block4;
            }
            if (!config.isCleanUpDerivedResources()) break block4;
            List<IFile> resources = this.derivedResourceMarkers.findDerivedResources((IContainer)folder, null);
            for (IFile iFile : resources) {
                iFile.delete(2, monitor);
            }
        }
    }

    protected void handleChangedContents(IResourceDescription.Delta delta, IXtextBuilderParticipant.IBuildContext context, EclipseResourceFileSystemAccess2 fileSystemAccess) throws CoreException {
        if (!this.resourceServiceProvider.canHandle(delta.getUri())) {
            return;
        }
        Resource resource = context.getResourceSet().getResource(delta.getUri(), true);
        if (this.shouldGenerate(resource, context)) {
            try {
                this.generator.doGenerate(resource, (IFileSystemAccess)fileSystemAccess);
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof CoreException) {
                    throw (CoreException)e.getCause();
                }
                throw e;
            }
        }
    }

    protected boolean shouldGenerate(Resource resource, IXtextBuilderParticipant.IBuildContext context) {
        try {
            Iterable storages = this.storage2UriMapper.getStorages(resource.getURI());
            for (Pair pair : storages) {
                if (!(pair.getFirst() instanceof IFile) || !((IProject)pair.getSecond()).equals((Object)context.getBuiltProject())) continue;
                return ((IFile)pair.getFirst()).findMaxProblemSeverity(null, true, 2) != 2;
            }
            return false;
        }
        catch (CoreException exc) {
            throw new WrappedException((Exception)((Object)exc));
        }
    }

    protected Map<String, OutputConfiguration> getOutputConfigurations(IXtextBuilderParticipant.IBuildContext context) {
        Set<OutputConfiguration> configurations = this.outputConfigurationProvider.getOutputConfigurations(context.getBuiltProject());
        return Maps.uniqueIndex(configurations, (Function)new Function<OutputConfiguration, String>(){

            public String apply(OutputConfiguration from) {
                return from.getName();
            }
        });
    }
}

