/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.resource;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.core.IJarEntryResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;

public abstract class PackageFragmentRootWalker<T> {
    public T traverse(IPackageFragmentRoot root, boolean stopOnFirstResult) throws JavaModelException {
        T result = null;
        if (root.exists()) {
            IJavaElement[] children;
            Object[] resources = root.getNonJavaResources();
            TraversalState state = new TraversalState(root);
            Object[] objectArray = resources;
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (object instanceof IJarEntryResource) {
                    result = this.traverse((IJarEntryResource)object, stopOnFirstResult, state);
                    if (stopOnFirstResult && result != null) {
                        return result;
                    }
                }
                ++n2;
            }
            IJavaElement[] iJavaElementArray = children = root.getChildren();
            int n3 = children.length;
            n = 0;
            while (n < n3) {
                IJavaElement javaElement = iJavaElementArray[n];
                if (javaElement instanceof IPackageFragment) {
                    result = this.traverse((IPackageFragment)javaElement, stopOnFirstResult, state);
                    if (stopOnFirstResult && result != null) {
                        return result;
                    }
                }
                ++n;
            }
        }
        return result;
    }

    protected T traverse(IPackageFragment pack, boolean stopOnFirstResult, TraversalState state) throws JavaModelException {
        Object[] resources;
        IJavaElement[] children;
        T result = null;
        state.push(pack);
        IJavaElement[] iJavaElementArray = children = pack.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement iJavaElement = iJavaElementArray[n2];
            if (iJavaElement instanceof IPackageFragment) {
                result = this.traverse((IPackageFragment)iJavaElement, stopOnFirstResult, state);
                if (stopOnFirstResult && result != null) {
                    return result;
                }
            }
            ++n2;
        }
        Object[] objectArray = resources = pack.getNonJavaResources();
        int n3 = resources.length;
        n = 0;
        while (n < n3) {
            Object object = objectArray[n];
            if (object instanceof IJarEntryResource) {
                result = this.traverse((IJarEntryResource)object, stopOnFirstResult, state);
                if (stopOnFirstResult && result != null) {
                    return result;
                }
            }
            ++n;
        }
        state.pop();
        return result;
    }

    protected T traverse(IJarEntryResource jarEntry, boolean stopOnFirstResult, TraversalState state) {
        T result = null;
        if (jarEntry.isFile()) {
            result = this.handle(jarEntry, state);
        } else {
            IJarEntryResource[] children;
            state.push(jarEntry);
            IJarEntryResource[] iJarEntryResourceArray = children = jarEntry.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IJarEntryResource child = iJarEntryResourceArray[n2];
                result = this.traverse(child, stopOnFirstResult, state);
                if (stopOnFirstResult && result != null) {
                    return result;
                }
                ++n2;
            }
            state.pop();
        }
        return result;
    }

    protected abstract T handle(IJarEntryResource var1, TraversalState var2);

    public static class TraversalState {
        private List<Object> parents;

        TraversalState(Object obj) {
            this.parents = Lists.newArrayList((Object[])new Object[]{obj});
        }

        public List<?> getParents() {
            return Collections.unmodifiableList(this.parents);
        }

        void pop() {
            this.parents.remove(this.parents.size() - 1);
        }

        void push(Object obj) {
            this.parents.add(obj);
        }
    }
}

