/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.validation;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.validation.IValidationIssueProcessor;
import org.eclipse.xtext.ui.editor.validation.Messages;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.concurrent.CancelableUnitOfWork;
import org.eclipse.xtext.util.concurrent.IReadAccess;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;

public class ValidationJob
extends Job {
    private static final Logger log = Logger.getLogger(ValidationJob.class);
    public static final Object XTEXT_VALIDATION_FAMILY = new Object();
    protected static final Map<?, ?> DEFAULT_VALIDATION_CONTEXT = ImmutableMap.of((Object)"check.mode", (Object)CheckMode.FAST_ONLY);
    private final IResourceValidator resourceValidator;
    private final IReadAccess<XtextResource> xtextDocument;
    private final IValidationIssueProcessor validationIssueProcessor;
    private final CheckMode checkMode;

    public ValidationJob(IResourceValidator xtextResourceChecker, IReadAccess<XtextResource> xtextDocument, IValidationIssueProcessor validationIssueProcessor, CheckMode checkMode) {
        super(Messages.ValidationJob_0);
        this.xtextDocument = xtextDocument;
        this.resourceValidator = xtextResourceChecker;
        this.validationIssueProcessor = validationIssueProcessor;
        this.checkMode = checkMode;
    }

    public boolean belongsTo(Object family) {
        return family == XTEXT_VALIDATION_FAMILY;
    }

    protected IStatus run(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        List<Issue> issues = null;
        try {
            issues = this.createIssues(monitor);
        }
        catch (OperationCanceledException canceled) {
            return Status.CANCEL_STATUS;
        }
        catch (Exception e) {
            log.error((Object)"Error running validator", (Throwable)e);
            return Status.OK_STATUS;
        }
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        this.validationIssueProcessor.processIssues(issues, monitor);
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    public List<Issue> createIssues(final IProgressMonitor monitor) {
        List issues = (List)this.xtextDocument.readOnly((IUnitOfWork)new CancelableUnitOfWork<List<Issue>, XtextResource>(){

            public List<Issue> exec(XtextResource resource, final CancelIndicator outerIndicator) throws Exception {
                if (resource == null || resource.isValidationDisabled()) {
                    return Collections.emptyList();
                }
                return ValidationJob.this.resourceValidator.validate((Resource)resource, ValidationJob.this.getCheckMode(), new CancelIndicator(){

                    public boolean isCanceled() {
                        return outerIndicator.isCanceled() || monitor.isCanceled();
                    }
                });
            }
        });
        return issues;
    }

    protected IResourceValidator getResourceValidator() {
        return this.resourceValidator;
    }

    protected IReadAccess<XtextResource> getXtextDocument() {
        return this.xtextDocument;
    }

    public CheckMode getCheckMode() {
        return this.checkMode;
    }
}

