/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.internal;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.typesystem.IResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.internal.AbstractBatchTypeResolver;
import org.eclipse.xtext.xbase.typesystem.internal.AbstractRootedReentrantTypeResolver;
import org.eclipse.xtext.xbase.typesystem.internal.CompoundReentrantTypeResolver;
import org.eclipse.xtext.xbase.typesystem.internal.IReentrantTypeResolver;
import org.eclipse.xtext.xbase.typesystem.internal.TypeResolutionStateAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultBatchTypeResolver
extends AbstractBatchTypeResolver {
    @Inject
    private Provider<AbstractRootedReentrantTypeResolver> typeResolverProvider;

    @Override
    protected IResolvedTypes doResolveTypes(EObject object, CancelIndicator monitor) {
        EObject nonArtificialObject = this.getNonArtificialObject(object);
        IReentrantTypeResolver reentrantResolver = this.getTypeResolver(nonArtificialObject);
        return reentrantResolver.reentrantResolve(monitor == null ? CancelIndicator.NullImpl : monitor);
    }

    private EObject getNonArtificialObject(EObject object) {
        EObject nonArtificialObject = object;
        if (object.eResource() == null && object instanceof XAbstractFeatureCall) {
            nonArtificialObject = ((XAbstractFeatureCall)object).getFeature();
        }
        return nonArtificialObject;
    }

    protected IReentrantTypeResolver getTypeResolver(EObject object) {
        List<EObject> roots = this.getEntryPoints(object);
        if (roots.size() == 1) {
            AbstractRootedReentrantTypeResolver result = this.getOrCreateResolver(roots.get(0));
            return result;
        }
        if (roots.isEmpty()) {
            return IReentrantTypeResolver.NULL;
        }
        CompoundReentrantTypeResolver result = new CompoundReentrantTypeResolver();
        for (EObject root : roots) {
            result.addResolver(this.getOrCreateResolver(root));
        }
        return result;
    }

    protected List<EObject> getEntryPoints(EObject object) {
        EObject rootContainer = EcoreUtil.getRootContainer((EObject)object);
        if (rootContainer instanceof XExpression) {
            return Collections.singletonList(rootContainer);
        }
        return Collections.emptyList();
    }

    protected AbstractRootedReentrantTypeResolver getOrCreateResolver(EObject root) {
        EList adapters = root.eAdapters();
        TypeResolutionStateAdapter currentAdapter = (TypeResolutionStateAdapter)EcoreUtil.getAdapter((List)adapters, TypeResolutionStateAdapter.class);
        if (currentAdapter == null) {
            AbstractRootedReentrantTypeResolver newResolver = this.createResolver();
            TypeResolutionStateAdapter newAdapter = new TypeResolutionStateAdapter(root, newResolver);
            AbstractRootedReentrantTypeResolver result = new AbstractRootedReentrantTypeResolver((List)adapters, newAdapter, newResolver){
                private int reentrance = 0;
                private final /* synthetic */ List val$adapters;
                private final /* synthetic */ TypeResolutionStateAdapter val$newAdapter;
                private final /* synthetic */ AbstractRootedReentrantTypeResolver val$newResolver;
                {
                    this.val$adapters = list;
                    this.val$newAdapter = typeResolutionStateAdapter;
                    this.val$newResolver = abstractRootedReentrantTypeResolver;
                }

                public IResolvedTypes reentrantResolve(CancelIndicator monitor) {
                    RuntimeException e = null;
                    try {
                        IResolvedTypes result;
                        ++this.reentrance;
                        IResolvedTypes iResolvedTypes = result = this.val$newResolver.reentrantResolve(monitor);
                        return iResolvedTypes;
                    }
                    catch (RuntimeException caught) {
                        e = caught;
                        throw caught;
                    }
                    finally {
                        --this.reentrance;
                        if (this.reentrance == 0 && !this.val$adapters.remove(this.val$newAdapter)) {
                            if (e != null) {
                                throw new IllegalStateException("The TypeResolutionStateAdapter was removed while resolving", e);
                            }
                            throw new IllegalStateException("The TypeResolutionStateAdapter was removed while resolving");
                        }
                    }
                }

                public void initializeFrom(EObject root) {
                    this.val$newResolver.initializeFrom(root);
                }

                protected EObject getRoot() {
                    return this.val$newResolver.getRoot();
                }

                protected boolean isHandled(JvmIdentifiableElement identifiableElement) {
                    return this.val$newResolver.isHandled(identifiableElement);
                }

                protected boolean isHandled(EObject context) {
                    return this.val$newResolver.isHandled(context);
                }

                protected boolean isHandled(XExpression expression) {
                    return this.val$newResolver.isHandled(expression);
                }
            };
            result.initializeFrom(root);
            return result;
        }
        return currentAdapter;
    }

    protected AbstractRootedReentrantTypeResolver createResolver() {
        return (AbstractRootedReentrantTypeResolver)this.typeResolverProvider.get();
    }
}

