/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.internal;

import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeAssigner;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeComputationState;
import org.eclipse.xtext.xbase.typesystem.internal.AbstractTypeComputationState;
import org.eclipse.xtext.xbase.typesystem.internal.CompoundTypeComputationState;
import org.eclipse.xtext.xbase.typesystem.internal.TypeAssigner;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;

public class CompoundTypeAssigner
implements ITypeAssigner {
    private final TypeAssigner[] assigners;
    private final ITypeReferenceOwner owner;

    public CompoundTypeAssigner(ITypeReferenceOwner owner, TypeAssigner[] assigners) {
        this.owner = owner;
        this.assigners = assigners;
    }

    public void assignType(JvmIdentifiableElement element, LightweightTypeReference actualType) {
        TypeAssigner[] typeAssignerArray = this.assigners;
        int n = this.assigners.length;
        int n2 = 0;
        while (n2 < n) {
            TypeAssigner assigner = typeAssignerArray[n2];
            assigner.assignType(element, actualType);
            ++n2;
        }
    }

    public ITypeComputationState getForkedState() {
        AbstractTypeComputationState[] states = new AbstractTypeComputationState[this.assigners.length];
        int i = 0;
        while (i < states.length) {
            states[i] = this.assigners[i].getForkedState();
            ++i;
        }
        return new CompoundTypeComputationState(this.owner, states);
    }

    public LightweightTypeReference toLightweightTypeReference(JvmTypeReference reference) {
        return this.owner.toLightweightTypeReference(reference);
    }

    public ITypeReferenceOwner getReferenceOwner() {
        return this.owner;
    }
}

