/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.validation;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeConstraint;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmVoid;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.common.types.util.Primitives;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.validation.AbstractDeclarativeValidator;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelAssociations;
import org.eclipse.xtext.xbase.validation.ProxyAwareUIStrings;
import org.eclipse.xtext.xtype.XFunctionTypeRef;
import org.eclipse.xtext.xtype.XtypePackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JvmTypeReferencesValidator
extends AbstractDeclarativeValidator {
    @Inject
    private TypeReferences typeReferences;
    @Inject
    private Primitives primitives;
    @Inject
    private IJvmModelAssociations jvmModelAssociations;
    @Inject
    private ProxyAwareUIStrings proxyAwareUIStrings;

    protected List<EPackage> getEPackages() {
        return Lists.newArrayList((Object[])new EPackage[]{TypesPackage.eINSTANCE, XtypePackage.eINSTANCE});
    }

    @Check
    public void checkTypeArgumentsNotPrimitive(JvmParameterizedTypeReference typeRef) {
        EList arguments = typeRef.getArguments();
        int i = 0;
        while (i < arguments.size()) {
            JvmTypeReference jvmTypeReference = (JvmTypeReference)arguments.get(i);
            this.checkNotPrimitive(jvmTypeReference);
            ++i;
        }
    }

    @Check
    public void checkTypeArgsAgainstTypeParameters(JvmParameterizedTypeReference typeRef) {
        JvmType type = typeRef.getType();
        if (type instanceof JvmGenericType && !type.eIsProxy()) {
            int numTypeParameters = ((JvmGenericType)type).getTypeParameters().size();
            if (typeRef.getArguments().size() > 0) {
                if (numTypeParameters == 0) {
                    this.errorTypeIsNotGeneric(type, typeRef);
                } else if (numTypeParameters != typeRef.getArguments().size()) {
                    StringBuilder message = new StringBuilder(64);
                    message.append("Incorrect number of arguments for type ");
                    message = this.proxyAwareUIStrings.appendTypeSignature(type, message);
                    message.append("; it cannot be parameterized with arguments ");
                    message = this.proxyAwareUIStrings.appendTypeArguments(typeRef, message);
                    if (message != null) {
                        this.error(message.toString(), "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_number_of_type_arguments", typeRef);
                    }
                }
            } else if (numTypeParameters > 0) {
                this.warnRawType(type, typeRef);
            }
        } else if (type != null && !type.eIsProxy() && !typeRef.getArguments().isEmpty()) {
            this.errorTypeIsNotGeneric(type, typeRef);
        }
    }

    protected void warnRawType(JvmType type, JvmParameterizedTypeReference typeRef) {
        StringBuilder message = new StringBuilder(64);
        message.append(type.getSimpleName());
        message.append(" is a raw type. References to generic type ");
        message = this.proxyAwareUIStrings.appendTypeSignature(type, message);
        message.append(" should be parameterized");
        this.warning(message.toString(), "org.eclipse.xtext.xbase.validation.IssueCodes.raw_type", typeRef);
    }

    protected void errorTypeIsNotGeneric(JvmType type, JvmParameterizedTypeReference typeRef) {
        StringBuilder message = new StringBuilder(64);
        message.append("The type ");
        message = this.proxyAwareUIStrings.appendTypeSignature(type, message);
        message.append(" is not generic; it cannot be parameterized with arguments ");
        message = this.proxyAwareUIStrings.appendTypeArguments(typeRef, message);
        if (message != null) {
            this.error(message.toString(), "org.eclipse.xtext.xbase.validation.IssueCodes.type_argument_on_non_generic_type", typeRef);
        }
    }

    protected void warning(String message, String issueCode, JvmParameterizedTypeReference typeReference) {
        EObject rootContainer = EcoreUtil.getRootContainer((EObject)typeReference);
        Resource resource = rootContainer.eResource();
        if (resource.getContents().get(0) == rootContainer) {
            super.warning(message, (EObject)typeReference, (EStructuralFeature)TypesPackage.Literals.JVM_PARAMETERIZED_TYPE_REFERENCE__TYPE, -1, issueCode, new String[0]);
        } else {
            JvmParameterizedTypeReference container = typeReference;
            EObject sourceElement = this.jvmModelAssociations.getPrimarySourceElement((EObject)container);
            container = container.eContainer();
            while (sourceElement == null && container != null) {
                sourceElement = this.jvmModelAssociations.getPrimarySourceElement((EObject)container);
                container = container.eContainer();
            }
            if (sourceElement != null) {
                this.warning(message, sourceElement, sourceElement.eClass().getEStructuralFeature("name"), -1, issueCode, new String[0]);
            } else {
                super.warning(message, (EObject)typeReference, (EStructuralFeature)TypesPackage.Literals.JVM_PARAMETERIZED_TYPE_REFERENCE__TYPE, -1, issueCode, new String[0]);
            }
        }
    }

    protected void error(String message, String issueCode, JvmParameterizedTypeReference typeReference) {
        EObject rootContainer = EcoreUtil.getRootContainer((EObject)typeReference);
        Resource resource = rootContainer.eResource();
        if (resource.getContents().get(0) == rootContainer) {
            super.error(message, (EObject)typeReference, (EStructuralFeature)TypesPackage.Literals.JVM_PARAMETERIZED_TYPE_REFERENCE__TYPE, -1, issueCode, new String[0]);
        } else {
            JvmParameterizedTypeReference container = typeReference;
            EObject sourceElement = this.jvmModelAssociations.getPrimarySourceElement((EObject)container);
            container = container.eContainer();
            while (sourceElement == null && container != null) {
                sourceElement = this.jvmModelAssociations.getPrimarySourceElement((EObject)container);
                container = container.eContainer();
            }
            if (sourceElement != null) {
                this.error(message, sourceElement, sourceElement.eClass().getEStructuralFeature("name"), -1, issueCode, new String[0]);
            } else {
                super.error(message, (EObject)typeReference, (EStructuralFeature)TypesPackage.Literals.JVM_PARAMETERIZED_TYPE_REFERENCE__TYPE, -1, issueCode, new String[0]);
            }
        }
    }

    @Check
    public void checkTypeArgumentsNotPrimitive(JvmTypeConstraint typeRef) {
        this.checkNotPrimitive(typeRef.getTypeReference());
    }

    protected void checkNotPrimitive(JvmTypeReference jvmTypeReference) {
        if (this.primitives.isPrimitive(jvmTypeReference)) {
            this.error("The primitive '" + jvmTypeReference.getQualifiedName('.') + "' cannot be a type argument", (EObject)jvmTypeReference, null, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_use_of_void", new String[0]);
        }
    }

    @Check
    public void checkJvmFormalParameterNotPrimitiveVoid(JvmFormalParameter param) {
        if (this.typeReferences.is(param.getParameterType(), Void.TYPE)) {
            this.error("The primitive 'void' cannot be the type of a parameter", (EObject)param.getParameterType(), null, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_use_of_void", new String[0]);
        }
    }

    @Check
    public void checkFunctionTypeArgsNonVoid(XFunctionTypeRef typeRef) {
        for (JvmTypeReference paramType : typeRef.getParamTypes()) {
            JvmType type = paramType.getType();
            if (!(type instanceof JvmVoid) || type.eIsProxy()) continue;
            this.error("The primitive 'void' cannot be the type of a function parameter. ", (EObject)paramType, null, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_use_of_void", new String[0]);
        }
    }
}

