/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.util.formallang;

import com.google.common.base.Function;
import org.eclipse.xtext.util.GraphvizDotBuilder;
import org.eclipse.xtext.util.formallang.Nfa;
import org.eclipse.xtext.util.formallang.NfaUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NfaToDot<STATE>
extends GraphvizDotBuilder {
    protected Function<STATE, String> stateFormatter;

    protected GraphvizDotBuilder.Node create(GraphvizDotBuilder.Digraph result, Nfa<STATE> nfa, STATE state) {
        GraphvizDotBuilder.Node n = new GraphvizDotBuilder.Node(state, this.stateToString(nfa, state));
        if (state == nfa.getStart() || state == nfa.getStop()) {
            n.setShape("point");
        }
        return n;
    }

    protected GraphvizDotBuilder.Edge create(GraphvizDotBuilder.Digraph result, Nfa<STATE> nfa, STATE from, STATE to) {
        return new GraphvizDotBuilder.Edge(from, to);
    }

    protected void draw(GraphvizDotBuilder.Digraph result, Nfa<STATE> nfa) {
        for (STATE s : new NfaUtil().collect(nfa)) {
            result.add(this.create(result, nfa, s));
            for (STATE f : nfa.getFollowers(s)) {
                result.add(this.create(result, nfa, s, f));
            }
        }
    }

    @Override
    protected GraphvizDotBuilder.Props drawObject(Object obj) {
        GraphvizDotBuilder.Digraph result = new GraphvizDotBuilder.Digraph();
        if (obj instanceof Nfa) {
            this.draw(result, (Nfa)obj);
        }
        return result;
    }

    public NfaToDot<STATE> setStateFormatter(Function<STATE, String> stateFormatter) {
        this.stateFormatter = stateFormatter;
        return this;
    }

    protected String stateToString(Nfa<STATE> nfa, STATE state) {
        if (this.stateFormatter != null) {
            return (String)this.stateFormatter.apply(state);
        }
        if (state == null) {
            return "null";
        }
        return state.toString();
    }
}

