/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.m2e;

import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import org.apache.maven.plugin.MojoExecution;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.m2e.core.project.configurator.AbstractProjectConfigurator;
import org.eclipse.m2e.core.project.configurator.ProjectConfigurationRequest;
import org.eclipse.xtext.builder.preferences.BuilderPreferenceAccess;
import org.eclipse.xtext.generator.OutputConfiguration;
import org.eclipse.xtext.m2e.Language;
import org.eclipse.xtext.m2e.Languages;
import org.eclipse.xtext.m2e.OutputConfiguration;
import org.osgi.service.prefs.BackingStoreException;

public class XtextProjectConfigurator
extends AbstractProjectConfigurator {
    public void configure(ProjectConfigurationRequest request, IProgressMonitor monitor) throws CoreException {
        XtextProjectConfigurator.addNature((IProject)request.getProject(), (String)"org.eclipse.xtext.ui.shared.xtextNature", (IProgressMonitor)monitor);
        this.configureLanguages(request, monitor);
    }

    private void configureLanguages(ProjectConfigurationRequest request, IProgressMonitor monitor) throws CoreException {
        for (MojoExecution execution : this.getMojoExecutions(request, monitor)) {
            Languages languages = (Languages)this.getParameterValue("languages", Languages.class, request.getMavenSession(), execution);
            ProjectScope projectPreferences = new ProjectScope(request.getProject());
            for (Language language : languages) {
                this.configureLanguage(projectPreferences, language);
            }
        }
    }

    private void configureLanguage(ProjectScope projectPreferences, Language language) throws CoreException {
        if (language.getOutputConfigurations().isEmpty()) {
            return;
        }
        IEclipsePreferences languagePreferences = projectPreferences.getNode(language.name());
        languagePreferences.putBoolean("is_project_specific", true);
        languagePreferences.putBoolean("autobuilding", true);
        for (OutputConfiguration outputConfiguration : language.getOutputConfigurations()) {
            this.configureOutlet(languagePreferences, outputConfiguration);
        }
        try {
            languagePreferences.flush();
        }
        catch (BackingStoreException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private void configureOutlet(IEclipsePreferences languagePreferences, OutputConfiguration mavenConfiguration) {
        org.eclipse.xtext.generator.OutputConfiguration configuration = mavenConfiguration.toGeneratorConfiguration();
        languagePreferences.put(BuilderPreferenceAccess.getKey((org.eclipse.xtext.generator.OutputConfiguration)configuration, (String)"name"), configuration.getName());
        languagePreferences.put(BuilderPreferenceAccess.getKey((org.eclipse.xtext.generator.OutputConfiguration)configuration, (String)"description"), configuration.getDescription());
        languagePreferences.put(BuilderPreferenceAccess.getKey((org.eclipse.xtext.generator.OutputConfiguration)configuration, (String)"directory"), configuration.getOutputDirectory());
        languagePreferences.putBoolean(BuilderPreferenceAccess.getKey((org.eclipse.xtext.generator.OutputConfiguration)configuration, (String)"derived"), configuration.isSetDerivedProperty());
        languagePreferences.putBoolean(BuilderPreferenceAccess.getKey((org.eclipse.xtext.generator.OutputConfiguration)configuration, (String)"createDirectory"), configuration.isCreateOutputDirectory());
        languagePreferences.putBoolean(BuilderPreferenceAccess.getKey((org.eclipse.xtext.generator.OutputConfiguration)configuration, (String)"cleanDirectory"), configuration.isCanClearOutputDirectory());
        languagePreferences.putBoolean(BuilderPreferenceAccess.getKey((org.eclipse.xtext.generator.OutputConfiguration)configuration, (String)"override"), configuration.isOverrideExistingResources());
        languagePreferences.putBoolean(BuilderPreferenceAccess.getKey((org.eclipse.xtext.generator.OutputConfiguration)configuration, (String)"cleanupDerived"), configuration.isCleanUpDerivedResources());
        languagePreferences.putBoolean(BuilderPreferenceAccess.getKey((org.eclipse.xtext.generator.OutputConfiguration)configuration, (String)"installDslAsPrimarySource"), configuration.isInstallDslAsPrimarySource());
        languagePreferences.putBoolean(BuilderPreferenceAccess.getKey((org.eclipse.xtext.generator.OutputConfiguration)configuration, (String)"hideLocalSyntheticVariables"), configuration.isHideSyntheticLocalVariables());
        languagePreferences.putBoolean(BuilderPreferenceAccess.getKey((org.eclipse.xtext.generator.OutputConfiguration)configuration, (String)"keepLocalHistory"), configuration.isKeepLocalHistory().booleanValue());
        languagePreferences.putBoolean(BuilderPreferenceAccess.getKey((org.eclipse.xtext.generator.OutputConfiguration)configuration, (String)"userOutputPerSourceFolder"), configuration.isUseOutputPerSourceFolder());
        for (OutputConfiguration.SourceMapping sourceMapping : configuration.getSourceMappings()) {
            languagePreferences.put(BuilderPreferenceAccess.getOutputForSourceFolderKey((org.eclipse.xtext.generator.OutputConfiguration)configuration, (String)sourceMapping.getSourceFolder()), Strings.nullToEmpty((String)sourceMapping.getOutputDirectory()));
            languagePreferences.putBoolean(BuilderPreferenceAccess.getIgnoreSourceFolderKey((org.eclipse.xtext.generator.OutputConfiguration)configuration, (String)sourceMapping.getSourceFolder()), sourceMapping.isIgnore());
        }
    }
}

