/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.smap;

import com.google.common.collect.Lists;
import com.google.common.io.ByteStreams;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IRegion;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.compiler.BuildContext;
import org.eclipse.jdt.core.compiler.CompilationParticipant;
import org.eclipse.jdt.internal.core.Region;
import org.eclipse.xtext.builder.EclipseOutputConfigurationProvider;
import org.eclipse.xtext.builder.trace.AbstractTrace;
import org.eclipse.xtext.generator.OutputConfiguration;
import org.eclipse.xtext.generator.trace.AbstractTraceRegion;
import org.eclipse.xtext.generator.trace.ITrace;
import org.eclipse.xtext.generator.trace.ITraceForStorageProvider;
import org.eclipse.xtext.generator.trace.ITraceToBytecodeInstaller;
import org.eclipse.xtext.generator.trace.TraceAsPrimarySourceInstaller;
import org.eclipse.xtext.generator.trace.TraceAsSmapInstaller;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.ui.XtextProjectHelper;
import org.eclipse.xtext.ui.util.ResourceUtil;
import org.eclipse.xtext.util.internal.Stopwatches;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DebugSourceInstallingCompilationParticipant
extends CompilationParticipant {
    private static final Logger log = Logger.getLogger(DebugSourceInstallingCompilationParticipant.class);
    private List<BuildContext> files;
    @Inject
    private IResourceServiceProvider.Registry serviceProviderRegistry;
    @Inject
    private Provider<TraceAsSmapInstaller> traceAsSmapInstaller;
    @Inject
    private Provider<TraceAsPrimarySourceInstaller> traceAsPrimarySourceInstallerProvider;
    @Inject
    private ITraceForStorageProvider traceInformation;

    protected OutputConfiguration findOutputConfiguration(URI dslSourceFile, IFile generatedJavaFile) {
        IProject project;
        IResourceServiceProvider serviceProvider = this.serviceProviderRegistry.getResourceServiceProvider(dslSourceFile);
        if (serviceProvider == null) {
            return null;
        }
        EclipseOutputConfigurationProvider cfgProvider = (EclipseOutputConfigurationProvider)((Object)serviceProvider.get(EclipseOutputConfigurationProvider.class));
        Set<OutputConfiguration> configurations = cfgProvider.getOutputConfigurations(project = generatedJavaFile.getProject());
        if (!configurations.isEmpty()) {
            if (configurations.size() == 1) {
                return configurations.iterator().next();
            }
            for (OutputConfiguration out : configurations) {
                for (String source : out.getSourceFolders()) {
                    IContainer container = ResourceUtil.getContainer((IProject)project, (String)out.getOutputDirectory(source));
                    if (container == null || !container.getFullPath().isPrefixOf(generatedJavaFile.getFullPath())) continue;
                    return out;
                }
            }
        }
        log.error((Object)("Could not find output configuration for file " + generatedJavaFile.getFullPath()));
        return null;
    }

    protected ITraceToBytecodeInstaller getInstaller(OutputConfiguration config) {
        if (config.isInstallDslAsPrimarySource()) {
            TraceAsPrimarySourceInstaller installer = (TraceAsPrimarySourceInstaller)this.traceAsPrimarySourceInstallerProvider.get();
            installer.setHideSyntheticVariables(config.isHideSyntheticLocalVariables());
            return installer;
        }
        TraceAsSmapInstaller installer = (TraceAsSmapInstaller)this.traceAsSmapInstaller.get();
        return installer;
    }

    public void buildFinished(IJavaProject project) {
        Stopwatches.StoppedTask task = Stopwatches.forTask((String)"DebugSourceInstallingCompilationParticipant.install");
        try {
            task.start();
            super.buildFinished(project);
            if (this.files == null) {
                return;
            }
            for (BuildContext ctx : this.files) {
                try {
                    IJavaElement element;
                    URI dslSourceFile;
                    OutputConfiguration outputConfiguration;
                    IFile generatedJavaFile = ctx.getFile();
                    AbstractTraceRegion traceToSource = this.findRootTraceRegion(generatedJavaFile);
                    if (traceToSource == null || (outputConfiguration = this.findOutputConfiguration(dslSourceFile = traceToSource.getAssociatedPath(), generatedJavaFile)) == null || (element = JavaCore.create((IFile)generatedJavaFile)) == null) continue;
                    this.deleteTaskMarkers(generatedJavaFile);
                    ITraceToBytecodeInstaller installer = this.getInstaller(outputConfiguration);
                    installer.setTrace(generatedJavaFile.getName(), traceToSource);
                    for (IFile javaClassFile : this.findGeneratedJavaClassFiles(element)) {
                        InputStream contents = javaClassFile.getContents();
                        try {
                            byte[] byteCode = installer.installTrace(ByteStreams.toByteArray((InputStream)contents));
                            javaClassFile.setContents((InputStream)new ByteArrayInputStream(byteCode), 0, null);
                        }
                        finally {
                            contents.close();
                        }
                    }
                }
                catch (Exception e) {
                    String msg = "Could not process %s to install source information: %s";
                    log.error((Object)String.format(msg, ctx.getFile().getFullPath().toString(), e.getMessage()), (Throwable)e);
                }
            }
        }
        finally {
            this.files = null;
            task.stop();
        }
    }

    protected void deleteTaskMarkers(IFile generatedJavaFile) throws CoreException {
        generatedJavaFile.deleteMarkers("org.eclipse.jdt.core.task", false, 0);
    }

    public void buildStarting(BuildContext[] files, boolean isBatch) {
        super.buildStarting(files, isBatch);
        if (this.files != null) {
            this.files.addAll(Arrays.asList(files));
        } else {
            this.files = Lists.newArrayList((Object[])files);
        }
    }

    protected List<IFile> findGeneratedJavaClassFiles(IJavaElement element) {
        Region region = new Region();
        region.add(element);
        LinkedList result = Lists.newLinkedList();
        IResource[] iResourceArray = JavaCore.getGeneratedResources((IRegion)region, (boolean)false);
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource res = iResourceArray[n2];
            if (res instanceof IFile) {
                result.add((IFile)res);
            }
            ++n2;
        }
        return result;
    }

    protected AbstractTraceRegion findRootTraceRegion(IFile javaFile) {
        ITrace traceToSource = this.traceInformation.getTraceToSource((IStorage)javaFile);
        if (!(traceToSource instanceof AbstractTrace)) {
            return null;
        }
        return ((AbstractTrace)traceToSource).getRootTraceRegion();
    }

    public boolean isActive(IJavaProject project) {
        return XtextProjectHelper.hasNature((IProject)project.getProject());
    }
}

