/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.quickfix;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtend.core.xtend.XtendClass;
import org.eclipse.xtend.core.xtend.XtendMember;
import org.eclipse.xtend.ide.codebuilder.AbstractConstructorBuilder;
import org.eclipse.xtend.ide.codebuilder.AbstractFieldBuilder;
import org.eclipse.xtend.ide.codebuilder.AbstractMethodBuilder;
import org.eclipse.xtend.ide.codebuilder.CodeBuilderFactory;
import org.eclipse.xtend.ide.quickfix.CodeBuilderQuickfix;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmPrimitiveType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.common.types.util.Primitives;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.edit.IModification;
import org.eclipse.xtext.ui.editor.model.edit.IModificationContext;
import org.eclipse.xtext.ui.editor.model.edit.ISemanticModification;
import org.eclipse.xtext.ui.editor.model.edit.SemanticModificationWrapper;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionAcceptor;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XAssignment;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.compiler.StringBuilderBasedAppendable;
import org.eclipse.xtext.xbase.jvmmodel.ILogicalContainerProvider;
import org.eclipse.xtext.xbase.scoping.featurecalls.OperatorMapping;
import org.eclipse.xtext.xbase.typesystem.IBatchTypeResolver;
import org.eclipse.xtext.xbase.typesystem.IResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.legacy.StandardTypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.CommonTypeComputationServices;
import org.eclipse.xtext.xbase.typesystem.util.LocalTypeSubstitutor;
import org.eclipse.xtext.xbase.ui.contentassist.ReplacingAppendable;
import org.eclipse.xtext.xbase.ui.document.DocumentSourceAppender;
import org.eclipse.xtext.xbase.ui.quickfix.ILinkingIssueQuickfixProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateMemberQuickfixes
implements ILinkingIssueQuickfixProvider {
    @Inject
    private CommonTypeComputationServices services;
    @Inject
    private IBatchTypeResolver typeResolver;
    @Inject
    private ReplacingAppendable.Factory appendableFactory;
    @Inject
    private Primitives primitives;
    @Inject
    private ILogicalContainerProvider logicalContainerProvider;
    @Inject
    private OperatorMapping operatorMapping;
    @Inject
    private CodeBuilderFactory codeBuilderFactory;
    @Inject
    private CodeBuilderQuickfix quickfixFactory;

    public void addQuickfixes(Issue issue, IssueResolutionAcceptor issueResolutionAcceptor, IXtextDocument xtextDocument, XtextResource resource, EObject referenceOwner, EReference unresolvedReference) throws Exception {
        if (referenceOwner instanceof XAbstractFeatureCall) {
            String operatorMethodName;
            JvmIdentifiableElement feature;
            String newMemberName;
            XAbstractFeatureCall call = (XAbstractFeatureCall)referenceOwner;
            String string = newMemberName = issue.getData() != null && issue.getData().length > 0 ? issue.getData()[0] : null;
            if (newMemberName != null) {
                if (call instanceof XMemberFeatureCall) {
                    if (!call.isExplicitOperationCallOrBuilderSyntax()) {
                        this.newFieldQuickfix(newMemberName, call, issue, issueResolutionAcceptor);
                        this.newGetterQuickfixes(newMemberName, call, issue, issueResolutionAcceptor);
                    }
                    this.newMethodQuickfixes(newMemberName, call, issue, issueResolutionAcceptor);
                } else if (call instanceof XFeatureCall) {
                    if (!call.isExplicitOperationCallOrBuilderSyntax()) {
                        if (this.logicalContainerProvider.getNearestLogicalContainer((EObject)call) instanceof JvmExecutable) {
                            this.newLocalVariableQuickfix(newMemberName, call, issue, issueResolutionAcceptor);
                        }
                        this.newFieldQuickfix(newMemberName, call, issue, issueResolutionAcceptor);
                        this.newGetterQuickfixes(newMemberName, call, issue, issueResolutionAcceptor);
                    }
                    this.newMethodQuickfixes(newMemberName, call, issue, issueResolutionAcceptor);
                } else if (call instanceof XAssignment) {
                    this.newSetterQuickfix(issue, issueResolutionAcceptor, newMemberName, call);
                    XAssignment assigment = (XAssignment)call;
                    if (assigment.getAssignable() == null) {
                        this.newLocalVariableQuickfix(newMemberName, call, issue, issueResolutionAcceptor);
                        this.newFieldQuickfix(newMemberName, call, issue, issueResolutionAcceptor);
                    } else if (this.isThis(assigment)) {
                        this.newFieldQuickfix(newMemberName, call, issue, issueResolutionAcceptor);
                    }
                }
            }
            if (call.isOperation() && (feature = call.getFeature()).eIsProxy() && (operatorMethodName = this.getOperatorMethodName(call)) != null) {
                this.newMethodQuickfixes(operatorMethodName, call, issue, issueResolutionAcceptor);
            }
            if (call instanceof XFeatureCall && call.getFeature() instanceof JvmConstructor) {
                this.newConstructorQuickfix(issue, issueResolutionAcceptor, (XFeatureCall)call);
            }
        }
        if (referenceOwner instanceof XConstructorCall) {
            this.newConstructorQuickfix(issue, issueResolutionAcceptor, (XConstructorCall)referenceOwner);
        }
    }

    protected boolean isThis(XAssignment assigment) {
        XExpression assignable = assigment.getAssignable();
        if (!(assignable instanceof XAbstractFeatureCall)) {
            return false;
        }
        XAbstractFeatureCall featureCall = (XAbstractFeatureCall)assignable;
        return featureCall.getFeature() instanceof JvmDeclaredType && !featureCall.isExplicitOperationCallOrBuilderSyntax() && !featureCall.isTypeLiteral();
    }

    protected String getAccessorMethodName(String prefix, String fieldName) {
        return String.valueOf(prefix) + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
    }

    protected boolean isStaticAccess(XAbstractFeatureCall call) {
        if (call instanceof XMemberFeatureCall) {
            XAbstractFeatureCall targetCall;
            XMemberFeatureCall featureCall = (XMemberFeatureCall)call;
            if (featureCall.isExplicitStatic()) {
                return true;
            }
            if (featureCall.getMemberCallTarget() instanceof XAbstractFeatureCall && (targetCall = (XAbstractFeatureCall)featureCall.getMemberCallTarget()).isTypeLiteral()) {
                return true;
            }
        }
        return this.isStatic(this.logicalContainerProvider.getNearestLogicalContainer((EObject)call));
    }

    protected boolean isStatic(JvmIdentifiableElement element) {
        if (element instanceof JvmOperation) {
            return ((JvmOperation)element).isStatic();
        }
        if (element instanceof JvmField) {
            return ((JvmField)element).isStatic();
        }
        return false;
    }

    protected LightweightTypeReference getNewMemberType(XAbstractFeatureCall call) {
        IResolvedTypes resolvedTypes = this.typeResolver.resolveTypes((EObject)call);
        if (call instanceof XAssignment) {
            XExpression value = ((XAssignment)call).getValue();
            return resolvedTypes.getActualType(value);
        }
        return resolvedTypes.getExpectedType((XExpression)call);
    }

    protected LightweightTypeReference getReceiverType(XAbstractFeatureCall featureCall) {
        XExpression actualReceiver = featureCall.getActualReceiver();
        StandardTypeReferenceOwner owner = new StandardTypeReferenceOwner(this.services, (EObject)featureCall);
        if (actualReceiver == null) {
            return new ParameterizedTypeReference((ITypeReferenceOwner)owner, (JvmType)this.getCallersType((XExpression)featureCall));
        }
        if (actualReceiver instanceof XAbstractFeatureCall && ((XAbstractFeatureCall)actualReceiver).isTypeLiteral()) {
            JvmType type = (JvmType)((XAbstractFeatureCall)actualReceiver).getFeature();
            ParameterizedTypeReference reference = new ParameterizedTypeReference((ITypeReferenceOwner)owner, type);
            return reference;
        }
        LightweightTypeReference typeRef = this.typeResolver.resolveTypes((EObject)featureCall).getActualType(actualReceiver);
        if (typeRef != null && typeRef.getType() instanceof JvmDeclaredType) {
            return typeRef;
        }
        return null;
    }

    protected JvmDeclaredType getCallersType(XExpression call) {
        JvmIdentifiableElement nearestLogicalContainer = this.logicalContainerProvider.getNearestLogicalContainer((EObject)call);
        return (JvmDeclaredType)EcoreUtil2.getContainerOfType((EObject)nearestLogicalContainer, JvmDeclaredType.class);
    }

    protected String getOperatorMethodName(XAbstractFeatureCall call) {
        for (INode node : NodeModelUtils.findNodesForFeature((EObject)call, (EStructuralFeature)XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE)) {
            for (ILeafNode leafNode : node.getLeafNodes()) {
                String symbol;
                QualifiedName methodName;
                if (leafNode.isHidden() || (methodName = this.operatorMapping.getMethodName(QualifiedName.create((String)(symbol = leafNode.getText())))) == null) continue;
                return methodName.getFirstSegment();
            }
        }
        return null;
    }

    protected void newLocalVariableQuickfix(final String variableName, XAbstractFeatureCall call, Issue issue, IssueResolutionAcceptor issueResolutionAcceptor) {
        LightweightTypeReference variableType = this.getNewMemberType(call);
        StringBuilderBasedAppendable localVarDescriptionBuilder = new StringBuilderBasedAppendable();
        localVarDescriptionBuilder.append((CharSequence)"...").newLine();
        final String defaultValueLiteral = this.getDefaultValueLiteral(variableType);
        localVarDescriptionBuilder.append((CharSequence)"val ").append((CharSequence)variableName).append((CharSequence)" = ").append((CharSequence)defaultValueLiteral);
        localVarDescriptionBuilder.newLine().append((CharSequence)"...");
        issueResolutionAcceptor.accept(issue, "Create local variable '" + variableName + "'", localVarDescriptionBuilder.toString(), "fix_local_var.png", (IModification)new SemanticModificationWrapper(issue.getUriToProblem(), new ISemanticModification(){

            public void apply(EObject element, IModificationContext context) throws Exception {
                XtendMember xtendMember;
                if (element != null && (xtendMember = (XtendMember)EcoreUtil2.getContainerOfType((EObject)element, XtendMember.class)) != null) {
                    int offset = CreateMemberQuickfixes.this.getFirstOffsetOfKeyword((EObject)xtendMember, "{");
                    IXtextDocument xtextDocument = context.getXtextDocument();
                    if (offset != -1 && xtextDocument != null) {
                        ReplacingAppendable appendable = (ReplacingAppendable)CreateMemberQuickfixes.this.appendableFactory.create(xtextDocument, (XtextResource)element.eResource(), offset, 0, new DocumentSourceAppender.Factory.OptionalParameters(){
                            {
                                this.baseIndentationLevel = 1;
                            }
                        });
                        appendable.increaseIndentation().newLine().append((CharSequence)"val ").append((CharSequence)variableName).append((CharSequence)" = ").append((CharSequence)defaultValueLiteral);
                        appendable.commitChanges();
                    }
                }
            }
        }));
    }

    protected void newMethodQuickfixes(String newMemberName, XAbstractFeatureCall call, Issue issue, IssueResolutionAcceptor issueResolutionAcceptor) {
        JvmDeclaredType callersType = this.getCallersType((XExpression)call);
        LightweightTypeReference receiverType = this.getReceiverType(call);
        LightweightTypeReference returnType = this.getNewMemberType(call);
        if (callersType == null || receiverType == null) {
            return;
        }
        List<LightweightTypeReference> argumentTypes = this.getResolvedArgumentTypes((EObject)call, this.logicalContainerProvider.getNearestLogicalContainer((EObject)call), (List<XExpression>)call.getActualArguments());
        this.newMethodQuickfixes(receiverType, newMemberName, returnType, argumentTypes, call, callersType, issue, issueResolutionAcceptor);
    }

    protected void newMethodQuickfixes(LightweightTypeReference containerType, String name, LightweightTypeReference returnType, List<LightweightTypeReference> argumentTypes, XAbstractFeatureCall call, JvmDeclaredType callersType, Issue issue, IssueResolutionAcceptor issueResolutionAcceptor) {
        boolean isLocal = callersType == containerType.getType();
        boolean isStatic = this.isStaticAccess(call);
        boolean isAbstract = true;
        if (containerType.getType() instanceof JvmGenericType) {
            isAbstract = !((JvmGenericType)containerType.getType()).isInstantiateable();
        } else if (containerType.getType() instanceof JvmDeclaredType) {
            isAbstract = ((JvmDeclaredType)containerType.getType()).isAbstract();
        }
        if (containerType.getType() instanceof JvmDeclaredType) {
            JvmDeclaredType declaredType = (JvmDeclaredType)containerType.getType();
            this.newMethodQuickfix(declaredType, name, returnType, argumentTypes, isStatic, isAbstract, false, isLocal, call, issue, issueResolutionAcceptor);
        }
        if (!isLocal && !isStatic) {
            ArrayList extensionMethodParameterTypes = Lists.newArrayList(argumentTypes);
            extensionMethodParameterTypes.add(0, containerType);
            this.newMethodQuickfix(callersType, name, returnType, extensionMethodParameterTypes, false, isAbstract, true, true, call, issue, issueResolutionAcceptor);
        }
    }

    protected void newMethodQuickfix(JvmDeclaredType containerType, String name, LightweightTypeReference returnType, List<LightweightTypeReference> parameterTypes, boolean isStatic, boolean isAbstract, boolean isExtension, boolean isLocal, XAbstractFeatureCall call, Issue issue, IssueResolutionAcceptor issueResolutionAcceptor) {
        AbstractMethodBuilder methodBuilder = this.codeBuilderFactory.createMethodBuilder(containerType);
        methodBuilder.setMethodName(name);
        methodBuilder.setReturnType(returnType);
        for (LightweightTypeReference parameterType : parameterTypes) {
            methodBuilder.newParameterBuilder().setType(parameterType);
        }
        methodBuilder.setContext((EObject)call);
        methodBuilder.setVisibility(JvmVisibility.PUBLIC);
        methodBuilder.setStaticFlag(isStatic);
        methodBuilder.setAbstractFlag(isAbstract);
        StringBuffer label = new StringBuffer("Create ");
        if (isStatic) {
            label.append("static ");
        }
        if (isExtension) {
            label.append("extension ");
        }
        label.append("method '").append(name).append("(");
        boolean isFirst = true;
        for (LightweightTypeReference parameterType : parameterTypes) {
            if (!isFirst) {
                label.append(", ");
            }
            isFirst = false;
            label.append(parameterType.getSimpleName());
        }
        label.append(")'");
        if (!isLocal) {
            label.append(" in '" + containerType.getSimpleName() + "'");
        }
        this.quickfixFactory.addQuickfix(methodBuilder, label.toString(), issue, issueResolutionAcceptor);
    }

    protected void newSetterQuickfix(Issue issue, IssueResolutionAcceptor issueResolutionAcceptor, String newMemberName, XAbstractFeatureCall call) {
        this.newMethodQuickfixes(this.getAccessorMethodName("set", newMemberName), call, issue, issueResolutionAcceptor);
    }

    protected void newGetterQuickfixes(String name, XAbstractFeatureCall call, Issue issue, IssueResolutionAcceptor issueResolutionAcceptor) {
        JvmDeclaredType callersType = this.getCallersType((XExpression)call);
        LightweightTypeReference receiverType = this.getReceiverType(call);
        LightweightTypeReference fieldType = this.getNewMemberType(call);
        if (callersType != null && receiverType != null) {
            this.newMethodQuickfixes(receiverType, this.getAccessorMethodName("get", name), fieldType, Collections.<LightweightTypeReference>emptyList(), call, callersType, issue, issueResolutionAcceptor);
        }
    }

    protected void newFieldQuickfix(String name, XAbstractFeatureCall call, Issue issue, IssueResolutionAcceptor issueResolutionAcceptor) {
        JvmDeclaredType callersType = this.getCallersType((XExpression)call);
        LightweightTypeReference receiverType = this.getReceiverType(call);
        LightweightTypeReference fieldType = this.getNewMemberType(call);
        if (callersType != null && receiverType != null && callersType == receiverType.getType()) {
            this.newFieldQuickfix(callersType, name, fieldType, this.isStaticAccess(call), call, issue, issueResolutionAcceptor);
        }
    }

    protected void newFieldQuickfix(JvmDeclaredType containerType, String name, LightweightTypeReference fieldType, boolean isStatic, XAbstractFeatureCall call, Issue issue, IssueResolutionAcceptor issueResolutionAcceptor) {
        AbstractFieldBuilder fieldBuilder = this.codeBuilderFactory.createFieldBuilder(containerType);
        fieldBuilder.setFieldName(name);
        fieldBuilder.setFieldType(fieldType);
        fieldBuilder.setContext((EObject)call);
        fieldBuilder.setVisibility(JvmVisibility.PRIVATE);
        fieldBuilder.setStaticFlag(isStatic);
        StringBuilder label = new StringBuilder("Create ");
        if (isStatic) {
            label.append("static ");
        }
        label.append("field '").append(name).append("'");
        this.quickfixFactory.addQuickfix(fieldBuilder, label.toString(), issue, issueResolutionAcceptor);
    }

    protected void newConstructorQuickfix(Issue issue, IssueResolutionAcceptor issueResolutionAcceptor, XConstructorCall call) {
        JvmDeclaredType ownerType = call.getConstructor().getDeclaringType();
        this.newConstructorQuickfix(issue, issueResolutionAcceptor, ownerType, (XExpression)call, (List<XExpression>)call.getArguments());
    }

    protected void newConstructorQuickfix(Issue issue, IssueResolutionAcceptor issueResolutionAcceptor, XFeatureCall call) {
        JvmDeclaredType ownerType = ((JvmConstructor)call.getFeature()).getDeclaringType();
        this.newConstructorQuickfix(issue, issueResolutionAcceptor, ownerType, (XExpression)call, (List<XExpression>)call.getActualArguments());
    }

    protected void newConstructorQuickfix(Issue issue, IssueResolutionAcceptor issueResolutionAcceptor, JvmDeclaredType ownerType, XExpression call, List<XExpression> arguments) {
        if (ownerType != null) {
            List<LightweightTypeReference> parameterTypes = this.getResolvedArgumentTypes((EObject)call, this.logicalContainerProvider.getNearestLogicalContainer((EObject)call), arguments);
            AbstractConstructorBuilder constructorBuilder = this.codeBuilderFactory.createConstructorBuilder(ownerType);
            constructorBuilder.setContext((EObject)call);
            for (LightweightTypeReference parameterType : parameterTypes) {
                constructorBuilder.newParameterBuilder().setType(parameterType);
            }
            constructorBuilder.setVisibility(JvmVisibility.PUBLIC);
            StringBuffer label = new StringBuffer("Create constructor '");
            if (constructorBuilder.getOwnerSource() instanceof XtendClass) {
                label.append("new");
            } else {
                label.append(ownerType.getSimpleName());
            }
            label.append("(");
            boolean isFirst = true;
            for (LightweightTypeReference parameterType : parameterTypes) {
                if (!isFirst) {
                    label.append(", ");
                }
                isFirst = false;
                label.append(parameterType.getSimpleName());
            }
            label.append(")'");
            if (this.getCallersType(call) != ownerType) {
                label.append(" in '").append(ownerType.getSimpleName()).append("'");
            }
            this.quickfixFactory.addQuickfix(constructorBuilder, label.toString(), issue, issueResolutionAcceptor);
        }
    }

    protected int getFirstOffsetOfKeyword(EObject object, String keyword) {
        int offset = -1;
        ICompositeNode node = NodeModelUtils.getNode((EObject)object);
        if (node != null) {
            for (ILeafNode leafNode : node.getLeafNodes()) {
                if (!(leafNode.getGrammarElement() instanceof Keyword) || !Strings.equal((String)keyword, (String)((Keyword)leafNode.getGrammarElement()).getValue())) continue;
                return leafNode.getOffset() + 1;
            }
        }
        return offset;
    }

    protected String getDefaultValueLiteral(LightweightTypeReference type) {
        if (type != null && type.isPrimitive()) {
            Primitives.Primitive primitiveKind = this.primitives.primitiveKind((JvmPrimitiveType)type.getType());
            if (primitiveKind == Primitives.Primitive.Boolean) {
                return "false";
            }
            return "0 as " + type.getSimpleName();
        }
        return "null";
    }

    protected List<LightweightTypeReference> getResolvedArgumentTypes(EObject context, JvmIdentifiableElement logicalContainer, List<XExpression> arguments) {
        ArrayList argumentTypes = Lists.newArrayList();
        IResolvedTypes resolvedTypes = this.typeResolver.resolveTypes(context);
        for (XExpression argument : arguments) {
            LightweightTypeReference resolved = resolvedTypes.getActualType(argument);
            if (resolved == null) {
                StandardTypeReferenceOwner owner = new StandardTypeReferenceOwner(this.services, context);
                argumentTypes.add(new ParameterizedTypeReference((ITypeReferenceOwner)owner, this.services.getTypeReferences().findDeclaredType(Object.class, (Notifier)context)));
                continue;
            }
            LocalTypeSubstitutor substitutor = new LocalTypeSubstitutor(resolved.getOwner(), logicalContainer);
            argumentTypes.add(substitutor.withoutLocalTypes(resolved));
        }
        return argumentTypes;
    }
}

