/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.outline;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.xtend.core.jvmmodel.DispatchHelper;
import org.eclipse.xtend.core.jvmmodel.IXtendJvmAssociations;
import org.eclipse.xtend.core.xtend.XtendClass;
import org.eclipse.xtend.core.xtend.XtendFile;
import org.eclipse.xtend.core.xtend.XtendFunction;
import org.eclipse.xtend.core.xtend.XtendMember;
import org.eclipse.xtend.core.xtend.XtendPackage;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtend.ide.labeling.XtendImages;
import org.eclipse.xtend.ide.outline.XtendFeatureNode;
import org.eclipse.xtend.ide.outline.XtendOutlineNodeFactory;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.ui.editor.outline.IOutlineNode;
import org.eclipse.xtext.ui.editor.outline.IOutlineTreeProvider;
import org.eclipse.xtext.ui.editor.outline.impl.BackgroundOutlineTreeProvider;
import org.eclipse.xtext.ui.editor.outline.impl.DocumentRootNode;
import org.eclipse.xtext.ui.editor.outline.impl.EObjectNode;
import org.eclipse.xtext.ui.editor.outline.impl.OutlineMode;
import org.eclipse.xtext.xbase.jvmmodel.JvmTypeExtensions;
import org.eclipse.xtext.xbase.ui.labeling.XbaseImageAdornments;
import org.eclipse.xtext.xtype.XtypePackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XtendOutlineTreeProvider
extends BackgroundOutlineTreeProvider
implements IOutlineTreeProvider.ModeAware {
    private static final OutlineMode HIDE_INHERITED_MODE = new OutlineMode("hide", "hide inherited members");
    private static final OutlineMode SHOW_INHERITED_MODE = new OutlineMode("show", "show inherited members");
    private static final List<OutlineMode> MODES = Lists.newArrayList((Object[])new OutlineMode[]{HIDE_INHERITED_MODE, SHOW_INHERITED_MODE});
    @Inject
    private XtendImages images;
    @Inject
    private XbaseImageAdornments adornments;
    @Inject
    private IXtendJvmAssociations associations;
    @Inject
    private DispatchHelper dispatchHelper;
    @Inject
    private JvmTypeExtensions typeExtensions;
    @Inject
    private XtendOutlineNodeFactory factory;
    private int currentModeIndex = 0;

    protected void internalCreateChildren(DocumentRootNode parentNode, EObject modelElement) {
        if (modelElement instanceof XtendFile) {
            XtendFile xtendFile = (XtendFile)modelElement;
            if (xtendFile.getPackage() != null) {
                this.factory.createEStructuralFeatureNode((IOutlineNode)parentNode, (EObject)xtendFile, (EStructuralFeature)XtendPackage.Literals.XTEND_FILE__PACKAGE, this.images.forPackage(), xtendFile.getPackage(), true);
            }
            if (xtendFile.getImportSection() != null && !xtendFile.getImportSection().getImportDeclarations().isEmpty()) {
                this.factory.createEStructuralFeatureNode((IOutlineNode)parentNode, (EObject)xtendFile.getImportSection(), (EStructuralFeature)XtypePackage.Literals.XIMPORT_SECTION__IMPORT_DECLARATIONS, this.images.forImportContainer(), "import declarations", false);
            }
            for (XtendTypeDeclaration xtendType : xtendFile.getXtendTypes()) {
                this.createNodeForType((IOutlineNode)parentNode, xtendType);
            }
        }
    }

    private void createNodeForType(IOutlineNode parentNode, XtendTypeDeclaration xtendType) {
        EObjectNode classNode = this.createNode(parentNode, (EObject)xtendType);
        this.createFeatureNodes((IOutlineNode)classNode, xtendType);
    }

    protected void createFeatureNodes(IOutlineNode parentNode, XtendTypeDeclaration xtendType) {
        JvmDeclaredType inferredType = this.associations.getInferredType(xtendType);
        if (inferredType != null) {
            HashSet processedFeatures = Sets.newHashSet();
            this.createFeatureNodesForType(parentNode, xtendType, inferredType, inferredType, processedFeatures, 0);
        } else {
            for (XtendMember member : xtendType.getMembers()) {
                this.createNode(parentNode, (EObject)member);
            }
        }
    }

    protected void createFeatureNodesForType(IOutlineNode parentNode, XtendTypeDeclaration xtendType, JvmDeclaredType inferredType, final JvmDeclaredType baseType, Set<JvmFeature> processedFeatures, int inheritanceDepth) {
        if (xtendType != null) {
            for (XtendTypeDeclaration nestedType : Iterables.filter((Iterable)xtendType.getMembers(), XtendTypeDeclaration.class)) {
                this.createNodeForType(parentNode, nestedType);
            }
        }
        if (xtendType instanceof XtendClass) {
            for (JvmOperation operation : inferredType.getDeclaredOperations()) {
                List dispatchCases;
                JvmOperation dispatcher;
                XtendFeatureNode dispatcherNode;
                if (!this.dispatchHelper.isDispatcherFunction(operation) || (dispatcherNode = this.createNodeForFeature(parentNode, baseType, (JvmFeature)(dispatcher = operation), (EObject)dispatcher, inheritanceDepth)) == null) continue;
                dispatcherNode.setDispatch(true);
                this.addJvmFeature(processedFeatures, (JvmFeature)dispatcher);
                boolean inheritsDispatchCases = false;
                if (this.getCurrentMode() == SHOW_INHERITED_MODE) {
                    dispatchCases = this.dispatchHelper.getAllDispatchCases(dispatcher);
                } else {
                    dispatchCases = Lists.newArrayList((Iterable)this.dispatchHelper.getLocalDispatchCases(dispatcher));
                    Collections.sort(dispatchCases, new Comparator<JvmOperation>(){

                        @Override
                        public int compare(JvmOperation o1, JvmOperation o2) {
                            return baseType.getMembers().indexOf((Object)o1) - baseType.getMembers().indexOf((Object)o2);
                        }
                    });
                }
                for (JvmOperation dispatchCase : dispatchCases) {
                    inheritsDispatchCases |= dispatchCase.getDeclaringType() != baseType;
                    XtendFunction xtendFunction = this.associations.getXtendFunction(dispatchCase);
                    if (xtendFunction == null) {
                        this.createNodeForFeature((IOutlineNode)dispatcherNode, baseType, (JvmFeature)dispatchCase, (EObject)dispatchCase, inheritanceDepth);
                    } else {
                        this.createNodeForFeature((IOutlineNode)dispatcherNode, baseType, (JvmFeature)dispatchCase, (EObject)xtendFunction, inheritanceDepth);
                    }
                    this.addJvmFeature(processedFeatures, (JvmFeature)dispatchCase);
                }
                if (!inheritsDispatchCases) continue;
                dispatcherNode.setImageDescriptor(this.images.forDispatcherFunction(dispatcher.getVisibility(), this.adornments.get((JvmIdentifiableElement)dispatcher) | 0x80));
            }
        }
        for (JvmFeature feature : Iterables.filter((Iterable)inferredType.getMembers(), JvmFeature.class)) {
            if (processedFeatures.contains(feature)) continue;
            EObject primarySourceElement = this.associations.getPrimarySourceElement((EObject)feature);
            this.createNodeForFeature(parentNode, baseType, feature, (EObject)(primarySourceElement != null ? primarySourceElement : feature), inheritanceDepth);
            this.addJvmFeature(processedFeatures, feature);
        }
        if (this.getCurrentMode() == SHOW_INHERITED_MODE && inferredType instanceof JvmGenericType) {
            JvmTypeReference extendedClass = ((JvmGenericType)inferredType).getExtendedClass();
            if (extendedClass != null) {
                this.createInheritedFeatureNodes(parentNode, baseType, processedFeatures, inheritanceDepth, extendedClass);
            }
            for (JvmTypeReference extendedInterface : ((JvmGenericType)inferredType).getExtendedInterfaces()) {
                this.createInheritedFeatureNodes(parentNode, baseType, processedFeatures, inheritanceDepth, extendedInterface);
            }
        }
    }

    private void addJvmFeature(Set<JvmFeature> processedFeatures, JvmFeature feature) {
        processedFeatures.add(feature);
        this.addCreateExtensionJvmFeatures(processedFeatures, feature);
    }

    private void addCreateExtensionJvmFeatures(Set<JvmFeature> processedFeatures, JvmFeature feature) {
        EObject sourceElement = this.associations.getPrimarySourceElement((EObject)feature);
        if (!(sourceElement instanceof XtendFunction)) {
            return;
        }
        XtendFunction function = (XtendFunction)sourceElement;
        if (function.getCreateExtensionInfo() == null) {
            return;
        }
        for (EObject jvmElement : this.associations.getJvmElements((EObject)function)) {
            if (jvmElement == feature || !(jvmElement instanceof JvmFeature)) continue;
            JvmFeature jvmFeature = (JvmFeature)jvmElement;
            if (jvmFeature.getSimpleName().startsWith("_createCache_")) {
                processedFeatures.add(jvmFeature);
            }
            if (!jvmFeature.getSimpleName().startsWith("_init_")) continue;
            processedFeatures.add(jvmFeature);
        }
    }

    protected void createInheritedFeatureNodes(IOutlineNode parentNode, JvmDeclaredType baseType, Set<JvmFeature> processedFeatures, int inheritanceDepth, JvmTypeReference superType) {
        if (superType.getType() instanceof JvmDeclaredType) {
            JvmGenericType superClass = (JvmGenericType)superType.getType();
            EObject xtendSuperClass = this.associations.getPrimarySourceElement((EObject)superType.getType());
            this.createFeatureNodesForType(parentNode, (XtendTypeDeclaration)xtendSuperClass, (JvmDeclaredType)superClass, baseType, processedFeatures, inheritanceDepth + 1);
        }
    }

    protected XtendFeatureNode createNodeForFeature(IOutlineNode parentNode, JvmDeclaredType inferredType, JvmFeature jvmFeature, EObject semanticFeature, int inheritanceDepth) {
        boolean synthetic = this.typeExtensions.isSynthetic((JvmIdentifiableElement)jvmFeature);
        Object text = this.getText(synthetic ? jvmFeature : semanticFeature);
        ImageDescriptor image = this.getImageDescriptor(synthetic ? jvmFeature : semanticFeature);
        if (jvmFeature.getDeclaringType() != inferredType) {
            if (this.getCurrentMode() == SHOW_INHERITED_MODE) {
                StyledString label = text instanceof StyledString ? (StyledString)text : new StyledString(text.toString());
                label.append(new StyledString(" - " + jvmFeature.getDeclaringType().getIdentifier(), StyledString.QUALIFIER_STYLER));
                return this.factory.createXtendFeatureNode(parentNode, (EObject)jvmFeature, image, label, true, synthetic, inheritanceDepth);
            }
            return null;
        }
        return this.factory.createXtendFeatureNode(parentNode, semanticFeature, image, text, true, synthetic, inheritanceDepth);
    }

    public List<OutlineMode> getOutlineModes() {
        return MODES;
    }

    public OutlineMode getCurrentMode() {
        return this.getOutlineModes().get(this.currentModeIndex);
    }

    public OutlineMode getNextMode() {
        return this.getOutlineModes().get((this.currentModeIndex + 1) % this.getOutlineModes().size());
    }

    public void setCurrentMode(OutlineMode outlineMode) {
        int newIndex = this.getOutlineModes().indexOf(outlineMode);
        if (newIndex != -1) {
            this.currentModeIndex = newIndex;
        }
    }

    protected boolean isLeaf(EObject modelElement) {
        if (modelElement instanceof XtendTypeDeclaration) {
            return ((XtendTypeDeclaration)modelElement).getMembers().isEmpty();
        }
        return super.isLeaf(modelElement);
    }
}

