/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.ui.wizard.releng;

import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.xtext.ui.wizard.DefaultProjectInfo;
import org.eclipse.xtext.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelengProjectInfo
extends DefaultProjectInfo {
    private String buildFeatureName;
    private String projectNameSpace;
    private String buckyLocation;
    private String siteFeatureProjectName;
    private List<IFile> testLaunchers = Lists.newArrayList();
    private List<String> preCompileLaunchers = Lists.newArrayList();

    public String getBuildFeatureName() {
        return this.buildFeatureName;
    }

    public void setBuildFeatureName(String featureProjectName) {
        this.buildFeatureName = featureProjectName;
        this.projectNameSpace = this.calculateProjectNamespace(featureProjectName);
    }

    public String getBuckyLocation() {
        return this.buckyLocation;
    }

    public void setBuckyLocation(String buckyLocation) {
        this.buckyLocation = buckyLocation;
    }

    public String calculateNameSpaceAbbreviation() {
        String[] packageNames = this.getProjectNameSpace().split("\\.");
        return Strings.toFirstUpper((String)packageNames[packageNames.length - 1]);
    }

    public List<IFile> getTestLaunchers() {
        return this.testLaunchers;
    }

    public void addTestLauncher(IFile iFile) {
        if (iFile == null) {
            throw new NullPointerException();
        }
        this.testLaunchers.add(iFile);
    }

    public List<String> getPreCompileLaunchers() {
        return this.preCompileLaunchers;
    }

    public void addPreCompileLauncher(String wsRelativePath) {
        if (wsRelativePath == null) {
            throw new NullPointerException();
        }
        this.preCompileLaunchers.add(wsRelativePath);
    }

    public String getProjectNameSpace() {
        return this.projectNameSpace;
    }

    public String getSiteFeatureProjectName() {
        return this.siteFeatureProjectName;
    }

    public void setSiteFeatureProjectName(String siteFeatureProjectName) {
        this.siteFeatureProjectName = siteFeatureProjectName;
    }

    private String calculateProjectNamespace(String featureProjectName) {
        return this.cutLastSegment(featureProjectName);
    }

    private String cutLastSegment(String fqn) {
        int lastIndexOfDot;
        String nameSpace = fqn;
        if (nameSpace != null && (lastIndexOfDot = nameSpace.lastIndexOf(46)) > 0) {
            nameSpace = nameSpace.substring(0, lastIndexOfDot);
        }
        return nameSpace;
    }
}

