/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.legacy;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.util.TypeConformanceComputationArgument;
import org.eclipse.xtext.common.types.util.TypeConformanceResult;
import org.eclipse.xtext.xbase.typesystem.conformance.ConformanceHint;
import org.eclipse.xtext.xbase.typesystem.conformance.TypeConformanceResult;
import org.eclipse.xtext.xbase.typesystem.legacy.StandardTypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.OwnedConverter;
import org.eclipse.xtext.xbase.typesystem.util.CommonTypeComputationServices;
import org.eclipse.xtext.xbase.typing.XbaseTypeConformanceComputer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LegacyTypeConformanceComputer
extends XbaseTypeConformanceComputer {
    @Inject
    private CommonTypeComputationServices services;

    public JvmTypeReference getCommonSuperType(List<JvmTypeReference> types) {
        Resource resource = null;
        for (JvmTypeReference type : types) {
            resource = this.getResource(type);
            if (resource != null) break;
        }
        if (resource == null) {
            return super.getCommonSuperType(types);
        }
        StandardTypeReferenceOwner owner = new StandardTypeReferenceOwner(this.services, resource);
        OwnedConverter converter = new OwnedConverter(owner);
        ArrayList lightweightTypes = Lists.newArrayListWithCapacity((int)types.size());
        for (JvmTypeReference type : types) {
            lightweightTypes.add(converter.toLightweightReference(type));
        }
        LightweightTypeReference result = this.services.getTypeConformanceComputer().getCommonSuperType(lightweightTypes, owner);
        if (result == null) {
            return null;
        }
        return result.toTypeReference();
    }

    @Override
    public org.eclipse.xtext.common.types.util.TypeConformanceResult isConformant(JvmTypeReference left, JvmTypeReference right, TypeConformanceComputationArgument flags) {
        Resource resource = this.getResource(left);
        if (resource == null) {
            resource = this.getResource(right);
        }
        if (resource == null) {
            return super.isConformant(left, right, flags);
        }
        StandardTypeReferenceOwner owner = new StandardTypeReferenceOwner(this.services, resource);
        OwnedConverter converter = new OwnedConverter(owner);
        LightweightTypeReference leftLightweight = converter.toLightweightReference(left);
        LightweightTypeReference rightLightweight = converter.toLightweightReference(right);
        TypeConformanceResult result = leftLightweight.internalIsAssignableFrom(rightLightweight, new org.eclipse.xtext.xbase.typesystem.conformance.TypeConformanceComputationArgument(flags.isRawType(), flags.isAsTypeArgument(), flags.isAllowPrimitiveConversion(), true, false, true));
        EnumSet<TypeConformanceResult.Kind> hints = EnumSet.noneOf(TypeConformanceResult.Kind.class);
        for (ConformanceHint hint : result.getConformanceHints()) {
            switch (hint) {
                case BOXING: {
                    hints.add(TypeConformanceResult.Kind.BOXING);
                    break;
                }
                case DEMAND_CONVERSION: {
                    hints.add(TypeConformanceResult.Kind.DEMAND_CONVERSION);
                    break;
                }
                case EXCEPTION: {
                    hints.add(TypeConformanceResult.Kind.EXCEPTION);
                    break;
                }
                case INCOMPATIBLE: {
                    hints.add(TypeConformanceResult.Kind.FAILED);
                    break;
                }
                case PRIMITIVE_WIDENING: {
                    hints.add(TypeConformanceResult.Kind.PRIMITIVE_WIDENING);
                    break;
                }
                case SUBTYPE: {
                    hints.add(TypeConformanceResult.Kind.SUBTYPE);
                    break;
                }
                case SUCCESS: {
                    hints.add(TypeConformanceResult.Kind.SUCCESS);
                    break;
                }
                case SYNONYM: {
                    hints.add(TypeConformanceResult.Kind.SYNONYM);
                    break;
                }
                case UNBOXING: {
                    hints.add(TypeConformanceResult.Kind.UNBOXING);
                    break;
                }
            }
        }
        return new org.eclipse.xtext.common.types.util.TypeConformanceResult(hints, null);
    }

    protected Resource getResource(JvmTypeReference reference) {
        if (reference.eResource() != null) {
            return reference.eResource();
        }
        JvmType type = reference.getType();
        if (type != null && type.eResource() != null) {
            return type.eResource();
        }
        return null;
    }
}

