package org.eclipse.xtext.xtext.ui.wizard.releng.templates;

import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.eclipse.xtext.xtext.ui.wizard.releng.RelengProjectInfo;

/**
 * Creates ant script that starts buckminster headlessbuild.<br>
 * 
 * @author Dennis Huebner - Initial contribution and API
 * @since 2.3
 */
@SuppressWarnings("all")
public class BuildScriptCreator {
  /**
   * Creates ant script that starts buckminster headlessbuild.<br>
   * @param projectInfo Project configuration to use
   */
  public CharSequence createScript(final RelengProjectInfo projectInfo) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
    _builder.newLine();
    _builder.append("<!--");
    _builder.newLine();
    _builder.append("     ");
    _builder.append("Buckminster Headless - build");
    _builder.newLine();
    _builder.newLine();
    _builder.append("     ");
    _builder.append("Properties:");
    _builder.newLine();
    _builder.append("     \t");
    _builder.append("WORKSPACE  \t\t\tEclipse workspace location, or hudson job workspace");
    _builder.newLine();
    _builder.append("     \t");
    _builder.append("build.root \t\t\tWhere to build? WARNING: This folder will be cleaned up, so do not point to user.home or something important");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t\t");
    _builder.append("Default: ${WORKSPACE}/buildroot");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("buckminster.home\tBuckminster headless to use. See http://www.eclipse.org/buckminster/downloads.html");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("projects.location\tWhere to find projects to build?");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t\t");
    _builder.append("Default: ${WORKSPACE}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("commands.file\t\tWhat to do?");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t\t");
    _builder.append("Default: ${projects.location}/");
    String _projectName = projectInfo.getProjectName();
    _builder.append(_projectName, "\t\t\t\t\t\t\t");
    _builder.append("/commands.txt");
    _builder.newLineIfNotEmpty();
    _builder.append("-->");
    _builder.newLine();
    _builder.append("<project name=\"Buckminster Headless\" default=\"buckminster\">");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("<property name=\"WORKSPACE\" location=\"${ant.file}/../../\" />");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("<property name=\"build.root\" location=\"${WORKSPACE}/buildroot\" />");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("<property name=\"buckminster.home\" location=\"");
    String _xifexpression = null;
    String _buckyLocation = projectInfo.getBuckyLocation();
    boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty(_buckyLocation);
    boolean _not = (!_isNullOrEmpty);
    if (_not) {
      String _buckyLocation_1 = projectInfo.getBuckyLocation();
      _xifexpression = _buckyLocation_1;
    } else {
      _xifexpression = "Add_buckminster_headless_location_here";
    }
    _builder.append(_xifexpression, "\t");
    _builder.append("\" />");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("<property name=\"projects.location\" location=\"${WORKSPACE}\" />");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("<property name=\"commands.file\" location=\"${projects.location}/");
    String _projectName_1 = projectInfo.getProjectName();
    _builder.append(_projectName_1, "\t");
    _builder.append("/commands.txt\" />");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("<property name=\"target.platform\" value=\"target.platform\" />");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("<target name=\"buckminster\" depends=\"cleanup\" description=\"description\">");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("<echo message=\"IMPORTANT: Populating an empty target platform may took over 10 minutes.\"/>");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("<condition property=\"executable.file\" value=\"buckminster.bat\" else=\"buckminster\">");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("<os family=\"windows\"/>");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("</condition>");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("<java fork=\"true\" dir=\"${buckminster.home}\" logError=\"true\" classname=\"org.eclipse.core.launcher.Main\" failonerror=\"true\">");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("<classpath>");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("<fileset dir=\"${buckminster.home}/plugins\">");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("<include name=\"org.eclipse.equinox.launcher_*.jar\" />");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("</fileset>");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("</classpath>");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("<arg line=\'-update\' />");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("<arg line=\'-data \"${build.root}/buckminster.workspace\"\' />");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("<arg line=\'-configuration \"${build.root}/configuration\"\' />");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("<arg line=\'--script \"${commands.file}\"\' />");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("<sysproperty key=\"projects.location\" value=\"${projects.location}\" />");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("<sysproperty key=\"buckminster.output.root\" value=\"${build.root}/buckminster.output\" />");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("<sysproperty key=\"buckminster.temp.root\" value=\"${build.root}/buckminster.temp\" />");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("<sysproperty key=\"target.platform\" value=\"${build.root}/${target.platform}\" />");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("<jvmarg line=\" -Xms256m -Xmx512m\" />");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("</java>");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("<echo message=\" \"/>");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("<echo message=\"Updatesite output in: ${build.root}/buckminster.output/");
    String _siteFeatureProjectName = projectInfo.getSiteFeatureProjectName();
    _builder.append(_siteFeatureProjectName, "\t\t");
    _builder.append("_*-eclipse.feature/site.p2/\"/>");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("</target>");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("<target name=\"cleanup\">");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("<delete failonerror=\"false\" includeemptydirs=\"true\">");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("<fileset dir=\"${build.root}\" defaultexcludes=\"false\">");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("<exclude name=\"**/.metadata/.plugins/org.eclipse.pde.core/.bundle_pool/\" />");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("<exclude name=\"**/${target.platform}/\" />");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("</fileset>");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("</delete>");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("</target>");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("<target name=\"reset.target-platform\">");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("<delete includeemptydirs=\"true\">");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("<fileset dir=\"${build.root}\" defaultexcludes=\"false\">");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("<include name=\"**/.metadata/.plugins/org.eclipse.pde.core/.bundle_pool/\" />");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("<include name=\"**/${target.platform}/\" />");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("</fileset>");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("</delete>");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("</target>");
    _builder.newLine();
    _builder.append("</project>");
    _builder.newLine();
    return _builder;
  }
}
