/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.internal;

import com.google.inject.Inject;
import com.google.inject.Provider;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.linking.impl.IllegalNodeException;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.util.internal.Stopwatches;
import org.eclipse.xtext.validation.IssueSeverities;
import org.eclipse.xtext.validation.IssueSeveritiesProvider;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XCasePart;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XSwitchExpression;
import org.eclipse.xtext.xbase.XbaseFactory;
import org.eclipse.xtext.xbase.scoping.batch.IBatchScopeProvider;
import org.eclipse.xtext.xbase.scoping.batch.IFeatureScopeSession;
import org.eclipse.xtext.xbase.typesystem.IResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.computation.IFeatureLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeComputationResult;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeComputationState;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeComputer;
import org.eclipse.xtext.xbase.typesystem.internal.AbstractRootedReentrantTypeResolver;
import org.eclipse.xtext.xbase.typesystem.internal.AbstractTypeComputationState;
import org.eclipse.xtext.xbase.typesystem.internal.ExpressionArgumentFactory;
import org.eclipse.xtext.xbase.typesystem.internal.ExpressionBasedRootTypeComputationState;
import org.eclipse.xtext.xbase.typesystem.internal.ForwardingTypeComputationState;
import org.eclipse.xtext.xbase.typesystem.internal.ResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.internal.RootResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.internal.ScopeProviderAccess;
import org.eclipse.xtext.xbase.typesystem.util.BoundTypeArgumentMerger;
import org.eclipse.xtext.xbase.typesystem.util.CommonTypeComputationServices;
import org.eclipse.xtext.xbase.validation.FeatureNameValidator;

@NonNullByDefault
public class DefaultReentrantTypeResolver
extends AbstractRootedReentrantTypeResolver
implements Cloneable {
    @Inject
    private CommonTypeComputationServices services;
    @Inject
    private ITypeComputer typeComputer;
    @Inject
    private ScopeProviderAccess scopeProviderAccess;
    @Inject
    private IBatchScopeProvider batchScopeProvider;
    @Inject
    private ExpressionArgumentFactory expressionArgumentFactory;
    @Inject
    private FeatureNameValidator featureNameValidator;
    @Inject
    private IssueSeveritiesProvider issueSeveritiesProvider;
    @Inject(optional=true)
    private XbaseFactory xbaseFactory = XbaseFactory.eINSTANCE;
    @Inject
    private AbortingScopeProviderAccess.Factory abortingScopeProviderAccessFactory;
    private EObject root;
    private boolean resolving = false;

    public final void initializeFrom(EObject root) {
        if (this.root != null) {
            throw new IllegalStateException("Cannot reinitialize. Resolver has already a root: " + this.root);
        }
        this.root = root;
    }

    protected final EObject getRoot() {
        return this.root;
    }

    protected boolean isHandled(EObject context) {
        return EcoreUtil.getRootContainer((EObject)context) == this.getRoot();
    }

    protected boolean isHandled(XExpression expression) {
        return EcoreUtil.getRootContainer((EObject)expression) == this.getRoot();
    }

    protected boolean isHandled(JvmIdentifiableElement identifiableElement) {
        return EcoreUtil.getRootContainer((EObject)identifiableElement) == this.getRoot();
    }

    protected IssueSeverities getIssueSeverities() {
        Resource resource = this.root == null ? null : this.root.eResource();
        return this.issueSeveritiesProvider.getIssueSeverities(resource);
    }

    public IResolvedTypes reentrantResolve() {
        if (this.resolving) {
            throw new UnsupportedOperationException("TODO: import a functional handle on the type resolution that delegates to the best available (current, but evolving) result");
        }
        Stopwatches.StoppedTask task = Stopwatches.forTask((String)"DefaultReentrantTypeResolver.resolve");
        try {
            task.start();
            this.resolving = true;
            IResolvedTypes iResolvedTypes = this.resolve();
            return iResolvedTypes;
        }
        finally {
            this.resolving = false;
            task.stop();
        }
    }

    protected IResolvedTypes resolve() {
        if (this.isInvalidRoot()) {
            return IResolvedTypes.NULL;
        }
        RootResolvedTypes result = this.createResolvedTypes();
        IFeatureScopeSession session = this.batchScopeProvider.newSession(this.root.eResource());
        this.computeTypes(result, session);
        result.resolveUnboundTypeParameters();
        result.resolveProxies();
        result.addDiagnostics(this.root.eResource());
        return result;
    }

    protected IScope getFeatureScope(XAbstractFeatureCall featureCall) {
        ResolvedTypes resolvedTypes = this.createResolvedTypesForScoping(featureCall);
        IFeatureScopeSession session = this.batchScopeProvider.newSession(this.root.eResource());
        try {
            this.computeTypes(resolvedTypes, session);
        }
        catch (AbortTypeComputation e) {
            IScope result = e.getScope();
            if (result == null) {
                throw new IllegalStateException();
            }
            return result;
        }
        return IScope.NULLSCOPE;
    }

    protected IResolvedTypes getResolvedTypesInContextOf(EObject context) {
        if (this.isInvalidRoot()) {
            return IResolvedTypes.NULL;
        }
        RootResolvedTypes result = this.createAbortableResolvedTypes(context);
        IFeatureScopeSession session = this.batchScopeProvider.newSession(this.root.eResource());
        try {
            this.computeTypes(result, session);
        }
        catch (AbortTypeComputation e) {
            return e.resolvedTypes;
        }
        return result;
    }

    private boolean isInvalidRoot() {
        return this.root == null || this.root.eResource() == null || this.root.eResource().getResourceSet() == null;
    }

    protected RootResolvedTypes createResolvedTypes() {
        return new RootResolvedTypes(this);
    }

    protected final ResolvedTypes createResolvedTypesForScoping(XAbstractFeatureCall featureCall) {
        DefaultReentrantTypeResolver clone = this.clone();
        clone.scopeProviderAccess = this.createAbortingScopeProviderAccess(featureCall);
        return new RootResolvedTypes(clone);
    }

    protected final RootResolvedTypes createAbortableResolvedTypes(EObject abortOn) {
        DefaultReentrantTypeResolver clone = this.clone();
        clone.typeComputer = this.createAbortingTypeComputer(abortOn);
        return new RootResolvedTypes(clone);
    }

    public DefaultReentrantTypeResolver clone() {
        try {
            return (DefaultReentrantTypeResolver)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException();
        }
    }

    protected ScopeProviderAccess createAbortingScopeProviderAccess(XAbstractFeatureCall abortOn) {
        return this.abortingScopeProviderAccessFactory.create(this.scopeProviderAccess, abortOn);
    }

    protected ITypeComputer createAbortingTypeComputer(final EObject abortOn) {
        if (abortOn instanceof XExpression) {
            return new ITypeComputer(){

                public void computeTypes(XExpression expression, ITypeComputationState state) {
                    if (DefaultReentrantTypeResolver.this.doAbort(abortOn, expression)) {
                        throw new AbortTypeComputation(((AbstractTypeComputationState)state).getResolvedTypes());
                    }
                    DefaultReentrantTypeResolver.this.typeComputer.computeTypes(expression, state);
                }
            };
        }
        if (abortOn instanceof XCasePart) {
            final XCasePart casePart = (XCasePart)abortOn;
            return new ITypeComputer(){

                public void computeTypes(XExpression expression, ITypeComputationState state) {
                    if (expression instanceof XSwitchExpression && casePart.eContainer() == expression) {
                        class State
                        extends ForwardingTypeComputationState {
                            private final /* synthetic */ EObject val$abortOn;

                            public State(ITypeComputationState delegate, EObject eObject) {
                                this.val$abortOn = eObject;
                                super(delegate);
                            }

                            protected ForwardingTypeComputationState newForwardingTypeComputationState(ITypeComputationState delegate) {
                                return new State(delegate, this.val$abortOn);
                            }

                            public ITypeComputationState withTypeCheckpoint(@Nullable EObject context) {
                                if (context != null && DefaultReentrantTypeResolver.this.doAbort(this.val$abortOn, context)) {
                                    return new State(this, this.getDelegate().withTypeCheckpoint(context), this.val$abortOn){

                                        public ITypeComputationResult computeTypes(@Nullable XExpression expression) {
                                            ITypeComputationState delegate = this.getDelegate();
                                            throw new AbortTypeComputation(((AbstractTypeComputationState)delegate).getResolvedTypes());
                                        }
                                    };
                                }
                                return super.withTypeCheckpoint(context);
                            }
                        }
                        DefaultReentrantTypeResolver.this.typeComputer.computeTypes(expression, new State(state, abortOn));
                    } else {
                        DefaultReentrantTypeResolver.this.typeComputer.computeTypes(expression, state);
                    }
                }
            };
        }
        return this.typeComputer;
    }

    protected boolean doAbort(EObject abortOn, EObject context) {
        return context == abortOn;
    }

    protected void computeTypes(ResolvedTypes resolvedTypes, IFeatureScopeSession session) {
        this.computeTypes(resolvedTypes, session, this.root);
    }

    protected void computeTypes(ResolvedTypes resolvedTypes, IFeatureScopeSession session, EObject element) {
        if (!(element instanceof XExpression)) {
            throw new IllegalArgumentException("element: " + element);
        }
        this._computeTypes(resolvedTypes, session, (XExpression)element);
    }

    protected void _computeTypes(ResolvedTypes resolvedTypes, IFeatureScopeSession session, XExpression expression) {
        ExpressionBasedRootTypeComputationState state = new ExpressionBasedRootTypeComputationState(resolvedTypes, session, expression);
        state.computeTypes();
    }

    protected boolean isShadowingAllowed(QualifiedName name) {
        return this.featureNameValidator.isShadowingAllowed(name);
    }

    protected boolean isDisallowedName(QualifiedName name) {
        return this.featureNameValidator.isDisallowedName(name);
    }

    protected boolean isDiscouragedName(QualifiedName name) {
        return this.featureNameValidator.isDiscouragedName(name);
    }

    protected ITypeComputer getTypeComputer() {
        return this.typeComputer;
    }

    protected void setTypeComputer(ITypeComputer typeComputer) {
        this.typeComputer = typeComputer;
    }

    protected ScopeProviderAccess getScopeProviderAccess() {
        return this.scopeProviderAccess;
    }

    protected IBatchScopeProvider getBatchScopeProvider() {
        return this.batchScopeProvider;
    }

    protected ExpressionArgumentFactory getExpressionArgumentFactory() {
        return this.expressionArgumentFactory;
    }

    protected CommonTypeComputationServices getServices() {
        return this.services;
    }

    protected BoundTypeArgumentMerger getTypeArgumentMerger() {
        return this.services.getBoundTypeArgumentMerger();
    }

    protected EObject getSourceElement(EObject element) {
        return element;
    }

    protected XbaseFactory getXbaseFactory() {
        return this.xbaseFactory;
    }

    protected static class AbortTypeComputation
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        private IScope scope;
        private IResolvedTypes resolvedTypes;

        public AbortTypeComputation(IScope scope, IResolvedTypes resolvedTypes) {
            this.scope = scope;
            this.resolvedTypes = resolvedTypes;
        }

        public AbortTypeComputation(IResolvedTypes resolvedTypes) {
            this.scope = null;
            this.resolvedTypes = resolvedTypes;
        }

        @Nullable
        public IScope getScope() {
            return this.scope;
        }

        public IResolvedTypes getResolvedTypes() {
            return this.resolvedTypes;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class AbortingScopeProviderAccess
    extends ScopeProviderAccess {
        private XAbstractFeatureCall abortOn;
        private ScopeProviderAccess delegate;

        protected AbortingScopeProviderAccess() {
        }

        protected void setAbortOn(XAbstractFeatureCall abortOn) {
            this.abortOn = abortOn;
        }

        protected void setDelegate(ScopeProviderAccess scopeProviderAccess) {
            this.delegate = scopeProviderAccess;
        }

        @Override
        @Nullable
        protected IFeatureLinkingCandidate getKnownFeature(XAbstractFeatureCall featureCall, AbstractTypeComputationState state, ResolvedTypes resolvedTypes) {
            if (this.abortOn == featureCall) {
                return null;
            }
            return this.delegate.getKnownFeature(featureCall, state, resolvedTypes);
        }

        @Override
        public Iterable<IEObjectDescription> getCandidateDescriptions(XExpression expression, EReference reference, @Nullable EObject toBeLinked, IFeatureScopeSession session, IResolvedTypes types) throws IllegalNodeException {
            if (expression == this.abortOn) {
                IScope scope = session.getScope(expression, reference, types);
                throw new AbortTypeComputation(scope, types);
            }
            return this.delegate.getCandidateDescriptions(expression, reference, toBeLinked, session, types);
        }

        protected static class Factory {
            @Inject
            private Provider<AbortingScopeProviderAccess> provider;

            protected Factory() {
            }

            public AbortingScopeProviderAccess create(ScopeProviderAccess delegate, XAbstractFeatureCall abortOn) {
                AbortingScopeProviderAccess abortingScopeProviderAccess = (AbortingScopeProviderAccess)this.provider.get();
                abortingScopeProviderAccess.setAbortOn(abortOn);
                abortingScopeProviderAccess.setDelegate(delegate);
                return abortingScopeProviderAccess;
            }
        }
    }
}

