/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.contentassist.antlr;

import com.google.common.base.Function;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.Token;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Alternatives;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.EnumLiteralDeclaration;
import org.eclipse.xtext.EnumRule;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Group;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.UnorderedGroup;
import org.eclipse.xtext.XtextFactory;
import org.eclipse.xtext.nodemodel.BidiTreeIterator;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.parser.antlr.ITokenDefProvider;
import org.eclipse.xtext.resource.DerivedStateAwareResource;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.contentassist.AbstractContentAssistContextFactory;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.IFollowElementAcceptor;
import org.eclipse.xtext.ui.editor.contentassist.PrefixMatcher;
import org.eclipse.xtext.ui.editor.contentassist.antlr.FollowElement;
import org.eclipse.xtext.ui.editor.contentassist.antlr.IContentAssistParser;
import org.eclipse.xtext.ui.editor.contentassist.antlr.internal.Lexer;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.util.XtextSwitch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParserBasedContentAssistContextFactory
extends AbstractContentAssistContextFactory {
    private static final Logger log = Logger.getLogger(ParserBasedContentAssistContextFactory.class);
    @Inject
    private Provider<StatefulFactory> statefulFactoryProvider;

    public Provider<StatefulFactory> getStatefulFactoryProvider() {
        return this.statefulFactoryProvider;
    }

    public void setStatefulFactoryProvider(Provider<StatefulFactory> statefulFactoryProvider) {
        this.statefulFactoryProvider = statefulFactoryProvider;
    }

    @Override
    public ContentAssistContext[] create(ITextViewer viewer, int offset, XtextResource resource) {
        try {
            return ((StatefulFactory)this.statefulFactoryProvider.get()).create(viewer, offset, resource);
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CallHierarchyHelper
    extends XtextSwitch<Boolean> {
        private final EObject nextGrammarElement;
        private Set<AbstractRule> visiting = new HashSet<AbstractRule>();
        private Map<AbstractRule, Boolean> visited = Maps.newHashMapWithExpectedSize((int)4);
        private EObject grammarElement;
        private EObject queuedGrammarElement;
        private Boolean result = Boolean.FALSE;
        private String expectedText;

        public CallHierarchyHelper(EObject nextGrammarElement, String previousText, EObject previousGrammarElement) {
            this.nextGrammarElement = nextGrammarElement;
            this.expectedText = previousText;
            this.grammarElement = previousGrammarElement;
            this.queuedGrammarElement = nextGrammarElement;
        }

        public Boolean caseAbstractRule(AbstractRule object) {
            if (!this.checkFurther((EObject)object)) {
                return this.result;
            }
            if (!this.visiting.add(object)) {
                return Boolean.FALSE;
            }
            if (this.visited.containsKey(object)) {
                this.visiting.remove(object);
                return this.visited.get(object);
            }
            EObject wasGrammarElement = this.grammarElement;
            Boolean result = (Boolean)this.doSwitch((EObject)object.getAlternatives());
            this.visiting.remove(object);
            if (this.isExpectedGrammarElement(wasGrammarElement)) {
                this.visited.put(object, result);
            }
            return result;
        }

        private boolean checkFurther(EObject object) {
            if (this.isExpectedGrammarElement(object)) {
                if (this.queuedGrammarElement != null) {
                    this.grammarElement = this.queuedGrammarElement;
                    this.queuedGrammarElement = null;
                    this.expectedText = null;
                    this.visited.clear();
                    this.visiting.clear();
                    return true;
                }
                this.result = Boolean.TRUE;
                return false;
            }
            return true;
        }

        protected boolean isExpectedGrammarElement(EObject object) {
            if (object == this.grammarElement) {
                return true;
            }
            return this.grammarElement == null && this.expectedText != null && object instanceof Keyword && this.expectedText.equals(((Keyword)object).getValue());
        }

        public Boolean caseTerminalRule(TerminalRule object) {
            this.checkFurther((EObject)object);
            return this.result;
        }

        public Boolean caseGroup(Group object) {
            if (!this.checkFurther((EObject)object)) {
                return this.result;
            }
            for (AbstractElement token : object.getElements()) {
                if (!((Boolean)this.doSwitch((EObject)token)).booleanValue()) continue;
                return true;
            }
            if (GrammarUtil.isMultipleCardinality((AbstractElement)object)) {
                if (!this.checkFurther((EObject)object)) {
                    return this.result;
                }
                for (AbstractElement token : object.getElements()) {
                    if (!((Boolean)this.doSwitch((EObject)token)).booleanValue()) continue;
                    return true;
                }
            }
            return false;
        }

        public Boolean caseUnorderedGroup(UnorderedGroup object) {
            if (!this.checkFurther((EObject)object)) {
                return this.result;
            }
            if (this.caseAlternatives((List<AbstractElement>)object.getElements()).booleanValue()) {
                return true;
            }
            if (!this.checkFurther((EObject)object)) {
                return this.result;
            }
            return this.caseAlternatives((List<AbstractElement>)object.getElements());
        }

        public Boolean caseAlternatives(Alternatives object) {
            if (!this.checkFurther((EObject)object)) {
                return this.result;
            }
            if (this.caseAlternatives((List<AbstractElement>)object.getElements()).booleanValue()) {
                return true;
            }
            if (GrammarUtil.isMultipleCardinality((AbstractElement)object)) {
                if (!this.checkFurther((EObject)object)) {
                    return this.result;
                }
                return this.caseAlternatives((List<AbstractElement>)object.getElements());
            }
            return Boolean.FALSE;
        }

        public Boolean caseAlternatives(List<AbstractElement> elements) {
            EObject wasGrammarElement = this.grammarElement;
            HashSet visiting = Sets.newHashSet(this.visiting);
            boolean foundSomething = false;
            for (AbstractElement group : elements) {
                this.grammarElement = wasGrammarElement;
                this.visiting = Sets.newHashSet((Iterable)visiting);
                if (((Boolean)this.doSwitch((EObject)group)).booleanValue()) {
                    return true;
                }
                if (wasGrammarElement == this.grammarElement) continue;
                foundSomething = true;
            }
            if (foundSomething) {
                this.grammarElement = this.nextGrammarElement;
                this.visiting.clear();
            }
            return Boolean.FALSE;
        }

        public Boolean caseAbstractElement(AbstractElement object) {
            if (!this.checkFurther((EObject)object)) {
                return this.result;
            }
            if (GrammarUtil.isMultipleCardinality((AbstractElement)object) && !this.checkFurther((EObject)object)) {
                return this.result;
            }
            return Boolean.FALSE;
        }

        public Boolean caseAssignment(Assignment object) {
            if (!this.checkFurther((EObject)object)) {
                return this.result;
            }
            if (((Boolean)this.doSwitch((EObject)object.getTerminal())).booleanValue()) {
                return true;
            }
            if (GrammarUtil.isMultipleCardinality((AbstractElement)object)) {
                if (!this.checkFurther((EObject)object)) {
                    return this.result;
                }
                if (((Boolean)this.doSwitch((EObject)object.getTerminal())).booleanValue()) {
                    return true;
                }
            }
            return Boolean.FALSE;
        }

        public Boolean caseCrossReference(CrossReference object) {
            if (!this.checkFurther((EObject)object)) {
                return this.result;
            }
            if (((Boolean)this.doSwitch((EObject)object.getTerminal())).booleanValue()) {
                return true;
            }
            if (GrammarUtil.isMultipleCardinality((AbstractElement)object)) {
                if (!this.checkFurther((EObject)object)) {
                    return this.result;
                }
                if (((Boolean)this.doSwitch((EObject)object.getTerminal())).booleanValue()) {
                    return true;
                }
            }
            return Boolean.FALSE;
        }

        public Boolean caseRuleCall(RuleCall object) {
            if (!this.checkFurther((EObject)object)) {
                return this.result;
            }
            if (((Boolean)this.doSwitch((EObject)object.getRule())).booleanValue()) {
                return true;
            }
            if (GrammarUtil.isMultipleCardinality((AbstractElement)object)) {
                if (!this.checkFurther((EObject)object)) {
                    return this.result;
                }
                if (((Boolean)this.doSwitch((EObject)object.getRule())).booleanValue()) {
                    return true;
                }
            }
            return Boolean.FALSE;
        }

        public Boolean caseEnumLiteralDeclaration(EnumLiteralDeclaration object) {
            if (!this.checkFurther((EObject)object)) {
                return this.result;
            }
            Boolean result = (Boolean)this.doSwitch((EObject)object.getLiteral());
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FollowElementCalculator
    extends XtextSwitch<Boolean> {
        protected IFollowElementAcceptor acceptor;
        private List<AbstractElement> handledAlternatives;
        private UnorderedGroup group;
        private Collection<RuleCall> visitedRuleCalls = Sets.newHashSet();

        public void doSwitch(UnorderedGroup group, List<AbstractElement> handledAlternatives) {
            this.group = group;
            this.handledAlternatives = handledAlternatives;
            try {
                this.doSwitch((EObject)group);
            }
            finally {
                this.handledAlternatives = null;
                this.group = null;
            }
        }

        public Boolean caseAlternatives(Alternatives object) {
            boolean more = false;
            for (AbstractElement element : object.getElements()) {
                boolean bl = more = (Boolean)this.doSwitch((EObject)element) != false || more;
            }
            if (!more && !this.isOptional((AbstractElement)object)) {
                return false;
            }
            return true;
        }

        public Boolean caseUnorderedGroup(UnorderedGroup object) {
            if (object == this.group) {
                boolean more = true;
                for (AbstractElement element : object.getElements()) {
                    if (this.handledAlternatives != null && this.handledAlternatives.contains(element)) continue;
                    this.group = null;
                    more = (Boolean)this.doSwitch((EObject)element) != false && more;
                    this.group = object;
                }
                if (more && GrammarUtil.isMultipleCardinality((AbstractElement)object)) {
                    this.handledAlternatives = null;
                    this.group = null;
                    return this.caseUnorderedGroup(object);
                }
                if (!more && !this.isOptional((AbstractElement)object)) {
                    return false;
                }
                return true;
            }
            boolean more = true;
            for (AbstractElement element : object.getElements()) {
                boolean bl = more = (Boolean)this.doSwitch((EObject)element) != false && more;
            }
            if (!more && !this.isOptional((AbstractElement)object)) {
                return false;
            }
            return true;
        }

        public Boolean caseGroup(Group object) {
            boolean more = true;
            for (AbstractElement element : object.getElements()) {
                boolean bl = more = more && (Boolean)this.doSwitch((EObject)element) != false;
            }
            if (!more && !this.isOptional((AbstractElement)object)) {
                return false;
            }
            return true;
        }

        public Boolean caseAction(Action object) {
            return true;
        }

        public Boolean caseAssignment(Assignment object) {
            this.acceptor.accept((AbstractElement)object);
            if (!((Boolean)this.doSwitch((EObject)object.getTerminal())).booleanValue() && !this.isOptional((AbstractElement)object)) {
                return false;
            }
            return true;
        }

        public Boolean caseCrossReference(CrossReference object) {
            return Boolean.FALSE;
        }

        public Boolean caseParserRule(ParserRule object) {
            if (GrammarUtil.isDatatypeRule((ParserRule)object)) {
                return Boolean.FALSE;
            }
            return (Boolean)this.doSwitch((EObject)object.getAlternatives());
        }

        public Boolean caseEnumRule(EnumRule object) {
            return (Boolean)this.doSwitch((EObject)object.getAlternatives());
        }

        public Boolean caseEnumLiteralDeclaration(EnumLiteralDeclaration object) {
            return (Boolean)this.doSwitch((EObject)object.getLiteral());
        }

        public Boolean caseRuleCall(RuleCall object) {
            if (!this.visitedRuleCalls.add(object)) {
                return this.isOptional((AbstractElement)object);
            }
            this.acceptor.accept((AbstractElement)object);
            Boolean result = (Boolean)this.doSwitch((EObject)object.getRule()) != false || this.isOptional((AbstractElement)object);
            this.visitedRuleCalls.remove(object);
            return result;
        }

        public Boolean caseTerminalRule(TerminalRule object) {
            return Boolean.FALSE;
        }

        public Boolean caseKeyword(Keyword object) {
            this.acceptor.accept((AbstractElement)object);
            return this.isOptional((AbstractElement)object);
        }

        public boolean isOptional(AbstractElement element) {
            return GrammarUtil.isOptionalCardinality((AbstractElement)element);
        }
    }

    public static class LeafNodeFinder {
        private final int offset;
        private final boolean leading;

        public LeafNodeFinder(int offset, boolean leading) {
            this.offset = offset;
            this.leading = leading;
        }

        public ILeafNode searchIn(INode node) {
            if (node instanceof ICompositeNode) {
                return this.caseCompositeNode((ICompositeNode)node);
            }
            return this.caseLeafNode((ILeafNode)node);
        }

        public ILeafNode caseCompositeNode(ICompositeNode object) {
            block4: {
                block3: {
                    if (!this.leading) break block3;
                    if (object.getTotalOffset() >= this.offset || object.getTotalLength() + object.getTotalOffset() < this.offset) break block4;
                    for (INode node : object.getChildren()) {
                        ILeafNode result = this.searchIn(node);
                        if (result == null) continue;
                        return result;
                    }
                    break block4;
                }
                if (object.getTotalOffset() <= this.offset && object.getTotalLength() + object.getTotalOffset() > this.offset) {
                    for (INode node : object.getChildren()) {
                        ILeafNode result = this.searchIn(node);
                        if (result == null) continue;
                        return result;
                    }
                }
            }
            return null;
        }

        public ILeafNode caseLeafNode(ILeafNode object) {
            if (this.leading ? object.getTotalOffset() < this.offset && object.getTotalLength() + object.getTotalOffset() >= this.offset : object.getTotalOffset() <= this.offset && object.getTotalLength() + object.getTotalOffset() > this.offset) {
                return object;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StatefulFactory
    implements Function<ContentAssistContext.Builder, ContentAssistContext> {
        @Inject
        private IContentAssistParser parser;
        @Inject
        @Named(value="org.eclipse.xtext.ui.editor.contentassist.antlr.internal.Lexer.CONTENT_ASSIST")
        private Lexer lexer;
        @Inject
        private Provider<ContentAssistContext.Builder> contentAssistContextProvider;
        @Inject
        private PrefixMatcher matcher;
        @Inject
        private ITokenDefProvider tokenDefProvider;
        private ITextViewer viewer;
        private XtextResource resource;
        private ICompositeNode rootNode;
        private INode lastCompleteNode;
        private INode currentNode;
        private INode lastVisibleNode;
        private EObject currentModel;
        private List<ContentAssistContext.Builder> contextBuilders;
        private IParseResult parseResult;
        private INode datatypeNode;
        private int completionOffset;
        private ITextSelection selection;

        public ContentAssistContext apply(ContentAssistContext.Builder from) {
            return from.toContext();
        }

        public ContentAssistContext[] create(ITextViewer viewer, int offset, XtextResource resource) throws BadLocationException {
            this.viewer = viewer;
            this.resource = resource;
            if (resource instanceof DerivedStateAwareResource) {
                resource.getContents();
            }
            this.parseResult = resource.getParseResult();
            if (this.parseResult == null) {
                throw new NullPointerException("parseResult is null");
            }
            return this.doCreateContexts(offset);
        }

        protected ContentAssistContext[] doCreateContexts(int offset) throws BadLocationException {
            this.initializeFromViewerAndResource(offset);
            if (!this.datatypeNode.equals(this.lastCompleteNode)) {
                this.handleLastCompleteNodeAsPartOfDatatypeNode();
            }
            if (this.datatypeNode.equals(this.lastCompleteNode) && this.completionOffset != this.lastCompleteNode.getOffset()) {
                this.handleLastCompleteNodeIsAtEndOfDatatypeNode();
            }
            if (!(this.lastCompleteNode instanceof ILeafNode) || this.lastCompleteNode.getGrammarElement() != null) {
                this.handleLastCompleteNodeIsPartOfLookahead();
            }
            return Lists.transform(this.contextBuilders, (Function)this).toArray(new ContentAssistContext[this.contextBuilders.size()]);
        }

        protected void initializeFromViewerAndResource(int offset) {
            this.initializeAndAdjustCompletionOffset(offset);
            this.initializeNodeAndModelData();
            this.contextBuilders = Lists.newArrayList();
        }

        protected void initializeNodeAndModelData() {
            this.rootNode = this.parseResult.getRootNode();
            this.lastCompleteNode = new LeafNodeFinder(this.completionOffset, true).searchIn((INode)this.rootNode);
            if (this.lastCompleteNode == null) {
                this.lastCompleteNode = this.rootNode;
            }
            this.currentNode = new LeafNodeFinder(this.completionOffset, false).searchIn((INode)this.rootNode);
            if (this.currentNode == null) {
                this.currentNode = this.lastCompleteNode;
            }
            this.lastVisibleNode = this.getLastCompleteNodeByOffset((INode)this.rootNode, this.completionOffset);
            this.datatypeNode = this.getContainingDatatypeRuleNode(this.lastCompleteNode);
            this.currentModel = NodeModelUtils.findActualSemanticObjectFor((INode)this.lastVisibleNode);
        }

        protected void initializeAndAdjustCompletionOffset(int offset) {
            this.selection = (ITextSelection)this.viewer.getSelectionProvider().getSelection();
            this.completionOffset = offset;
            if (this.selection.getOffset() + this.selection.getLength() == offset) {
                this.completionOffset = this.selection.getOffset();
            }
        }

        protected void handleLastCompleteNodeIsPartOfLookahead() throws BadLocationException {
            if (!(this.lastCompleteNode instanceof ILeafNode) || !((ILeafNode)this.lastCompleteNode).isHidden()) {
                this.createContextsForLastCompleteNode(this.currentModel, true);
            }
        }

        protected void handleLastCompleteNodeIsAtEndOfDatatypeNode() throws BadLocationException {
            String prefix = this.getPrefix(this.lastCompleteNode);
            String completeInput = this.viewer.getDocument().get(0, this.lastCompleteNode.getOffset());
            INode previousNode = this.getLastCompleteNodeByOffset((INode)this.rootNode, this.lastCompleteNode.getOffset());
            EObject previousModel = previousNode.getSemanticElement();
            INode currentDatatypeNode = this.getContainingDatatypeRuleNode(this.currentNode);
            Collection<FollowElement> followElements = this.parser.getFollowElements(completeInput, false);
            int prevSize = this.contextBuilders.size();
            this.doCreateContexts(previousNode, currentDatatypeNode, prefix, previousModel, followElements);
            if (this.lastCompleteNode instanceof ILeafNode && this.lastCompleteNode.getGrammarElement() == null && this.contextBuilders.size() != prevSize) {
                this.handleLastCompleteNodeHasNoGrammarElement(this.contextBuilders.subList(prevSize, this.contextBuilders.size()), previousModel);
            }
        }

        protected void handleLastCompleteNodeHasNoGrammarElement(List<ContentAssistContext.Builder> contextBuilderToCheck, EObject previousModel) throws BadLocationException {
            List newContexts = Lists.transform(contextBuilderToCheck, (Function)this);
            boolean wasValid = this.isLikelyToBeValidProposal(this.lastCompleteNode, newContexts);
            if (!(!wasValid || this.lastCompleteNode instanceof ILeafNode && ((ILeafNode)this.lastCompleteNode).isHidden())) {
                this.createContextsForLastCompleteNode(previousModel, false);
            }
        }

        protected void handleLastCompleteNodeAsPartOfDatatypeNode() throws BadLocationException {
            String prefix = this.getPrefix(this.datatypeNode);
            String completeInput = this.viewer.getDocument().get(0, this.datatypeNode.getOffset());
            Collection<FollowElement> followElements = this.parser.getFollowElements(completeInput, false);
            INode lastCompleteNodeBeforeDatatype = this.getLastCompleteNodeByOffset((INode)this.rootNode, this.datatypeNode.getTotalOffset());
            this.doCreateContexts(lastCompleteNodeBeforeDatatype, this.datatypeNode, prefix, this.currentModel, followElements);
        }

        protected boolean isLikelyToBeValidProposal(INode lastCompleteNode, Iterable<ContentAssistContext> contexts) {
            for (ContentAssistContext context : contexts) {
                for (AbstractElement element : context.getFirstSetGrammarElements()) {
                    String lastText;
                    String keywordValue;
                    if (!(element instanceof Keyword) || !(keywordValue = ((Keyword)element).getValue()).equals(lastText = ((ILeafNode)lastCompleteNode).getText())) continue;
                    return true;
                }
            }
            return false;
        }

        /*
         * Unable to fully structure code
         */
        protected void createContextsForLastCompleteNode(EObject previousModel, boolean strict) throws BadLocationException {
            block2: {
                currentNodePrefix = this.getPrefix(this.currentNode);
                if (Strings.isEmpty((String)currentNodePrefix) || this.currentNode.getText().equals(currentNodePrefix)) break block2;
                this.lexer.setCharStream((CharStream)new ANTLRStringStream(currentNodePrefix));
                token = this.lexer.nextToken();
                if (token != Token.EOF_TOKEN) ** GOTO lbl10
                return;
lbl-1000:
                // 1 sources

                {
                    if (this.isErrorToken(token)) {
                        return;
                    }
                    token = this.lexer.nextToken();
lbl10:
                    // 2 sources

                    ** while (token != Token.EOF_TOKEN)
                }
            }
            prefix = "";
            completeInput = this.viewer.getDocument().get(0, this.completionOffset);
            followElements = this.parser.getFollowElements(completeInput, strict);
            this.doCreateContexts(this.lastCompleteNode, this.currentNode, prefix, previousModel, followElements);
        }

        protected boolean isErrorToken(Token token) {
            String tokenTypeName = (String)this.tokenDefProvider.getTokenDefMap().get(token.getType());
            return "RULE_ANY_OTHER".equals(tokenTypeName);
        }

        protected void doCreateContexts(INode lastCompleteNode, INode currentNode, String prefix, EObject previousModel, Collection<FollowElement> followElements) {
            LinkedHashSet followElementAsAbstractElements = Sets.newLinkedHashSet();
            this.computeFollowElements(followElements, followElementAsAbstractElements);
            Multimap<EObject, AbstractElement> contextMap = this.computeCurrentModel(previousModel, lastCompleteNode, followElementAsAbstractElements);
            currentNode = this.getContainingDatatypeRuleNode(currentNode);
            for (Map.Entry entry : contextMap.asMap().entrySet()) {
                ContentAssistContext.Builder contextBuilder = this.doCreateContext(lastCompleteNode, (EObject)entry.getKey(), previousModel, currentNode, prefix);
                for (AbstractElement element : (Collection)entry.getValue()) {
                    contextBuilder.accept(element);
                }
                this.contextBuilders.add(contextBuilder);
            }
        }

        protected Multimap<EObject, AbstractElement> computeCurrentModel(EObject currentModel, INode lastCompleteNode, Collection<AbstractElement> followElements) {
            LinkedHashMultimap result = LinkedHashMultimap.create();
            ICompositeNode currentParserNode = NodeModelUtils.getNode((EObject)currentModel);
            if (currentParserNode == null) {
                result.putAll((Object)currentModel, followElements);
                return result;
            }
            EObject currentGrammarElement = currentParserNode.getGrammarElement();
            AbstractRule currentRule = this.getRule(currentGrammarElement);
            for (AbstractElement grammarElement : followElements) {
                AbstractRule rule = currentRule;
                ICompositeNode loopParserNode = currentParserNode;
                EObject loopLastGrammarElement = lastCompleteNode.getGrammarElement();
                while (!this.canBeCalledAfter(rule, loopLastGrammarElement, lastCompleteNode.getText(), (EObject)grammarElement) && loopParserNode.getParent() != null) {
                    loopLastGrammarElement = loopParserNode.getGrammarElement();
                    loopParserNode = loopParserNode.getParent();
                    while (loopParserNode.getGrammarElement() == null && loopParserNode.getParent() != null) {
                        loopParserNode = loopParserNode.getParent();
                    }
                    EObject loopGrammarElement = loopParserNode.getGrammarElement();
                    rule = this.getRule(loopGrammarElement);
                }
                EObject context = loopParserNode.getSemanticElement();
                result.put((Object)context, (Object)grammarElement);
            }
            return result;
        }

        protected void computeFollowElements(Collection<FollowElement> followElements, final Collection<AbstractElement> result) {
            FollowElementCalculator calculator = new FollowElementCalculator();
            calculator.acceptor = new IFollowElementAcceptor(){

                public void accept(AbstractElement element) {
                    ParserRule rule = GrammarUtil.containingParserRule((EObject)element);
                    if (rule == null || !GrammarUtil.isDatatypeRule((ParserRule)rule)) {
                        result.add(element);
                    }
                }
            };
            for (FollowElement element : followElements) {
                this.computeFollowElements(calculator, element);
            }
        }

        protected void computeFollowElements(FollowElementCalculator calculator, FollowElement element) {
            HashMultimap visited = HashMultimap.create();
            this.computeFollowElements(calculator, element, (Multimap<Integer, List<AbstractElement>>)visited);
        }

        protected void computeFollowElements(FollowElementCalculator calculator, FollowElement element, Multimap<Integer, List<AbstractElement>> visited) {
            ArrayList currentState = Lists.newArrayList(element.getLocalTrace());
            currentState.add(element.getGrammarElement());
            if (!visited.put((Object)element.getLookAhead(), (Object)currentState)) {
                return;
            }
            if (element.getLookAhead() <= 1) {
                ParserRule parserRule;
                for (AbstractElement abstractElement : currentState) {
                    AbstractElement next;
                    int idx;
                    Group group;
                    EObject container;
                    Assignment ass = (Assignment)EcoreUtil2.getContainerOfType((EObject)abstractElement, Assignment.class);
                    if (ass != null) {
                        calculator.doSwitch((EObject)ass);
                        continue;
                    }
                    if (abstractElement instanceof UnorderedGroup && abstractElement == element.getGrammarElement()) {
                        calculator.doSwitch((UnorderedGroup)abstractElement, element.getHandledUnorderedGroupElements());
                        continue;
                    }
                    calculator.doSwitch((EObject)abstractElement);
                    if (GrammarUtil.isOptionalCardinality((AbstractElement)abstractElement)) {
                        AbstractElement nextElement;
                        container = abstractElement.eContainer();
                        if (!(container instanceof Group)) continue;
                        group = (Group)container;
                        idx = group.getElements().indexOf((Object)abstractElement);
                        if (idx == group.getElements().size() - 1) {
                            if (currentState.contains(group) || !GrammarUtil.isMultipleCardinality((AbstractElement)group)) continue;
                            calculator.doSwitch((EObject)group);
                            continue;
                        }
                        if (idx >= group.getElements().size() - 1 || !"?".equals(abstractElement.getCardinality()) || currentState.contains(nextElement = (AbstractElement)group.getElements().get(idx + 1))) continue;
                        calculator.doSwitch((EObject)nextElement);
                        continue;
                    }
                    if (!this.isAlternativeWithEmptyPath(abstractElement) || !((container = abstractElement.eContainer()) instanceof Group)) continue;
                    group = (Group)container;
                    idx = group.getElements().indexOf((Object)abstractElement);
                    if (currentState.contains(group) || idx == group.getElements().size() - 1 || currentState.contains(next = (AbstractElement)group.getElements().get(idx + 1))) continue;
                    calculator.doSwitch((EObject)next);
                }
                if (element.getTrace().equals(element.getLocalTrace()) && (parserRule = GrammarUtil.containingParserRule((EObject)element.getGrammarElement())) != null) {
                    RuleCall ruleCall = XtextFactory.eINSTANCE.createRuleCall();
                    ruleCall.setRule((AbstractRule)parserRule);
                    calculator.doSwitch((EObject)ruleCall);
                }
                return;
            }
            Collection<FollowElement> followElements = this.parser.getFollowElements(element);
            for (FollowElement newElement : followElements) {
                if (newElement.getLookAhead() == element.getLookAhead() && newElement.getGrammarElement() == element.getGrammarElement()) continue;
                this.computeFollowElements(calculator, newElement, visited);
            }
        }

        private boolean isAlternativeWithEmptyPath(AbstractElement abstractElement) {
            if (abstractElement instanceof Alternatives) {
                Alternatives alternatives = (Alternatives)abstractElement;
                for (AbstractElement path : alternatives.getElements()) {
                    if (!GrammarUtil.isOptionalCardinality((AbstractElement)path)) continue;
                    return true;
                }
            }
            return false;
        }

        public INode getContainingDatatypeRuleNode(INode node) {
            INode result = node;
            EObject grammarElement = result.getGrammarElement();
            if (grammarElement != null) {
                ParserRule parserRule = GrammarUtil.containingParserRule((EObject)grammarElement);
                while (parserRule != null && GrammarUtil.isDatatypeRule((ParserRule)parserRule)) {
                    result = result.getParent();
                    grammarElement = result.getGrammarElement();
                    parserRule = GrammarUtil.containingParserRule((EObject)grammarElement);
                }
            }
            return result;
        }

        protected int getCompletionOffset() {
            return this.completionOffset;
        }

        public ContentAssistContext.Builder doCreateContext(INode lastCompleteNode, EObject currentModel, EObject previousModel, INode currentNode, String prefix) {
            ContentAssistContext.Builder context = (ContentAssistContext.Builder)this.contentAssistContextProvider.get();
            context.setRootNode(this.rootNode);
            context.setLastCompleteNode(lastCompleteNode);
            context.setCurrentNode(currentNode);
            context.setRootModel(this.parseResult.getRootASTElement());
            context.setCurrentModel(currentModel);
            context.setPreviousModel(previousModel);
            context.setOffset(this.completionOffset);
            context.setViewer(this.viewer);
            context.setPrefix(prefix);
            int regionLength = prefix.length();
            if (this.selection.getLength() > 0) {
                regionLength += this.selection.getLength();
            }
            Region region = new Region(this.completionOffset - prefix.length(), regionLength);
            context.setReplaceRegion(region);
            context.setSelectedText(this.selection.getText());
            context.setMatcher(this.matcher);
            context.setResource(this.resource);
            return context;
        }

        public String getPrefix(INode prefixNode) {
            if (prefixNode instanceof ILeafNode) {
                if (((ILeafNode)prefixNode).isHidden() && prefixNode.getGrammarElement() != null) {
                    return "";
                }
                return this.getNodeTextUpToCompletionOffset(prefixNode);
            }
            StringBuilder result = new StringBuilder(prefixNode.getTotalLength());
            this.doComputePrefix((ICompositeNode)prefixNode, result);
            return result.toString();
        }

        public String getNodeTextUpToCompletionOffset(INode currentNode) {
            String nodeText;
            String trimmedNodeText;
            int startOffset = currentNode.getOffset();
            int length = this.completionOffset - startOffset;
            String string = trimmedNodeText = length > (nodeText = ((ILeafNode)currentNode).getText()).length() ? nodeText : nodeText.substring(0, length);
            if (this.viewer.getDocument() != null && length >= 0) {
                try {
                    String text = this.viewer.getDocument().get(startOffset, trimmedNodeText.length());
                    if (trimmedNodeText.equals(text)) {
                        return text;
                    }
                    return this.viewer.getDocument().get(startOffset, length);
                }
                catch (BadLocationException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            return trimmedNodeText;
        }

        public boolean doComputePrefix(ICompositeNode node, StringBuilder result) {
            ArrayList hiddens = Lists.newArrayListWithCapacity((int)2);
            for (INode child : node.getChildren()) {
                if (child instanceof ICompositeNode) {
                    if (this.doComputePrefix((ICompositeNode)child, result)) continue;
                    return false;
                }
                ILeafNode leaf = (ILeafNode)child;
                ITextRegion leafRegion = leaf.getTextRegion();
                if (leafRegion.getOffset() > this.completionOffset) {
                    return false;
                }
                if (leaf.isHidden()) {
                    if (result.length() == 0) continue;
                    hiddens.add((ILeafNode)child);
                    continue;
                }
                Iterator iter = hiddens.iterator();
                while (iter.hasNext()) {
                    result.append(((ILeafNode)iter.next()).getText());
                }
                hiddens.clear();
                result.append(this.getNodeTextUpToCompletionOffset((INode)leaf));
                if (leafRegion.getOffset() + leafRegion.getLength() <= this.completionOffset) continue;
                return false;
            }
            return true;
        }

        public void setParser(IContentAssistParser parser) {
            this.parser = parser;
        }

        public IContentAssistParser getParser() {
            return this.parser;
        }

        protected boolean canBeCalledAfter(AbstractRule rule, EObject previousGrammarElement, String previousText, EObject nextGrammarElement) {
            Boolean result = (Boolean)this.createCallHierachyHelper(previousGrammarElement, previousText, nextGrammarElement).doSwitch((EObject)rule);
            return result;
        }

        protected CallHierarchyHelper createCallHierachyHelper(EObject previousGrammarElement, String previousText, EObject nextGrammarElement) {
            return new CallHierarchyHelper(nextGrammarElement, previousText, previousGrammarElement);
        }

        protected AbstractRule getRule(EObject currentGrammarElement) {
            AbstractRule rule = null;
            if (currentGrammarElement instanceof RuleCall) {
                rule = ((RuleCall)currentGrammarElement).getRule();
            }
            if (currentGrammarElement instanceof AbstractRule) {
                rule = (AbstractRule)currentGrammarElement;
            }
            if (currentGrammarElement instanceof Action) {
                rule = (AbstractRule)EcoreUtil2.getContainerOfType((EObject)currentGrammarElement, AbstractRule.class);
            }
            if (rule == null) {
                throw new IllegalStateException();
            }
            return rule;
        }

        protected INode getLastCompleteNodeByOffset(INode node, int offsetPosition) {
            BidiTreeIterator iterator = node.getRootNode().getAsTreeIterable().iterator();
            INode result = node;
            while (iterator.hasNext()) {
                INode candidate = (INode)iterator.next();
                if (candidate.getOffset() >= offsetPosition) break;
                if (!(candidate instanceof ILeafNode) || candidate.getGrammarElement() != null && !(candidate.getGrammarElement() instanceof AbstractElement) && !(candidate.getGrammarElement() instanceof ParserRule)) continue;
                result = candidate;
            }
            return result;
        }
    }
}

