/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.model;

import com.google.common.collect.AbstractIterator;
import com.google.inject.Inject;
import java.util.Iterator;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.xtext.ui.editor.model.ILexerTokenRegion;
import org.eclipse.xtext.ui.editor.model.ITokenTypeToPartitionTypeMapper;
import org.eclipse.xtext.ui.editor.model.XtextDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartitionTokenScanner
implements IPartitionTokenScanner {
    private Iterator<ILexerTokenRegion> tokens;
    private int currentPartitionOffset = 0;
    private ILexerTokenRegion nextToken = null;
    @Inject
    private ITokenTypeToPartitionTypeMapper mapper;
    private int currentPartitionLength;

    public void setMapper(ITokenTypeToPartitionTypeMapper mapper) {
        this.mapper = mapper;
    }

    public void setRange(IDocument document, int offset, int length) {
        this.setPartialRange(document, offset, length, null, 0);
    }

    public void setPartialRange(IDocument document, int offset, int length, String contentType, int partitionOffset) {
        int overlapOffset = partitionOffset;
        int overlapLength = offset + length - partitionOffset;
        this.tokens = new RangedIterator(this.getTokens(document), (IRegion)new Region(overlapOffset, overlapLength));
        this.currentPartitionOffset = overlapOffset;
        this.currentPartitionLength = 0;
        this.nextToken = this.tokens.hasNext() ? this.tokens.next() : null;
    }

    protected Iterable<ILexerTokenRegion> getTokens(IDocument document) {
        return ((XtextDocument)document).getTokens();
    }

    public IToken nextToken() {
        if (this.nextToken == null) {
            return Token.EOF;
        }
        this.currentPartitionOffset = this.nextToken.getOffset();
        this.currentPartitionLength = this.nextToken.getLength();
        String tokenPartition = this.mapper.getPartitionType(this.nextToken.getLexerTokenType());
        while (this.tokens.hasNext()) {
            this.nextToken = this.tokens.next();
            String partitionOfNext = this.mapper.getPartitionType(this.nextToken.getLexerTokenType());
            this.currentPartitionLength = this.nextToken.getOffset() - this.currentPartitionOffset;
            if (partitionOfNext.equals(tokenPartition) && this.shouldMergePartitions(tokenPartition)) continue;
            return new Token((Object)tokenPartition);
        }
        if (this.nextToken != null) {
            this.currentPartitionLength = this.nextToken.getOffset() + this.nextToken.getLength() - this.currentPartitionOffset;
        }
        this.nextToken = null;
        return new Token((Object)tokenPartition);
    }

    protected boolean shouldMergePartitions(String contentType) {
        return "__dftl_partition_content_type".equals(contentType);
    }

    public int getTokenOffset() {
        return this.currentPartitionOffset;
    }

    public int getTokenLength() {
        return this.currentPartitionLength;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class RangedIterator
    extends AbstractIterator<ILexerTokenRegion> {
        private final Iterator<ILexerTokenRegion> delegate;
        private final IRegion overlapRegion;

        protected RangedIterator(Iterable<ILexerTokenRegion> base, IRegion overlapRegion) {
            this.overlapRegion = overlapRegion;
            this.delegate = base.iterator();
        }

        protected ILexerTokenRegion computeNext() {
            while (this.delegate.hasNext()) {
                ILexerTokenRegion candidate = this.delegate.next();
                if (this.overlapRegion.getOffset() + this.overlapRegion.getLength() < candidate.getOffset()) {
                    return (ILexerTokenRegion)this.endOfData();
                }
                if (!TextUtilities.overlaps((IRegion)this.overlapRegion, (IRegion)candidate)) continue;
                return candidate;
            }
            return (ILexerTokenRegion)this.endOfData();
        }
    }
}

