/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.computation;

import com.google.inject.Inject;
import java.util.EnumSet;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.xbase.typesystem.conformance.ConformanceHint;
import org.eclipse.xtext.xbase.typesystem.references.ArrayTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynonymTypesProvider {
    @Inject
    private TypeReferences typeReferences;

    public void collectSynonymTypes(@Nullable LightweightTypeReference type, @NonNull Acceptor acceptor) {
        if (type == null || type.isPrimitiveVoid() || type.isType(Void.class)) {
            return;
        }
        if (type.isWrapper()) {
            if (!acceptor.accept(type.getPrimitiveIfWrapperType(), ConformanceHint.UNBOXING)) {
                return;
            }
            this.collectCustomSynonymTypes(type, acceptor);
            return;
        }
        if (type.isPrimitive()) {
            if (!acceptor.accept(type.getWrapperTypeIfPrimitive(), ConformanceHint.BOXING)) {
                return;
            }
            this.collectCustomSynonymTypes(type, acceptor);
            return;
        }
        if (this.addArrayAndListSynonyms(type, acceptor)) {
            this.collectCustomSynonymTypes(type, acceptor);
        }
    }

    protected boolean collectCustomSynonymTypes(LightweightTypeReference type, Acceptor acceptor) {
        return true;
    }

    @NonNullByDefault
    protected boolean addArrayAndListSynonyms(LightweightTypeReference type, Acceptor acceptor) {
        if (type.isArray()) {
            LightweightTypeReference listType = type.tryConvertToListType();
            if (listType != null) {
                LightweightTypeReference componentType = type.getComponentType();
                if (componentType == null) {
                    throw new IllegalStateException("Component type of an array may not be null");
                }
                if (componentType.isPrimitive() ? !acceptor.accept(listType, EnumSet.of(ConformanceHint.DEMAND_CONVERSION, ConformanceHint.BOXING)) : !acceptor.accept(listType, ConformanceHint.DEMAND_CONVERSION)) {
                    return false;
                }
            }
        } else {
            ArrayTypeReference arrayType = type.tryConvertToArray();
            if (arrayType != null) {
                ArrayTypeReference primitiveArray;
                LightweightTypeReference componentType = arrayType.getComponentType();
                LightweightTypeReference primitiveComponentType = componentType.getPrimitiveIfWrapperType();
                if (primitiveComponentType != componentType && !acceptor.accept((LightweightTypeReference)(primitiveArray = new ArrayTypeReference(type.getOwner(), primitiveComponentType)), EnumSet.of(ConformanceHint.DEMAND_CONVERSION, ConformanceHint.UNBOXING))) {
                    return false;
                }
                if (!acceptor.accept((LightweightTypeReference)arrayType, ConformanceHint.DEMAND_CONVERSION)) {
                    return false;
                }
            }
        }
        return true;
    }

    protected final boolean announceSynonym(LightweightTypeReference synonym, ConformanceHint hint, Acceptor acceptor) {
        return acceptor.accept(synonym, hint);
    }

    protected final boolean announceSynonym(LightweightTypeReference synonym, EnumSet<ConformanceHint> hints, Acceptor acceptor) {
        return acceptor.accept(synonym, hints);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @NonNullByDefault
    public static abstract class Acceptor {
        protected boolean accept(LightweightTypeReference synonym, ConformanceHint hint) {
            return this.accept(synonym, EnumSet.of(hint, ConformanceHint.SUCCESS, ConformanceHint.CHECKED));
        }

        protected abstract boolean accept(LightweightTypeReference var1, EnumSet<ConformanceHint> var2);
    }
}

