/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.formatting;

import com.google.common.base.Objects;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.xbase.formatting.FormattableDocument;
import org.eclipse.xtext.xbase.formatting.FormattingPreferenceValues;
import org.eclipse.xtext.xbase.formatting.IBasicFormatter;
import org.eclipse.xtext.xbase.formatting.TextReplacement;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFormatter
implements IBasicFormatter {
    private boolean _allowIdentityEdits = false;
    private boolean _diagnoseConflicts = true;
    private boolean conflictOccurred = false;

    public boolean isAllowIdentityEdits() {
        return this._allowIdentityEdits;
    }

    public void setAllowIdentityEdits(boolean allowIdentityEdits) {
        this._allowIdentityEdits = allowIdentityEdits;
    }

    public boolean isDiagnoseConflicts() {
        return this._diagnoseConflicts;
    }

    public void setDiagnoseConflicts(boolean diagnoseConflicts) {
        this._diagnoseConflicts = diagnoseConflicts;
    }

    @Override
    public List<TextReplacement> format(XtextResource res, int offset, int length, FormattingPreferenceValues cfg) {
        boolean _isConflictOccurred_1;
        FormattableDocument _formattableDocument;
        List _xblockexpression = null;
        IParseResult _parseResult = res.getParseResult();
        ICompositeNode _rootNode = _parseResult.getRootNode();
        final String doc = _rootNode.getText();
        FormattableDocument format = _formattableDocument = new FormattableDocument(cfg, doc);
        EList _contents = res.getContents();
        EObject _head = (EObject)IterableExtensions.head((Iterable)_contents);
        this.format(_head, format);
        boolean _and = false;
        boolean _isDiagnoseConflicts = this.isDiagnoseConflicts();
        if (!_isDiagnoseConflicts) {
            _and = false;
        } else {
            boolean _isConflictOccurred = format.isConflictOccurred();
            boolean bl = _and = _isDiagnoseConflicts && _isConflictOccurred;
        }
        if (_and) {
            FormattableDocument _formattableDocument_1;
            FormattableDocument debug = _formattableDocument_1 = new FormattableDocument(cfg, doc);
            RuntimeException _runtimeException = new RuntimeException();
            debug.setRootTrace(_runtimeException);
            EList _contents_1 = res.getContents();
            EObject _head_1 = (EObject)IterableExtensions.head((Iterable)_contents_1);
            this.format(_head_1, debug);
        }
        this.conflictOccurred = _isConflictOccurred_1 = format.isConflictOccurred();
        List edits = format.renderToEdits(offset, length);
        List _xifexpression = null;
        boolean _isAllowIdentityEdits = this.isAllowIdentityEdits();
        if (_isAllowIdentityEdits) {
            _xifexpression = edits;
        } else {
            List _list;
            Functions.Function1<TextReplacement, Boolean> _function = new Functions.Function1<TextReplacement, Boolean>(){

                public Boolean apply(TextReplacement it) {
                    String _text;
                    int _length;
                    int _offset_1;
                    int _plus;
                    int _offset = it.getOffset();
                    String _substring = doc.substring(_offset, _plus = (_offset_1 = it.getOffset()) + (_length = it.getLength()));
                    boolean _notEquals = !Objects.equal((Object)_substring, (Object)(_text = it.getText()));
                    return _notEquals;
                }
            };
            Iterable _filter = IterableExtensions.filter(edits, (Functions.Function1)_function);
            _xifexpression = _list = IterableExtensions.toList((Iterable)_filter);
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public boolean isConflictOccurred() {
        return this.conflictOccurred;
    }

    protected void _format(Void expr, FormattableDocument format) {
    }

    protected void _format(EObject expr, FormattableDocument format) {
    }

    protected void format(EObject expr, FormattableDocument format) {
        if (expr != null) {
            this._format(expr, format);
            return;
        }
        if (expr == null) {
            this._format((Void)null, format);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(expr, format).toString());
    }
}

