/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.hover;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementLinks;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.util.ITypeArgumentContext;
import org.eclipse.xtext.common.types.util.TypeArgumentContextProvider;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Tuples;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.typing.ITypeProvider;
import org.eclipse.xtext.xbase.ui.hover.FeatureCallRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HoverGenericsResolver {
    @Inject
    private TypeArgumentContextProvider typeArgumentContextProvider;
    @Inject
    private FeatureCallRequest.IFeatureCallRequestProvider featureCallRequestProvider;
    @Inject
    private ITypeProvider typeProvider;
    private static final long LABEL_FLAGS = JavaElementLabels.ALL_FULLY_QUALIFIED | 0x40L | 1L | 2L | 0x10L | 0x8000L | 4L | 0x200000L | 0x1000000000000L;
    private static final long LOCAL_VARIABLE_FLAGS = LABEL_FLAGS & 0xFFFFFFFFFFFEFFFFL | 0x20000L;
    private static final long TYPE_PARAMETER_FLAGS = LABEL_FLAGS | 0x400000L;

    public String resolveSignatureInHtml(XExpression call, IJavaElement javaElement, String html) {
        String signature = this.getJavaSignature(javaElement);
        String resolvedSignature = this.replaceGenerics(call, signature);
        return html.replace(signature, resolvedSignature);
    }

    public String replaceGenerics(XExpression call, String input) {
        String output = input;
        if (call != null) {
            XAbstractFeatureCall featureCall;
            JvmConstructor executable = null;
            if (call instanceof XAbstractFeatureCall && (featureCall = (XAbstractFeatureCall)call).getFeature() instanceof JvmExecutable) {
                executable = (JvmExecutable)featureCall.getFeature();
            }
            if (call instanceof XConstructorCall) {
                XConstructorCall constructorCall = (XConstructorCall)call;
                executable = constructorCall.getConstructor();
            }
            if (executable != null) {
                for (Pair<JvmTypeParameter, JvmTypeReference> pair : this.getBoundTypePairs(call, (JvmExecutable)executable)) {
                    JvmTypeParameter unresolvedType = (JvmTypeParameter)pair.getFirst();
                    JvmTypeReference resolvedType = (JvmTypeReference)pair.getSecond();
                    if (unresolvedType == null || resolvedType == null) continue;
                    String toBeReplaced = unresolvedType.getSimpleName();
                    String with = resolvedType.getSimpleName();
                    output = output.replaceAll("\\b" + Pattern.quote(toBeReplaced) + "\\b", with);
                }
            }
        }
        return output;
    }

    protected List<Pair<JvmTypeParameter, JvmTypeReference>> getBoundTypePairs(XExpression call, JvmExecutable executable) {
        ITypeArgumentContext typeArgumentContext = null;
        if (call instanceof XAbstractFeatureCall) {
            typeArgumentContext = this.typeArgumentContextProvider.getTypeArgumentContext((TypeArgumentContextProvider.Request)this.featureCallRequestProvider.get((XAbstractFeatureCall)call));
        } else if (call instanceof XConstructorCall) {
            XConstructorCall constructorCall = (XConstructorCall)call;
            typeArgumentContext = this.typeProvider.getTypeArgumentContext(constructorCall, constructorCall.getConstructor());
        }
        ArrayList pairs = Lists.newArrayList();
        if (typeArgumentContext != null) {
            for (JvmTypeParameter jvmTypeParameter : executable.getTypeParameters()) {
                pairs.add(Tuples.create((Object)jvmTypeParameter, (Object)typeArgumentContext.getBoundArgument(jvmTypeParameter)));
            }
            JvmTypeParameterDeclarator nearestDeclarator = (JvmTypeParameterDeclarator)EcoreUtil2.getContainerOfType((EObject)executable.eContainer(), JvmTypeParameterDeclarator.class);
            if (nearestDeclarator != null) {
                for (JvmTypeParameter jvmTypeParameter : nearestDeclarator.getTypeParameters()) {
                    pairs.add(Tuples.create((Object)jvmTypeParameter, (Object)typeArgumentContext.getBoundArgument(jvmTypeParameter)));
                }
            }
        }
        return pairs;
    }

    public String getJavaSignature(IJavaElement javaElement) {
        return JavaElementLinks.getElementLabel((IJavaElement)javaElement, (long)HoverGenericsResolver.getHeaderFlags(javaElement));
    }

    private static long getHeaderFlags(IJavaElement element) {
        switch (element.getElementType()) {
            case 14: {
                return LOCAL_VARIABLE_FLAGS;
            }
            case 15: {
                return TYPE_PARAMETER_FLAGS;
            }
        }
        return LABEL_FLAGS;
    }
}

