/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.syntaxcoloring;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.XtextSourceViewer;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.IXtextModelListener;
import org.eclipse.xtext.ui.editor.model.XtextDocument;
import org.eclipse.xtext.ui.editor.syntaxcoloring.AttributedPosition;
import org.eclipse.xtext.ui.editor.syntaxcoloring.HighlightingPresenter;
import org.eclipse.xtext.ui.editor.syntaxcoloring.IHighlightedPositionAcceptor;
import org.eclipse.xtext.ui.editor.syntaxcoloring.ISemanticHighlightingCalculator;
import org.eclipse.xtext.ui.editor.syntaxcoloring.ITextAttributeProvider;
import org.eclipse.xtext.ui.editor.syntaxcoloring.MergingHighlightedPositionAcceptor;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HighlightingReconciler
implements ITextInputListener,
IXtextModelListener,
IHighlightedPositionAcceptor {
    @Inject(optional=true)
    private ISemanticHighlightingCalculator calculator;
    @Inject
    private ITextAttributeProvider attributeProvider;
    private XtextEditor editor;
    private XtextSourceViewer sourceViewer;
    private HighlightingPresenter presenter;
    private final List<AttributedPosition> addedPositions = new ArrayList<AttributedPosition>();
    private List<AttributedPosition> removedPositions = new ArrayList<AttributedPosition>();
    private int removedPositionCount;
    private final Object fReconcileLock = new Object();
    private boolean reconciling = false;

    private void startReconcilingPositions() {
        this.presenter.addAllPositions(this.removedPositions);
        this.removedPositionCount = this.removedPositions.size();
    }

    private void reconcilePositions(XtextResource resource) {
        MergingHighlightedPositionAcceptor acceptor = new MergingHighlightedPositionAcceptor(this.calculator);
        acceptor.provideHighlightingFor(resource, this);
        List<AttributedPosition> oldPositions = this.removedPositions;
        ArrayList<AttributedPosition> newPositions = new ArrayList<AttributedPosition>(this.removedPositionCount);
        int i = 0;
        int n = oldPositions.size();
        while (i < n) {
            AttributedPosition current = oldPositions.get(i);
            if (current != null) {
                newPositions.add(current);
            }
            ++i;
        }
        this.removedPositions = newPositions;
    }

    @Override
    public void addPosition(int offset, int length, String ... ids) {
        TextAttribute highlighting;
        TextAttribute textAttribute = highlighting = ids.length == 1 ? this.attributeProvider.getAttribute(ids[0]) : this.attributeProvider.getMergedAttributes(ids);
        if (highlighting == null) {
            return;
        }
        boolean isExisting = false;
        int i = 0;
        int n = this.removedPositions.size();
        while (i < n) {
            AttributedPosition position = this.removedPositions.get(i);
            if (position != null && position.isEqual(offset, length, highlighting)) {
                isExisting = true;
                this.removedPositions.set(i, null);
                --this.removedPositionCount;
                break;
            }
            ++i;
        }
        if (!isExisting && this.presenter != null) {
            AttributedPosition position = this.presenter.createHighlightedPosition(offset, length, highlighting);
            this.addedPositions.add(position);
        }
    }

    private void updatePresentation(TextPresentation textPresentation, List<AttributedPosition> addedPositions, List<AttributedPosition> removedPositions) {
        Runnable runnable = this.presenter.createUpdateRunnable(textPresentation, addedPositions, removedPositions);
        if (runnable == null) {
            return;
        }
        Display display = this.getDisplay();
        display.asyncExec(runnable);
    }

    private Display getDisplay() {
        XtextEditor editor = this.editor;
        if (editor == null) {
            if (this.sourceViewer != null) {
                return this.sourceViewer.getControl().getDisplay();
            }
            return null;
        }
        IWorkbenchPartSite site = editor.getSite();
        if (site == null) {
            return null;
        }
        Shell shell = site.getShell();
        if (shell == null || shell.isDisposed()) {
            return null;
        }
        Display display = shell.getDisplay();
        if (display == null || display.isDisposed()) {
            return null;
        }
        return display;
    }

    private void stopReconcilingPositions() {
        this.removedPositions.clear();
        this.removedPositionCount = 0;
        this.addedPositions.clear();
    }

    public void install(XtextEditor editor, XtextSourceViewer sourceViewer, HighlightingPresenter presenter) {
        this.presenter = presenter;
        this.editor = editor;
        this.sourceViewer = sourceViewer;
        if (this.calculator != null) {
            if (editor == null) {
                ((IXtextDocument)sourceViewer.getDocument()).addModelListener(this);
            } else if (editor.getDocument() != null) {
                editor.getDocument().addModelListener(this);
            }
            sourceViewer.addTextInputListener(this);
        }
        this.refresh();
    }

    public void uninstall() {
        if (this.presenter != null) {
            this.presenter.setCanceled(true);
        }
        if (this.sourceViewer.getDocument() != null && this.calculator != null) {
            XtextDocument document = (XtextDocument)this.sourceViewer.getDocument();
            document.removeModelListener(this);
            this.sourceViewer.removeTextInputListener(this);
        }
        this.editor = null;
        this.sourceViewer = null;
        this.presenter = null;
    }

    public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
        if (oldInput != null) {
            ((IXtextDocument)oldInput).removeModelListener(this);
        }
    }

    public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
        if (newInput != null) {
            this.refresh();
            ((IXtextDocument)newInput).addModelListener(this);
        }
    }

    public void refresh() {
        if (this.calculator != null) {
            new Job("calculating highlighting"){

                protected IStatus run(IProgressMonitor monitor) {
                    ((XtextDocument)HighlightingReconciler.this.sourceViewer.getDocument()).readOnly(new IUnitOfWork.Void<XtextResource>(){

                        public void process(XtextResource state) throws Exception {
                            HighlightingReconciler.this.modelChanged(state);
                        }
                    });
                    return Status.OK_STATUS;
                }
            }.schedule();
        } else {
            Display display = this.getDisplay();
            display.asyncExec(this.presenter.createSimpleUpdateRunnable());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void modelChanged(XtextResource resource) {
        Object object = this.fReconcileLock;
        synchronized (object) {
            if (this.reconciling) {
                return;
            }
            this.reconciling = true;
        }
        HighlightingPresenter highlightingPresenter = this.presenter;
        try {
            block23: {
                block22: {
                    if (highlightingPresenter == null) break block22;
                    highlightingPresenter.setCanceled(false);
                    if (!highlightingPresenter.isCanceled()) break block23;
                }
                Object object2 = this.fReconcileLock;
                synchronized (object2) {
                    this.reconciling = false;
                    return;
                }
            }
            this.startReconcilingPositions();
            if (!highlightingPresenter.isCanceled()) {
                this.reconcilePositions(resource);
            }
            TextPresentation[] textPresentation = new TextPresentation[1];
            if (!highlightingPresenter.isCanceled()) {
                textPresentation[0] = highlightingPresenter.createPresentation(this.addedPositions, this.removedPositions);
            }
            if (!highlightingPresenter.isCanceled()) {
                this.updatePresentation(textPresentation[0], this.addedPositions, this.removedPositions);
            }
            this.stopReconcilingPositions();
        }
        catch (Throwable throwable) {
            Object object3 = this.fReconcileLock;
            synchronized (object3) {
                this.reconciling = false;
                throw throwable;
            }
        }
        Object object4 = this.fReconcileLock;
        synchronized (object4) {
            this.reconciling = false;
            return;
        }
    }

    @Deprecated
    protected boolean isModelInSyncWithDocument(XtextResource resource) {
        return true;
    }

    public void setCalculator(ISemanticHighlightingCalculator calculator) {
        this.calculator = calculator;
    }

    public ISemanticHighlightingCalculator getCalculator() {
        return this.calculator;
    }
}

