/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.contentassist;

import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.xtext.ui.editor.contentassist.ConfigurableCompletionProposal;
import org.eclipse.xtext.ui.editor.contentassist.IContentProposalPriorities;
import org.eclipse.xtext.util.Strings;

public class ContentProposalPriorities
implements IContentProposalPriorities {
    protected int crossReferencePriority = 500;
    protected int keywordPriority = 300;
    protected int defaultPriority = 400;
    protected int proposalWithPrefixMultiplier = 2;
    protected double sameTextMultiplier = 0.75;

    protected void adjustPriority(ICompletionProposal proposal, String prefix, int priority) {
        if (proposal == null || !(proposal instanceof ConfigurableCompletionProposal)) {
            return;
        }
        ConfigurableCompletionProposal castedProposal = (ConfigurableCompletionProposal)proposal;
        if (castedProposal.getPriority() != this.getDefaultPriority()) {
            return;
        }
        int adjustedPriority = priority;
        if (!Strings.isEmpty((String)prefix)) {
            adjustedPriority = castedProposal.getReplacementString().equals(prefix) ? (int)((double)adjustedPriority * this.sameTextMultiplier) : (adjustedPriority *= this.proposalWithPrefixMultiplier);
        }
        castedProposal.setPriority(adjustedPriority);
    }

    public void adjustKeywordPriority(ICompletionProposal proposal, String prefix) {
        this.adjustPriority(proposal, prefix, this.keywordPriority);
    }

    public void adjustCrossReferencePriority(ICompletionProposal proposal, String prefix) {
        this.adjustPriority(proposal, prefix, this.crossReferencePriority);
    }

    public int getDefaultPriority() {
        return this.defaultPriority;
    }
}

