/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator.parser.packrat;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.Alternatives;
import org.eclipse.xtext.CharacterRange;
import org.eclipse.xtext.EOF;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Group;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.NegatedToken;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.UntilToken;
import org.eclipse.xtext.Wildcard;
import org.eclipse.xtext.parser.packrat.ICharSequenceWithOffset;
import org.eclipse.xtext.parser.packrat.IMarkerFactory;
import org.eclipse.xtext.parser.packrat.matching.StringWithOffset;
import org.eclipse.xtext.util.XtextSwitch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TerminalRuleInterpreter
extends XtextSwitch<Boolean> {
    private final ICharSequenceWithOffset input;
    private final IMarkerFactory markerFactory;

    public TerminalRuleInterpreter(Keyword keyword) {
        this(keyword.getValue());
    }

    public TerminalRuleInterpreter(String input) {
        this(new StringWithOffset(input));
    }

    public TerminalRuleInterpreter(StringWithOffset input) {
        this((ICharSequenceWithOffset)input, (IMarkerFactory)input);
    }

    public boolean matches(TerminalRule rule) {
        return (Boolean)this.doSwitch((EObject)rule) != false && this.eof();
    }

    private boolean eof() {
        return this.input.getOffset() >= this.input.length();
    }

    public TerminalRuleInterpreter(ICharSequenceWithOffset input, IMarkerFactory markerFactory) {
        this.input = input;
        this.markerFactory = markerFactory;
    }

    public Boolean caseAlternatives(Alternatives object) {
        boolean result = false;
        block0: while (true) {
            for (AbstractElement element : object.getElements()) {
                if (!((Boolean)this.doSwitch((EObject)element)).booleanValue()) continue;
                result = true;
                if (GrammarUtil.isMultipleCardinality((AbstractElement)object)) continue block0;
            }
            break;
        }
        if (!result && !GrammarUtil.isOptionalCardinality((AbstractElement)object)) {
            return false;
        }
        return true;
    }

    public Boolean caseCharacterRange(CharacterRange object) {
        boolean result = false;
        if (object.getLeft().getValue().length() != 1 || object.getRight().getValue().length() != 1) {
            throw new IllegalStateException("ranges cannot use strings as left or right, that are longer then 1 character.");
        }
        while (!this.eof()) {
            char left = object.getLeft().getValue().charAt(0);
            char right = object.getRight().getValue().charAt(0);
            char candidate = this.input.charAt(this.input.getOffset());
            if (left > candidate || right < candidate) break;
            this.input.incOffset();
            result = true;
            if (GrammarUtil.isMultipleCardinality((AbstractElement)object)) continue;
        }
        if (!result && !GrammarUtil.isOptionalCardinality((AbstractElement)object)) {
            return false;
        }
        return true;
    }

    public Boolean defaultCase(EObject object) {
        throw new IllegalArgumentException(String.valueOf(object.eClass().getName()) + " is not a valid argument.");
    }

    public Boolean caseGroup(Group object) {
        boolean result = false;
        block0: do {
            IMarkerFactory.IMarker marker = this.markerFactory.mark();
            for (AbstractElement element : object.getElements()) {
                if (((Boolean)this.doSwitch((EObject)element)).booleanValue()) continue;
                marker.rollback();
                break block0;
            }
            result = true;
        } while (GrammarUtil.isMultipleCardinality((AbstractElement)object));
        if (!result && !GrammarUtil.isOptionalCardinality((AbstractElement)object)) {
            return false;
        }
        return true;
    }

    public Boolean caseKeyword(Keyword object) {
        boolean result = false;
        String value = object.getValue();
        while (this.input.getOffset() + value.length() <= this.input.length() && value.equals(this.input.subSequence(this.input.getOffset(), this.input.getOffset() + value.length()).toString())) {
            this.input.incOffset(value.length());
            result = true;
            if (GrammarUtil.isMultipleCardinality((AbstractElement)object)) continue;
        }
        if (!result && !GrammarUtil.isOptionalCardinality((AbstractElement)object)) {
            return false;
        }
        return true;
    }

    public Boolean caseWildcard(Wildcard object) {
        boolean result = false;
        while (!this.eof()) {
            this.input.incOffset();
            result = true;
            if (GrammarUtil.isMultipleCardinality((AbstractElement)object)) continue;
        }
        if (!result && !GrammarUtil.isOptionalCardinality((AbstractElement)object)) {
            return false;
        }
        return true;
    }

    public Boolean caseEOF(EOF object) {
        if (this.eof()) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Boolean caseTerminalRule(TerminalRule object) {
        return (Boolean)this.doSwitch((EObject)object.getAlternatives());
    }

    public Boolean caseParserRule(ParserRule object) {
        throw new IllegalStateException("Cannot call parser rules that are not terminal rules.");
    }

    public Boolean caseRuleCall(RuleCall object) {
        boolean result = false;
        while (((Boolean)this.doSwitch((EObject)object.getRule())).booleanValue()) {
            result = true;
            if (GrammarUtil.isMultipleCardinality((AbstractElement)object)) continue;
        }
        if (!result && !GrammarUtil.isOptionalCardinality((AbstractElement)object)) {
            return false;
        }
        return true;
    }

    public Boolean caseUntilToken(UntilToken object) {
        if (GrammarUtil.isOptionalCardinality((AbstractElement)object) || GrammarUtil.isMultipleCardinality((AbstractElement)object)) {
            throw new IllegalStateException("cardinality has to be default for until tokens");
        }
        IMarkerFactory.IMarker marker = this.markerFactory.mark();
        while (!this.eof()) {
            if (((Boolean)this.doSwitch((EObject)object.getTerminal())).booleanValue()) {
                return true;
            }
            this.input.incOffset();
        }
        marker.rollback();
        return false;
    }

    public Boolean caseNegatedToken(NegatedToken object) {
        boolean result = false;
        while (!this.eof()) {
            IMarkerFactory.IMarker marker = this.markerFactory.mark();
            if (((Boolean)this.doSwitch((EObject)object.getTerminal())).booleanValue()) {
                marker.rollback();
                break;
            }
            result = true;
            this.input.incOffset();
            if (GrammarUtil.isMultipleCardinality((AbstractElement)object)) continue;
        }
        if (!result && !GrammarUtil.isOptionalCardinality((AbstractElement)object)) {
            return false;
        }
        return true;
    }
}

