/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.conformance;

import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.xbase.typesystem.conformance.ConformanceHint;
import org.eclipse.xtext.xbase.typesystem.conformance.TypeConformanceComputationArgument;
import org.eclipse.xtext.xbase.typesystem.conformance.TypeConformanceComputer;
import org.eclipse.xtext.xbase.typesystem.conformance.TypeConformanceResult;
import org.eclipse.xtext.xbase.typesystem.conformance.TypeConformanceStrategy;
import org.eclipse.xtext.xbase.typesystem.references.AnyTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ArrayTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.UnboundTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.WildcardTypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonNullByDefault
public class ArrayConformanceStrategy
extends TypeConformanceStrategy<ArrayTypeReference> {
    public ArrayConformanceStrategy(TypeConformanceComputer conformanceComputer) {
        super(conformanceComputer);
    }

    @Override
    protected TypeConformanceResult doVisitArrayTypeReference(ArrayTypeReference left, ArrayTypeReference right, TypeConformanceComputationArgument.Internal<ArrayTypeReference> param) {
        LightweightTypeReference leftComponent = left.getComponentType();
        LightweightTypeReference rightComponent = right.getComponentType();
        return this.conformanceComputer.isConformant(leftComponent, rightComponent, new TypeConformanceComputationArgument(param.rawType, param.asTypeArgument, false, false, param.unboundComputationAddsHints, false));
    }

    @Override
    protected TypeConformanceResult doVisitWildcardTypeReference(ArrayTypeReference left, WildcardTypeReference right, TypeConformanceComputationArgument.Internal<ArrayTypeReference> param) {
        if (!param.isAsTypeArgument()) {
            for (LightweightTypeReference upperBound : right.getUpperBounds()) {
                TypeConformanceResult result = this.conformanceComputer.isConformant((LightweightTypeReference)left, upperBound, param);
                if (!result.isConformant()) continue;
                return result;
            }
        }
        return TypeConformanceResult.create(param, ConformanceHint.INCOMPATIBLE);
    }

    @Override
    protected TypeConformanceResult doVisitParameterizedTypeReference(ArrayTypeReference left, ParameterizedTypeReference right, TypeConformanceComputationArgument.Internal<ArrayTypeReference> param) {
        if (!param.asTypeArgument) {
            ArrayTypeReference rightAsArray;
            JvmType type = right.getType();
            if (type instanceof JvmTypeParameter) {
                TypeConformanceComputationArgument paramWithoutSuperTypeCheck = new TypeConformanceComputationArgument(param.rawType, true, param.allowPrimitiveConversion, param.allowPrimitiveWidening, param.unboundComputationAddsHints, param.allowSynonyms);
                for (LightweightTypeReference rightSuperTypes : right.getAllSuperTypes()) {
                    TypeConformanceResult result = this.conformanceComputer.isConformant((LightweightTypeReference)left, rightSuperTypes, paramWithoutSuperTypeCheck);
                    if (!result.isConformant()) continue;
                    return TypeConformanceResult.merge(result, TypeConformanceResult.create(param, ConformanceHint.SUBTYPE));
                }
            } else if (param.allowSynonyms && (rightAsArray = right.tryConvertToArray()) != null) {
                TypeConformanceResult result;
                if (left.getComponentType().isPrimitive() && rightAsArray.getComponentType().isWrapper()) {
                    LightweightTypeReference primitive = rightAsArray.getComponentType().getPrimitiveIfWrapperType();
                    rightAsArray = new ArrayTypeReference(rightAsArray.getOwner(), primitive);
                }
                if ((result = this.conformanceComputer.isConformant((LightweightTypeReference)left, (LightweightTypeReference)rightAsArray, param)).isConformant()) {
                    return TypeConformanceResult.merge(result, TypeConformanceResult.create(param, ConformanceHint.DEMAND_CONVERSION, ConformanceHint.SYNONYM));
                }
            }
        }
        return TypeConformanceResult.create(param, ConformanceHint.INCOMPATIBLE);
    }

    @Override
    protected TypeConformanceResult doVisitAnyTypeReference(ArrayTypeReference left, AnyTypeReference reference, TypeConformanceComputationArgument.Internal<ArrayTypeReference> param) {
        return TypeConformanceResult.create(param, ConformanceHint.SUCCESS);
    }

    @Override
    protected TypeConformanceResult doVisitUnboundTypeReference(ArrayTypeReference left, UnboundTypeReference right, TypeConformanceComputationArgument.Internal<ArrayTypeReference> param) {
        if (right.canResolveTo(left)) {
            return TypeConformanceResult.create(param, ConformanceHint.SUCCESS);
        }
        return TypeConformanceResult.create(param, ConformanceHint.INCOMPATIBLE);
    }

    @Override
    protected TypeConformanceResult doVisitTypeReference(ArrayTypeReference left, LightweightTypeReference reference, TypeConformanceComputationArgument.Internal<ArrayTypeReference> param) {
        return TypeConformanceResult.create(param, ConformanceHint.INCOMPATIBLE);
    }
}

