/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.quickfix;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.xtend.core.services.XtendGrammarAccess;
import org.eclipse.xtend.core.xtend.XtendClass;
import org.eclipse.xtend.core.xtend.XtendFile;
import org.eclipse.xtend.core.xtend.XtendFunction;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtend.ide.buildpath.XtendLibClasspathAdder;
import org.eclipse.xtend.ide.codebuilder.InsertionOffsets;
import org.eclipse.xtend.ide.codebuilder.MemberFromSuperImplementor;
import org.eclipse.xtend.ide.quickfix.CreateMemberQuickfixes;
import org.eclipse.xtend.ide.quickfix.CreateXtendTypeQuickfixes;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.common.types.access.jdt.IJavaProjectProvider;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.edit.IModification;
import org.eclipse.xtext.ui.editor.model.edit.IModificationContext;
import org.eclipse.xtext.ui.editor.model.edit.ISemanticModification;
import org.eclipse.xtext.ui.editor.quickfix.Fix;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolution;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionAcceptor;
import org.eclipse.xtext.util.StopWatch;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.xbase.XBlockExpression;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.compiler.IAppendable;
import org.eclipse.xtext.xbase.compiler.output.XtypeTypeReferenceSerializer;
import org.eclipse.xtext.xbase.ui.contentassist.ReplacingAppendable;
import org.eclipse.xtext.xbase.ui.quickfix.XbaseQuickfixProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class XtendQuickfixProvider
extends XbaseQuickfixProvider {
    private static final Logger logger = Logger.getLogger(XtendQuickfixProvider.class);
    @Inject
    private ReplacingAppendable.Factory appendableFactory;
    @Inject
    private XtypeTypeReferenceSerializer typeRefSerializer;
    @Inject
    private TypeReferences typeRefs;
    @Inject
    private XtendGrammarAccess grammarAccess;
    @Inject
    private InsertionOffsets insertionOffsets;
    @Inject
    private MemberFromSuperImplementor superMemberImplementor;
    @Inject
    private XtendLibClasspathAdder xtendLibAdder;
    @Inject
    private IJavaProjectProvider projectProvider;
    @Inject
    private CreateXtendTypeQuickfixes createTypeQuickfixes;
    @Inject
    private CreateMemberQuickfixes createMemberQuickfixes;
    private static final Set<String> LINKING_ISSUE_CODES = Sets.newHashSet((Object[])new String[]{"org.eclipse.xtend.core.validation.IssueCodes.feature_linking", "org.eclipse.xtext.diagnostics.Diagnostic.Linking", "org.eclipse.xtend.core.validation.IssueCodes.java_doc_linking", "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_argument_types", "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_number_of_arguments"});

    public boolean hasResolutionFor(String issueCode) {
        return LINKING_ISSUE_CODES.contains(issueCode) || super.hasResolutionFor(issueCode);
    }

    public List<IssueResolution> getResolutions(Issue issue) {
        StopWatch stopWatch = new StopWatch(logger);
        try {
            if (LINKING_ISSUE_CODES.contains(issue.getCode())) {
                ArrayList<IssueResolution> result = new ArrayList<IssueResolution>();
                result.addAll(this.getResolutionsForLinkingIssue(issue));
                ArrayList<IssueResolution> arrayList = result;
                return arrayList;
            }
            List list = super.getResolutions(issue);
            return list;
        }
        finally {
            stopWatch.resetAndLog("#getResolutions");
        }
    }

    protected EReference getUnresolvedEReference(Issue issue, EObject target) {
        EReference reference = super.getUnresolvedEReference(issue, target);
        if (reference == null && issue.getCode().equals("org.eclipse.xtend.core.validation.IssueCodes.java_doc_linking")) {
            return TypesPackage.Literals.JVM_PARAMETERIZED_TYPE_REFERENCE__TYPE;
        }
        return reference;
    }

    protected void createLinkingIssueQuickfixes(Issue issue, IssueResolutionAcceptor issueResolutionAcceptor, IXtextDocument xtextDocument, XtextResource resource, EObject referenceOwner, EReference unresolvedReference) throws Exception {
        this.javaTypeQuickfixes.addQuickfixes(issue, issueResolutionAcceptor, xtextDocument, resource, referenceOwner, unresolvedReference);
        this.createTypeQuickfixes.addQuickfixes(issue, issueResolutionAcceptor, xtextDocument, resource, referenceOwner, unresolvedReference);
        this.createMemberQuickfixes.addQuickfixes(issue, issueResolutionAcceptor, xtextDocument, resource, referenceOwner, unresolvedReference);
    }

    @Fix(value="org.eclipse.xtend.core.validation.IssueCodes.inconsistent_indentation")
    public void fixIndentation(final Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Correct indentation", "Correctly indents this line in this rich string", "fix_indent.gif", new IModification(){

            public void apply(IModificationContext context) throws Exception {
                context.getXtextDocument().replace(issue.getOffset().intValue(), issue.getLength().intValue(), issue.getData()[0]);
            }
        });
    }

    @Fix(value="org.eclipse.xtend.core.validation.IssueCodes.missing_override")
    public void fixMissingOverride(Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Change 'def' to 'override'", "Marks this function as 'override'", "fix_indent.gif", new ISemanticModification(){

            public void apply(EObject element, IModificationContext context) throws Exception {
                XtendQuickfixProvider.this.replaceKeyword((Keyword)XtendQuickfixProvider.this.grammarAccess.getMethodModifierAccess().findKeywords(new String[]{"def"}).get(0), "override", element, context.getXtextDocument());
            }
        });
    }

    @Fix(value="org.eclipse.xtend.core.validation.IssueCodes.obsolete_override")
    public void fixObsoleteOverride(Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Change 'override' to 'def'", "Removes 'override' from this function", "fix_indent.gif", new ISemanticModification(){

            public void apply(EObject element, IModificationContext context) throws Exception {
                XtendQuickfixProvider.this.replaceKeyword((Keyword)XtendQuickfixProvider.this.grammarAccess.getMethodModifierAccess().findKeywords(new String[]{"override"}).get(0), "def", element, context.getXtextDocument());
            }
        });
    }

    protected void replaceKeyword(Keyword keyword, String replacement, EObject container, IXtextDocument document) throws BadLocationException {
        ICompositeNode node = NodeModelUtils.findActualNodeFor((EObject)container);
        if (node != null) {
            for (ILeafNode leafNode : node.getLeafNodes()) {
                if (leafNode.getGrammarElement() != keyword) continue;
                String actualReplacement = replacement;
                if (!Character.isWhitespace(document.getChar(leafNode.getOffset() - 1))) {
                    actualReplacement = " " + replacement;
                }
                document.replace(leafNode.getOffset(), leafNode.getLength(), actualReplacement);
            }
        }
    }

    @Fix(value="org.eclipse.xtend.core.validation.IssueCodes.missing_constructor")
    public void addConstuctorFromSuper(Issue issue, IssueResolutionAcceptor acceptor) {
        if (issue.getData() != null) {
            int i = 0;
            while (i < issue.getData().length) {
                final URI constructorURI = URI.createURI((String)issue.getData()[i]);
                String javaSignature = issue.getData()[i + 1];
                String xtendSignature = "new" + javaSignature.substring(javaSignature.indexOf(40));
                acceptor.accept(issue, "Add constructor " + xtendSignature, "Add constructor " + xtendSignature, "fix_indent.gif", new ISemanticModification(){

                    public void apply(EObject element, IModificationContext context) throws Exception {
                        XtendClass clazz = (XtendClass)element;
                        ReplacingAppendable appendable = XtendQuickfixProvider.this.appendableFactory.get(context.getXtextDocument(), (EObject)clazz, XtendQuickfixProvider.this.insertionOffsets.getNewConstructorInsertOffset(null, (XtendTypeDeclaration)clazz), 0, 1, true);
                        EObject constructor = clazz.eResource().getResourceSet().getEObject(constructorURI, true);
                        if (constructor instanceof JvmConstructor) {
                            XtendQuickfixProvider.this.superMemberImplementor.appendConstructorFromSuper(clazz, (JvmConstructor)constructor, (IAppendable)appendable);
                        }
                        appendable.commitChanges();
                    }
                });
                i += 2;
            }
        }
    }

    @Fix(value="org.eclipse.xtend.core.validation.IssueCodes.class_must_be_defined_abstract")
    public void implementAbstractMethods(final Issue issue, IssueResolutionAcceptor acceptor) {
        if (issue.getData() != null && issue.getData().length > 0) {
            acceptor.accept(issue, "Add unimplemented methods", "Add unimplemented methods", "fix_indent.gif", new ISemanticModification(){

                public void apply(EObject element, IModificationContext context) throws Exception {
                    XtendClass clazz = (XtendClass)element;
                    IXtextDocument document = context.getXtextDocument();
                    ReplacingAppendable appendable = XtendQuickfixProvider.this.appendableFactory.get(document, (EObject)clazz, XtendQuickfixProvider.this.insertionOffsets.getNewMethodInsertOffset(null, (XtendTypeDeclaration)clazz), 0, 1, true);
                    boolean isFirst = true;
                    String[] stringArray = issue.getData();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String operationUriAsString = stringArray[n2];
                        URI operationURI = URI.createURI((String)operationUriAsString);
                        EObject overridden = clazz.eResource().getResourceSet().getEObject(operationURI, true);
                        if (overridden instanceof JvmOperation) {
                            if (!isFirst) {
                                appendable.newLine().newLine();
                            }
                            isFirst = false;
                            XtendQuickfixProvider.this.superMemberImplementor.appendOverrideFunction(clazz, (JvmOperation)overridden, (IAppendable)appendable);
                        }
                        ++n2;
                    }
                    appendable.commitChanges();
                }
            });
        }
        acceptor.accept(issue, "Make class abstract", "Make class abstract", "fix_indent.gif", new ISemanticModification(){

            public void apply(EObject element, IModificationContext context) throws Exception {
                XtendQuickfixProvider.this.internalDoAddAbstractKeyword(element, context);
            }
        });
    }

    @Fix(value="org.eclipse.xtext.xbase.validation.IssueCodes.unhandled_exception")
    public void addThrowsDeclaration(final Issue issue, IssueResolutionAcceptor acceptor) {
        if (issue.getData() != null && issue.getData().length > 0) {
            acceptor.accept(issue, "Add throws declaration", "Add throws declaration", "fix_indent.gif", new ISemanticModification(){

                public void apply(EObject element, IModificationContext context) throws Exception {
                    XtendFunction xtendFunction;
                    XtextResource xtextResource;
                    String[] issueData = issue.getData();
                    List<JvmType> exceptions = XtendQuickfixProvider.this.getExceptions(issueData, xtextResource = (XtextResource)(xtendFunction = (XtendFunction)EcoreUtil2.getContainerOfType((EObject)element, XtendFunction.class)).eResource());
                    if (exceptions.size() > 0) {
                        EList thrownExceptions;
                        int insertPosition;
                        if (xtendFunction.getExpression() == null) {
                            ICompositeNode functionNode = NodeModelUtils.findActualNodeFor((EObject)xtendFunction);
                            if (functionNode == null) {
                                throw new IllegalStateException("functionNode may not be null");
                            }
                            insertPosition = functionNode.getOffset() + functionNode.getLength();
                        } else {
                            ICompositeNode expressionNode = NodeModelUtils.findActualNodeFor((EObject)xtendFunction.getExpression());
                            if (expressionNode == null) {
                                throw new IllegalStateException("expressionNode may not be null");
                            }
                            insertPosition = expressionNode.getOffset();
                        }
                        ReplacingAppendable appendable = XtendQuickfixProvider.this.appendableFactory.get(context.getXtextDocument(), (EObject)xtendFunction, insertPosition, 0);
                        if (xtendFunction.getExpression() == null) {
                            appendable.append((CharSequence)" ");
                        }
                        if ((thrownExceptions = xtendFunction.getExceptions()).isEmpty()) {
                            appendable.append((CharSequence)"throws ");
                        } else {
                            appendable.append((CharSequence)", ");
                        }
                        int i = 0;
                        while (i < exceptions.size()) {
                            XtendQuickfixProvider.this.typeRefSerializer.serialize((JvmTypeReference)XtendQuickfixProvider.this.typeRefs.createTypeRef(exceptions.get(i), new JvmTypeReference[0]), (EObject)xtendFunction, (IAppendable)appendable);
                            if (i != exceptions.size() - 1) {
                                appendable.append((CharSequence)", ");
                            }
                            ++i;
                        }
                        if (xtendFunction.getExpression() != null) {
                            appendable.append((CharSequence)" ");
                        }
                        appendable.commitChanges();
                    }
                }
            });
        }
    }

    protected List<JvmType> getExceptions(String[] issueData, XtextResource resource) {
        ArrayList exceptions = Lists.newArrayList();
        int i = 0;
        while (i < issueData.length - 1) {
            URI exceptionURI = URI.createURI((String)issueData[i]);
            EObject exception = resource.getResourceSet().getEObject(exceptionURI, true);
            if (exception instanceof JvmType) {
                exceptions.add((JvmType)exception);
            }
            ++i;
        }
        return exceptions;
    }

    @Fix(value="org.eclipse.xtext.xbase.validation.IssueCodes.unhandled_exception")
    public void surroundWithTryCatch(final Issue issue, IssueResolutionAcceptor acceptor) {
        if (issue.getData() != null && issue.getData().length > 1) {
            acceptor.accept(issue, "Surround with try/catch block", "Surround with try/catch block", "fix_indent.gif", new ISemanticModification(){

                public void apply(EObject element, IModificationContext context) throws Exception {
                    String[] issueData = issue.getData();
                    URI childURI = URI.createURI((String)issueData[issueData.length - 1]);
                    XtextResource xtextResource = (XtextResource)element.eResource();
                    List<JvmType> exceptions = XtendQuickfixProvider.this.getExceptions(issueData, xtextResource);
                    if (exceptions.size() > 0) {
                        EObject childThrowingException = xtextResource.getResourceSet().getEObject(childURI, true);
                        XExpression toBeSurrounded = XtendQuickfixProvider.this.findContainerExpressionInBlockExpression(childThrowingException);
                        IXtextDocument xtextDocument = context.getXtextDocument();
                        if (toBeSurrounded != null) {
                            ICompositeNode toBeSurroundedNode = NodeModelUtils.findActualNodeFor((EObject)toBeSurrounded);
                            if (toBeSurroundedNode == null) {
                                throw new IllegalStateException("toBeSurroundedNode may not be null");
                            }
                            ReplacingAppendable appendable = XtendQuickfixProvider.this.appendableFactory.get(context.getXtextDocument(), childThrowingException, toBeSurroundedNode.getOffset(), toBeSurroundedNode.getLength());
                            appendable.append((CharSequence)"try {").increaseIndentation().newLine().append((CharSequence)xtextDocument.get(toBeSurroundedNode.getOffset(), toBeSurroundedNode.getLength())).decreaseIndentation().newLine();
                            for (JvmType exceptionType : exceptions) {
                                appendable.append((CharSequence)"} catch (");
                                XtendQuickfixProvider.this.typeRefSerializer.serialize((JvmTypeReference)XtendQuickfixProvider.this.typeRefs.createTypeRef(exceptionType, new JvmTypeReference[0]), childThrowingException, (IAppendable)appendable);
                                appendable.append((CharSequence)" ").openScope();
                                String exceptionVar = appendable.declareVariable((Object)exceptionType, "exc");
                                appendable.append((CharSequence)exceptionVar).append((CharSequence)") {").increaseIndentation().newLine().append((CharSequence)("throw new RuntimeException(\"auto-generated try/catch\", " + exceptionVar + ")")).decreaseIndentation().newLine().closeScope();
                            }
                            appendable.append((CharSequence)"}").closeScope();
                            appendable.commitChanges();
                        }
                    }
                }
            });
        }
    }

    @Fix(value="org.eclipse.xtend.core.validation.IssueCodes.wrong_package")
    public void fixPackageName(Issue issue, IssueResolutionAcceptor acceptor) {
        if (issue.getData() != null && issue.getData().length == 1) {
            final String expectedPackage = issue.getData()[0];
            acceptor.accept(issue, "Change package declaration to '" + expectedPackage + "'", "Change package declaration to '" + expectedPackage + "'", "package_obj.gif", new ISemanticModification(){

                public void apply(EObject element, IModificationContext context) throws Exception {
                    ((XtendFile)element).setPackage(Strings.isEmpty((String)expectedPackage) ? null : expectedPackage);
                }
            });
        }
    }

    protected XExpression findContainerExpressionInBlockExpression(EObject expr) {
        if (expr == null) {
            return null;
        }
        EObject container = expr.eContainer();
        if (container instanceof XBlockExpression) {
            return (XExpression)expr;
        }
        return this.findContainerExpressionInBlockExpression(container);
    }

    @Fix(value="org.eclipse.xtend.core.validation.IssueCodes.xbase_lib_not_on_classpath")
    public void putXtendOnClasspath(Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Add Xtend libs to classpath", "Add Xtend libs to classpath", "fix_indent.gif", new ISemanticModification(){

            public void apply(EObject element, IModificationContext context) throws Exception {
                ResourceSet resourceSet = element.eResource().getResourceSet();
                IJavaProject javaProject = XtendQuickfixProvider.this.projectProvider.getJavaProject(resourceSet);
                XtendQuickfixProvider.this.xtendLibAdder.addLibsToClasspath(javaProject, (IProgressMonitor)new NullProgressMonitor());
            }
        });
    }

    @Fix(value="org.eclipse.xtend.core.validation.IssueCodes.missing_abstract")
    public void makeClassAbstract(Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Make class abstract", "Make class abstract", "fix_indent.gif", new ISemanticModification(){

            public void apply(EObject element, IModificationContext context) throws Exception {
                XtendQuickfixProvider.this.internalDoAddAbstractKeyword(element, context);
            }
        });
    }

    protected void internalDoAddAbstractKeyword(EObject element, IModificationContext context) throws BadLocationException {
        if (element instanceof XtendFunction) {
            element = element.eContainer();
        }
        if (element instanceof XtendClass) {
            XtendClass clazz = (XtendClass)element;
            IXtextDocument document = context.getXtextDocument();
            ICompositeNode clazzNode = NodeModelUtils.findActualNodeFor((EObject)clazz);
            if (clazzNode == null) {
                throw new IllegalStateException("Cannot determine node for clazz " + clazz.getName());
            }
            int offset = -1;
            for (ILeafNode leafNode : clazzNode.getLeafNodes()) {
                if (!leafNode.getText().equals("class")) continue;
                offset = leafNode.getOffset();
            }
            ReplacingAppendable appendable = this.appendableFactory.get(document, (EObject)clazz, offset, 0);
            appendable.append((CharSequence)"abstract ");
            appendable.commitChanges();
        }
    }
}

