/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.contentassist;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtend.core.jvmmodel.IXtendJvmAssociations;
import org.eclipse.xtend.core.validation.TypeErasedSignature;
import org.eclipse.xtend.core.xtend.XtendClass;
import org.eclipse.xtend.ide.codebuilder.MemberFromSuperImplementor;
import org.eclipse.xtend.ide.labeling.XtendImages;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.util.FeatureOverridesService;
import org.eclipse.xtext.common.types.util.ITypeArgumentContext;
import org.eclipse.xtext.common.types.util.TypeArgumentContextProvider;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.common.types.util.VisibilityService;
import org.eclipse.xtext.ui.IImageHelper;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;
import org.eclipse.xtext.ui.editor.contentassist.IProposalConflictHelper;
import org.eclipse.xtext.ui.editor.contentassist.PrefixMatcher;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.compiler.IAppendable;
import org.eclipse.xtext.xbase.ui.contentassist.ImportOrganizingProposal;
import org.eclipse.xtext.xbase.ui.contentassist.ReplacingAppendable;
import org.eclipse.xtext.xbase.ui.labeling.XbaseImageAdornments;
import org.eclipse.xtext.xbase.validation.UIStrings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImplementMemberFromSuperAssist {
    @Inject
    private TypeErasedSignature.Provider signatureProvider;
    @Inject
    private IXtendJvmAssociations associations;
    @Inject
    private FeatureOverridesService featureOverridesService;
    @Inject
    private TypeArgumentContextProvider typeArgumentContextProvider;
    @Inject
    private TypeReferences typeReferences;
    @Inject
    private VisibilityService visibilityService;
    @Inject
    private XtendImages images;
    @Inject
    XbaseImageAdornments adornments;
    @Inject
    private MemberFromSuperImplementor implementor;
    @Inject
    private UIStrings uiStrings;
    @Inject
    private ReplacingAppendable.Factory appendableFactory;
    @Inject
    private IImageHelper imageHelper;
    private static Pattern bodyExpressionPattern = Pattern.compile("\\{\\s*(.*?)\\s*$\\s*\\}", 40);

    protected Iterable<JvmExecutable> getImplementationCandidates(XtendClass clazz) {
        JvmGenericType inferredType = this.associations.getInferredType(clazz);
        if (inferredType == null) {
            return Collections.emptySet();
        }
        ITypeArgumentContext typeArgumentContext = this.typeArgumentContextProvider.getTypeArgumentContext((TypeArgumentContextProvider.Request)new TypeArgumentContextProvider.ReceiverRequest((JvmTypeReference)this.typeReferences.createTypeRef((JvmType)inferredType, new JvmTypeReference[0])));
        HashSet erasureKeys = Sets.newHashSet();
        for (JvmOperation op : inferredType.getDeclaredOperations()) {
            erasureKeys.add(this.signatureProvider.get((JvmExecutable)op));
        }
        ArrayList result = Lists.newArrayList();
        for (JvmExecutable executable : Iterables.filter((Iterable)this.featureOverridesService.getAllJvmFeatures((JvmDeclaredType)inferredType, typeArgumentContext), JvmExecutable.class)) {
            TypeErasedSignature erasureKey;
            if (!this.isCandidate(executable, (JvmDeclaredType)inferredType) || !erasureKeys.add(erasureKey = this.signatureProvider.get(executable))) continue;
            result.add(executable);
        }
        return result;
    }

    protected boolean isCandidate(JvmExecutable executable, JvmDeclaredType overrider) {
        if (executable.getDeclaringType() != overrider && this.visibilityService.isVisible((JvmMember)executable, overrider)) {
            if (executable instanceof JvmOperation) {
                JvmOperation operation = (JvmOperation)executable;
                return !operation.isFinal() && !operation.isStatic();
            }
            return executable instanceof JvmConstructor && Iterables.contains((Iterable)Lists.transform((List)overrider.getSuperTypes(), (Function)new Function<JvmTypeReference, JvmType>(){

                public JvmType apply(JvmTypeReference from) {
                    return from.getType();
                }
            }), (Object)executable.getDeclaringType());
        }
        return false;
    }

    public void createOverrideProposals(XtendClass model, ContentAssistContext context, ICompletionProposalAcceptor acceptor, IProposalConflictHelper conflictHelper) {
        Iterable<JvmExecutable> overrideables = this.getImplementationCandidates(model);
        for (JvmExecutable overridden : overrideables) {
            ICompletionProposal completionProposal = this.createOverrideMethodProposal(model, overridden, context, conflictHelper);
            if (completionProposal == null) continue;
            acceptor.accept(completionProposal);
        }
    }

    protected ICompletionProposal createOverrideMethodProposal(XtendClass model, JvmExecutable overridden, final ContentAssistContext context, IProposalConflictHelper conflictHelper) {
        String simpleName;
        ReplacingAppendable appendable = this.appendableFactory.get(context.getDocument(), (EObject)model, context.getReplaceRegion().getOffset(), context.getReplaceRegion().getLength(), 1, true);
        if (overridden instanceof JvmOperation) {
            this.implementor.appendOverrideFunction(model, (JvmOperation)overridden, (IAppendable)appendable);
            simpleName = overridden.getSimpleName();
        } else {
            this.implementor.appendConstructorFromSuper(model, (JvmConstructor)overridden, (IAppendable)appendable);
            simpleName = "new";
        }
        String code = appendable.getCode();
        if (!this.isValidProposal(code.trim(), context, conflictHelper) && !this.isValidProposal(simpleName, context, conflictHelper)) {
            return null;
        }
        ImageDescriptor imageDescriptor = this.images.forOperation(overridden.getVisibility(), this.adornments.getOverrideAdornment(overridden));
        ImportOrganizingProposal completionProposal = this.createCompletionProposal(appendable, context.getReplaceRegion(), this.getLabel(overridden), this.imageHelper.getImage(imageDescriptor));
        Matcher matcher = bodyExpressionPattern.matcher(code);
        if (matcher.find()) {
            int bodyExpressionLength = matcher.end(1) - matcher.start(1);
            int bodyExpressionStart = matcher.start(1) + appendable.getTotalOffset() - completionProposal.getReplacementOffset();
            if (bodyExpressionLength == 0) {
                completionProposal.setCursorPosition(bodyExpressionStart);
            } else {
                completionProposal.setSelectionStart(completionProposal.getReplacementOffset() + bodyExpressionStart);
                completionProposal.setSelectionLength(bodyExpressionLength);
                completionProposal.setAutoInsertable(false);
                completionProposal.setCursorPosition(bodyExpressionStart + bodyExpressionLength);
                completionProposal.setSimpleLinkedMode(context.getViewer(), new char[]{'\t'});
            }
        }
        completionProposal.setPriority(this.getPriority(model, overridden, context));
        completionProposal.setMatcher(new PrefixMatcher(){

            public boolean isCandidateMatchingPrefix(String name, String prefix) {
                PrefixMatcher delegate = context.getMatcher();
                boolean result = delegate.isCandidateMatchingPrefix(simpleName, prefix);
                return result;
            }
        });
        return completionProposal;
    }

    protected boolean isValidProposal(String proposal, ContentAssistContext context, IProposalConflictHelper conflictHelper) {
        if (proposal == null) {
            return false;
        }
        if (!context.getMatcher().isCandidateMatchingPrefix(proposal, context.getPrefix())) {
            return false;
        }
        return !conflictHelper.existsConflict(proposal, context);
    }

    protected int getPriority(XtendClass model, JvmExecutable overridden, ContentAssistContext context) {
        return overridden instanceof JvmOperation && ((JvmOperation)overridden).isAbstract() ? 400 : 350;
    }

    protected ImportOrganizingProposal createCompletionProposal(ReplacingAppendable appendable, Region replaceRegion, StyledString displayString, Image image) {
        return new ImportOrganizingProposal(appendable, replaceRegion.getOffset(), replaceRegion.getLength(), replaceRegion.getOffset(), image, displayString);
    }

    protected StyledString getLabel(JvmExecutable executable) {
        if (executable instanceof JvmOperation) {
            return new StyledString(this.uiStrings.signature(executable)).append(new StyledString(" - Override method from " + Strings.notNull((Object)((JvmOperation)executable).getDeclaringType().getSimpleName()), StyledString.QUALIFIER_STYLER));
        }
        return new StyledString("Add constructor 'new" + this.uiStrings.parameters((JvmIdentifiableElement)executable) + "'");
    }
}

