/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;

@Singleton
public class LanguageInfo {
    private final String languageName;

    @Inject
    public LanguageInfo(@Named(value="languageName") String languageName) {
        if (languageName == null) {
            throw new IllegalArgumentException("languageName may not be null");
        }
        this.languageName = languageName;
    }

    public String getLanguageName() {
        return this.languageName;
    }

    public String getShortName() {
        int lastIndex = this.languageName.lastIndexOf(46);
        if (lastIndex == -1) {
            return this.getLanguageName();
        }
        return this.getLanguageName().substring(lastIndex + 1);
    }

    public int hashCode() {
        return this.languageName.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LanguageInfo other = (LanguageInfo)obj;
        return this.languageName.equals(other.languageName);
    }
}

