/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.conformance;

import java.util.List;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.xtext.xbase.typesystem.conformance.ConformanceHint;
import org.eclipse.xtext.xbase.typesystem.conformance.TypeConformanceComputationArgument;
import org.eclipse.xtext.xbase.typesystem.conformance.TypeConformanceComputer;
import org.eclipse.xtext.xbase.typesystem.conformance.TypeConformanceResult;
import org.eclipse.xtext.xbase.typesystem.conformance.TypeConformanceStrategy;
import org.eclipse.xtext.xbase.typesystem.references.CompoundTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonNullByDefault
public class SynonymConformanceStrategy
extends TypeConformanceStrategy<CompoundTypeReference> {
    protected SynonymConformanceStrategy(TypeConformanceComputer conformanceComputer) {
        super(conformanceComputer);
    }

    @Override
    protected TypeConformanceResult doVisitTypeReference(CompoundTypeReference left, LightweightTypeReference right, TypeConformanceComputationArgument.Internal<CompoundTypeReference> param) {
        List<LightweightTypeReference> leftReferences = left.getMultiTypeComponents();
        if (leftReferences.isEmpty()) {
            return TypeConformanceResult.create(param, ConformanceHint.INCOMPATIBLE);
        }
        for (LightweightTypeReference reference : leftReferences) {
            TypeConformanceResult result = this.conformanceComputer.isConformant(reference, right, param);
            if (!result.isConformant()) continue;
            return result;
        }
        return TypeConformanceResult.create(param, ConformanceHint.INCOMPATIBLE);
    }

    @Override
    protected TypeConformanceResult doVisitMultiTypeReference(CompoundTypeReference left, CompoundTypeReference right, TypeConformanceComputationArgument.Internal<CompoundTypeReference> param) {
        return this.doVisitTypeReference(left, (LightweightTypeReference)right, param);
    }

    @Override
    protected TypeConformanceResult doVisitSynonymTypeReference(CompoundTypeReference left, CompoundTypeReference right, TypeConformanceComputationArgument.Internal<CompoundTypeReference> param) {
        return this.doVisitTypeReference(left, (LightweightTypeReference)right, param);
    }
}

