/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.hover;

import com.google.inject.Inject;
import java.net.URL;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.infoviews.JavadocView;
import org.eclipse.jdt.internal.ui.text.java.hover.JavadocBrowserInformationControlInput;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.internal.text.html.BrowserInformationControl;
import org.eclipse.jface.internal.text.html.BrowserInformationControlInput;
import org.eclipse.jface.internal.text.html.BrowserInput;
import org.eclipse.jface.internal.text.html.HTMLPrinter;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IInputChangedListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.access.jdt.TypeURIHelper;
import org.eclipse.xtext.common.types.util.jdt.IJavaElementFinder;
import org.eclipse.xtext.common.types.xtext.ui.JdtHoverProvider;
import org.eclipse.xtext.resource.IGlobalServiceProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.XtextUIMessages;
import org.eclipse.xtext.ui.editor.IURIEditorOpener;
import org.eclipse.xtext.ui.editor.hover.html.DefaultEObjectHoverProvider;
import org.eclipse.xtext.ui.editor.hover.html.IEObjectHoverDocumentationProvider;
import org.eclipse.xtext.ui.editor.hover.html.IXtextBrowserInformationControl;
import org.eclipse.xtext.ui.editor.hover.html.OpenBrowserUtil;
import org.eclipse.xtext.ui.editor.hover.html.XtextBrowserInformationControlInput;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XSwitchExpression;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelAssociations;
import org.eclipse.xtext.xbase.ui.hover.HoverGenericsResolver;
import org.eclipse.xtext.xbase.ui.hover.XbaseDeclarativeHoverSignatureProvider;
import org.eclipse.xtext.xbase.ui.hover.XbaseElementLinks;
import org.eclipse.xtext.xbase.ui.hover.XbaseHoverConfiguration;
import org.eclipse.xtext.xbase.ui.hover.XbaseInformationControl;
import org.eclipse.xtext.xbase.ui.hover.XbaseInformationControlInput;

public class XbaseHoverProvider
extends DefaultEObjectHoverProvider {
    @Inject
    protected XbaseDeclarativeHoverSignatureProvider hoverSignatureProvider;
    @Inject
    protected IJvmModelAssociations associations;
    @Inject
    protected IJavaElementFinder javaElementFinder;
    @Inject
    protected TypeURIHelper typeURIHelper;
    @Inject
    protected IURIEditorOpener uriEditorOpener;
    @Inject
    protected XbaseElementLinks elementLinks;
    @Inject
    protected XbaseHoverConfiguration xbaseHoverConfiguration;
    @Inject
    protected HoverGenericsResolver hoverGenericsResolver;
    @Inject
    protected ILabelProvider labelProvider;
    @Inject
    protected IGlobalServiceProvider serviceProvider;
    protected JdtHoverProvider.JavadocHoverWrapper javadocHover = new JdtHoverProvider.JavadocHoverWrapper();
    protected IInformationControlCreator hoverControlCreator;
    protected IInformationControlCreator presenterControlCreator;
    protected static final String LEADING_PADDING = "<div style='position: relative; left: 16;'>";
    protected static final String TRAILING_PADDING = "</div>";

    protected XtextBrowserInformationControlInput getHoverInfo(EObject element, IRegion hoverRegion, XtextBrowserInformationControlInput previous) {
        String html;
        if (this.isValidationDisabled(element)) {
            return null;
        }
        EObject objectToView = this.getObjectToView(element);
        if (objectToView == null || objectToView.eIsProxy()) {
            return null;
        }
        IJavaElement javaElement = null;
        if (objectToView != element && objectToView instanceof JvmIdentifiableElement) {
            javaElement = this.javaElementFinder.findElementFor((JvmIdentifiableElement)objectToView);
        }
        if ((html = this.getHoverInfoAsHtml(element, objectToView, hoverRegion)) != null) {
            StringBuffer buffer = new StringBuffer(html);
            HTMLPrinter.insertPageProlog((StringBuffer)buffer, (int)0, (String)this.getStyleSheet());
            HTMLPrinter.addPageEpilog((StringBuffer)buffer);
            html = buffer.toString();
            return new XbaseInformationControlInput(previous, objectToView, javaElement, html, this.labelProvider);
        }
        return null;
    }

    private boolean isValidationDisabled(EObject objectToView) {
        Resource resource = objectToView.eResource();
        if (resource instanceof XtextResource) {
            return ((XtextResource)resource).isValidationDisabled();
        }
        return true;
    }

    protected String getHoverInfoAsHtml(EObject call, EObject objectToView, IRegion hoverRegion) {
        if (!this.hasHover(objectToView)) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        String oldSignature = this.getFirstLine(objectToView);
        if (oldSignature != null) {
            buffer.append(oldSignature);
        } else {
            buffer.append(this.computeSignature(call, objectToView));
        }
        String documentation = this.getDocumentation(objectToView);
        if (documentation != null && documentation.length() > 0) {
            buffer.append("<p>");
            buffer.append(documentation);
            buffer.append("</p>");
        }
        return buffer.toString();
    }

    @Deprecated
    protected String getFirstLine(EObject o) {
        return null;
    }

    protected EObject getObjectToView(EObject object) {
        if (object instanceof XAbstractFeatureCall) {
            return ((XAbstractFeatureCall)object).getFeature();
        }
        if (object instanceof XConstructorCall) {
            return ((XConstructorCall)object).getConstructor();
        }
        return object;
    }

    protected String getDocumentation(EObject o) {
        IEObjectHoverDocumentationProvider documentationProvider = (IEObjectHoverDocumentationProvider)this.serviceProvider.findService(o, IEObjectHoverDocumentationProvider.class);
        if (documentationProvider != null) {
            return documentationProvider.getDocumentation(o);
        }
        return "";
    }

    protected String computeSignature(EObject call, EObject o) {
        String imageTag = this.hoverSignatureProvider.getImageTag(o);
        String signature = this.hoverSignatureProvider.getSignature(o);
        if (call != null && (call instanceof XAbstractFeatureCall || call instanceof XConstructorCall)) {
            signature = this.hoverGenericsResolver.replaceGenerics((XExpression)call, this.hoverSignatureProvider.getSignature(o));
        }
        if (signature != null) {
            if (imageTag != null) {
                return "<div style='position: absolute; left: 0; top: 0;'>" + imageTag + TRAILING_PADDING + LEADING_PADDING + "<b>" + HTMLPrinter.convertToHTMLContent((String)signature) + "</b>" + TRAILING_PADDING;
            }
            return "<b>" + HTMLPrinter.convertToHTMLContent((String)signature) + "</b>" + TRAILING_PADDING;
        }
        return "";
    }

    protected boolean hasHover(EObject o) {
        if (o instanceof XSwitchExpression) {
            return false;
        }
        return o instanceof JvmIdentifiableElement || super.hasHover(o);
    }

    protected void addLinkListener(final IXtextBrowserInformationControl control) {
        control.addLocationListener(this.elementLinks.createLocationListener(new XbaseElementLinks.IXbaseLinkHandler(){

            public void handleXtextdocViewLink(URI linkTarget) {
            }

            public void handleInlineXtextdocLink(URI linkTarget) {
                XtextBrowserInformationControlInput hoverInfo = XbaseHoverProvider.this.getHoverInfo(this.getTarget(linkTarget), null, (XtextBrowserInformationControlInput)control.getInput());
                if (control.hasDelayedInputChangeListener()) {
                    control.notifyDelayedInputChange((Object)hoverInfo);
                } else {
                    control.setInput((Object)hoverInfo);
                }
            }

            public void handleDeclarationLink(URI linkTarget) {
                EObject jvmObject;
                XtextBrowserInformationControlInput input;
                EObject element;
                BrowserInformationControlInput uncastedInput;
                control.notifyDelayedInputChange(null);
                control.dispose();
                if (linkTarget.scheme().equals("java") && (uncastedInput = control.getInput()) != null && (element = (input = (XtextBrowserInformationControlInput)uncastedInput).getElement()) != null && (jvmObject = element.eResource().getResourceSet().getEObject(linkTarget, true)) != null) {
                    IJavaElement javaElement = XbaseHoverProvider.this.javaElementFinder.findElementFor((JvmIdentifiableElement)jvmObject);
                    try {
                        JavaUI.openInEditor((IJavaElement)javaElement);
                    }
                    catch (PartInitException partInitException) {
                    }
                    catch (JavaModelException javaModelException) {
                        // empty catch block
                    }
                }
                if (XbaseHoverProvider.this.uriEditorOpener != null) {
                    XbaseHoverProvider.this.uriEditorOpener.open(linkTarget, true);
                }
            }

            public boolean handleExternalLink(URL url, Display display) {
                control.notifyDelayedInputChange(null);
                control.dispose();
                OpenBrowserUtil.openExternal((URL)url, (Display)display);
                return true;
            }

            public void handleTextSet() {
            }

            EObject getTarget(URI uri) {
                ResourceSet rs = ((XtextBrowserInformationControlInput)control.getInput()).getElement().eResource().getResourceSet();
                return rs.getEObject(uri, true);
            }

            public void handleInlineJavadocLink(IJavaElement target) {
                String html = XbaseHoverProvider.this.getHtmlFromIJavaElement(target);
                XbaseInformationControlInput hoverInfo = new XbaseInformationControlInput((XtextBrowserInformationControlInput)control.getInput(), null, target, html, XbaseHoverProvider.this.labelProvider);
                if (control.hasDelayedInputChangeListener()) {
                    control.notifyDelayedInputChange((Object)hoverInfo);
                } else {
                    control.setInput((Object)hoverInfo);
                }
            }
        }));
    }

    protected String getHtmlFromIJavaElement(IJavaElement javaElement) {
        this.javadocHover.setJavaElement(javaElement);
        JavadocBrowserInformationControlInput hoverInfo2 = (JavadocBrowserInformationControlInput)this.javadocHover.getHoverInfo2(null, null);
        String html = hoverInfo2.getHtml();
        return html;
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        if (this.presenterControlCreator == null) {
            this.presenterControlCreator = new XbasePresenterControlCreator();
        }
        return this.presenterControlCreator;
    }

    public IInformationControlCreator getHoverControlCreator() {
        if (this.hoverControlCreator == null) {
            this.hoverControlCreator = new XbaseHoverControlCreator(this.getInformationPresenterControlCreator());
        }
        return this.hoverControlCreator;
    }

    protected class OpenDeclarationAction
    extends Action {
        private final IXtextBrowserInformationControl fInfoControl;

        public OpenDeclarationAction(IXtextBrowserInformationControl infoControl) {
            this.fInfoControl = infoControl;
            this.setText(XtextUIMessages.XtextBrowserInformationControlInput_OpenDeclaration);
            JavaPluginImages.setLocalImageDescriptors((IAction)this, (String)"goto_input.gif");
        }

        public void run() {
            if (this.fInfoControl.getInput() instanceof XtextBrowserInformationControlInput) {
                XtextBrowserInformationControlInput infoInput = (XtextBrowserInformationControlInput)this.fInfoControl.getInput();
                this.fInfoControl.notifyDelayedInputChange(null);
                this.fInfoControl.dispose();
                if (infoInput.getInputElement() != null && infoInput.getInputElement() instanceof IJavaElement) {
                    try {
                        JavaUI.openInEditor((IJavaElement)((IJavaElement)infoInput.getInputElement()));
                    }
                    catch (PartInitException e) {
                        JavaPlugin.log((Throwable)e);
                    }
                    catch (JavaModelException e) {
                        JavaPlugin.log((Throwable)e);
                    }
                } else if (XbaseHoverProvider.this.uriEditorOpener != null) {
                    XbaseHoverProvider.this.uriEditorOpener.open(XbaseHoverProvider.this.createURI(infoInput.getElement()), true);
                }
            }
        }
    }

    protected class ShowInJavadocViewAction
    extends Action {
        private final IXtextBrowserInformationControl fInfoControl;

        public ShowInJavadocViewAction(IXtextBrowserInformationControl infoControl) {
            this.fInfoControl = infoControl;
            this.setText(XtextUIMessages.XtextBrowserInformationControlInput_ShowInJavaDocView);
            this.setImageDescriptor(JavaPluginImages.DESC_OBJS_JAVADOCTAG);
        }

        public void run() {
            XtextBrowserInformationControlInput infoInput = (XtextBrowserInformationControlInput)this.fInfoControl.getInput();
            this.fInfoControl.notifyDelayedInputChange(null);
            this.fInfoControl.dispose();
            try {
                JavadocView view = (JavadocView)JavaPlugin.getActivePage().showView("org.eclipse.jdt.ui.JavadocView");
                view.setInput((BrowserInput)infoInput);
            }
            catch (PartInitException e) {
                JavaPlugin.log((Throwable)e);
            }
        }
    }

    public class XbaseHoverControlCreator
    extends DefaultEObjectHoverProvider.HoverControlCreator {
        protected final IInformationControlCreator fInformationPresenterControlCreator;

        public XbaseHoverControlCreator(IInformationControlCreator informationPresenterControlCreator) {
            super((DefaultEObjectHoverProvider)XbaseHoverProvider.this, informationPresenterControlCreator);
            this.fInformationPresenterControlCreator = informationPresenterControlCreator;
        }

        public IInformationControl doCreateInformationControl(Shell parent) {
            String tooltipAffordanceString = EditorsUI.getTooltipAffordanceString();
            if (BrowserInformationControl.isAvailable((Composite)parent)) {
                String font = "org.eclipse.jdt.ui.javadocfont";
                XbaseInformationControl iControl = new XbaseInformationControl(parent, font, tooltipAffordanceString, XbaseHoverProvider.this.xbaseHoverConfiguration){

                    public IInformationControlCreator getInformationPresenterControlCreator() {
                        return XbaseHoverControlCreator.this.fInformationPresenterControlCreator;
                    }
                };
                XbaseHoverProvider.this.addLinkListener(iControl);
                return iControl;
            }
            return new DefaultInformationControl(parent, tooltipAffordanceString);
        }
    }

    public class XbasePresenterControlCreator
    extends DefaultEObjectHoverProvider.PresenterControlCreator {
        public XbasePresenterControlCreator() {
            super((DefaultEObjectHoverProvider)XbaseHoverProvider.this);
        }

        public IInformationControl doCreateInformationControl(Shell parent) {
            if (XbaseInformationControl.isAvailable((Composite)parent)) {
                ToolBarManager tbm = new ToolBarManager(0x800000);
                String font = "org.eclipse.jdt.ui.javadocfont";
                XbaseInformationControl control = new XbaseInformationControl(parent, font, tbm, XbaseHoverProvider.this.xbaseHoverConfiguration);
                this.configureControl(control, tbm, font);
                return control;
            }
            return new DefaultInformationControl(parent, true);
        }

        protected void configureControl(IXtextBrowserInformationControl control, ToolBarManager tbm, String font) {
            final DefaultEObjectHoverProvider.BackAction backAction = new DefaultEObjectHoverProvider.BackAction(control);
            backAction.setEnabled(false);
            tbm.add((IAction)backAction);
            final DefaultEObjectHoverProvider.ForwardAction forwardAction = new DefaultEObjectHoverProvider.ForwardAction(control);
            tbm.add((IAction)forwardAction);
            forwardAction.setEnabled(false);
            final ShowInJavadocViewAction showInJavadocViewAction = new ShowInJavadocViewAction(control);
            tbm.add((IAction)showInJavadocViewAction);
            showInJavadocViewAction.setEnabled(false);
            final OpenDeclarationAction openDeclarationAction = new OpenDeclarationAction(control);
            tbm.add((IAction)openDeclarationAction);
            IInputChangedListener inputChangeListener = new IInputChangedListener(){

                public void inputChanged(Object newInput) {
                    backAction.update();
                    forwardAction.update();
                    if (newInput != null && newInput instanceof XbaseInformationControlInput) {
                        openDeclarationAction.setEnabled(true);
                        if (((XtextBrowserInformationControlInput)newInput).getInputElement() != null) {
                            showInJavadocViewAction.setEnabled(true);
                        }
                    }
                }
            };
            control.addInputChangeListener(inputChangeListener);
            tbm.update(true);
            XbaseHoverProvider.this.addLinkListener(control);
        }
    }
}

