/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.contentassist;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.xtext.common.types.JvmArrayType;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmPrimitiveType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmVoid;
import org.eclipse.xtext.formatting.IIndentationInformation;
import org.eclipse.xtext.formatting.IWhitespaceInformationProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.util.ReplaceRegion;
import org.eclipse.xtext.xbase.compiler.AbstractStringBuilderBasedAppendable;
import org.eclipse.xtext.xbase.imports.RewritableImportSection;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelAssociations;
import org.eclipse.xtext.xbase.ui.contentassist.WhitespaceHelper;
import org.eclipse.xtext.xbase.ui.imports.ReplaceConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplacingAppendable
extends AbstractStringBuilderBasedAppendable {
    private static final Logger LOG = Logger.getLogger(ReplacingAppendable.class);
    private IXtextDocument document;
    private final WhitespaceHelper whitespaceHelper;
    private RewritableImportSection importSection;
    private ReplaceConverter replaceConverter;

    public ReplacingAppendable(RewritableImportSection importSection, String lineSeparator, String indentString, IXtextDocument document, WhitespaceHelper whitespaceHelper, ReplaceConverter replaceConverter) {
        super(indentString, lineSeparator);
        this.importSection = importSection;
        this.document = document;
        this.whitespaceHelper = whitespaceHelper;
        this.replaceConverter = replaceConverter;
    }

    @NonNull
    public String toString() {
        return this.getCode();
    }

    public int getTotalOffset() {
        return this.whitespaceHelper.getTotalOffset();
    }

    @NonNull
    public String getCode() {
        StringBuilder builder = new StringBuilder();
        if (this.whitespaceHelper.getPrefix() != null) {
            builder.append(this.whitespaceHelper.getPrefix().replace(this.getLineSeparator(), this.getIndentationString()));
        }
        builder.append(super.toString());
        if (this.whitespaceHelper.getSuffix() != null) {
            builder.append(this.whitespaceHelper.getSuffix().replace(this.getLineSeparator(), this.getIndentationString()));
        }
        return builder.toString();
    }

    public void commitChanges() throws BadLocationException {
        this.document.replace(this.whitespaceHelper.getTotalOffset(), this.whitespaceHelper.getTotalLength(), this.toString());
        this.insertNewImports();
    }

    public int commitChanges(int offset, int length) throws BadLocationException {
        int actualOffset = Math.min(this.whitespaceHelper.getTotalOffset(), offset);
        int endOffset = Math.max(this.whitespaceHelper.getTotalOffset() + this.whitespaceHelper.getTotalLength(), offset + length);
        int actualLength = endOffset - actualOffset;
        this.document.replace(actualOffset, actualLength, this.toString());
        int shiftCursorBy = this.insertNewImports();
        return shiftCursorBy;
    }

    public int insertNewImports() throws BadLocationException {
        List importChanges = this.importSection.rewrite();
        int lengthDelta = 0;
        if (!importChanges.isEmpty()) {
            for (ReplaceRegion change : importChanges) {
                lengthDelta = lengthDelta - change.getLength() + change.getText().length();
            }
            this.replaceConverter.convertToTextEdit(importChanges).apply((IDocument)this.document);
        }
        return lengthDelta;
    }

    public void appendType(@NonNull JvmType type, @NonNull StringBuilder builder) {
        if (type instanceof JvmPrimitiveType || type instanceof JvmVoid || type instanceof JvmTypeParameter) {
            builder.append(type.getQualifiedName(this.getInnerTypeSeparator()));
        } else if (type instanceof JvmArrayType) {
            this.appendType((JvmType)((JvmArrayType)type).getComponentType(), builder);
            builder.append("[]");
        } else {
            String qualifiedName = type.getQualifiedName(this.getInnerTypeSeparator());
            String simpleName = type.getSimpleName();
            JvmDeclaredType importedType = this.importSection.getImportedType(simpleName);
            if (importedType == type) {
                builder.append(simpleName);
            } else if (importedType == null) {
                this.importSection.addImport((JvmDeclaredType)type);
                builder.append(simpleName);
            } else {
                builder.append(qualifiedName);
            }
        }
    }

    protected char getInnerTypeSeparator() {
        return '$';
    }

    @NonNull
    public List<String> getImports() {
        throw new UnsupportedOperationException("getImports() not implemented for ReplacingAppendable");
    }

    public RewritableImportSection getImportSection() {
        return this.importSection;
    }

    public static class Factory {
        @Inject
        private IJvmModelAssociations associations;
        @Inject
        private IIndentationInformation indentInformation;
        @Inject
        private IWhitespaceInformationProvider whitespaceInformationProvider;
        @Inject
        private Provider<WhitespaceHelper> whitespaceHelperProvider;
        @Inject
        private RewritableImportSection.Factory rewritableImportSectionFactory;
        @Inject
        private ReplaceConverter replaceConverter;

        public ReplacingAppendable get(IXtextDocument document, EObject context, int offset, int length) {
            return this.get(document, context, offset, length, this.getIndentationLevelAtOffset(offset, (IDocument)document), false);
        }

        public ReplacingAppendable get(IXtextDocument document, EObject context, int offset, int length, int indentationLevel, boolean ensureEmptyLinesAround) {
            try {
                XtextResource resource = (XtextResource)context.eResource();
                String indentString = this.indentInformation.getIndentString();
                String lineSeparator = this.whitespaceInformationProvider.getLineSeparatorInformation(resource.getURI()).getLineSeparator();
                RewritableImportSection rewritableImportSection = this.rewritableImportSectionFactory.parse(resource);
                WhitespaceHelper whitespaceHelper = (WhitespaceHelper)this.whitespaceHelperProvider.get();
                whitespaceHelper.initialize((IDocument)document, offset, length, ensureEmptyLinesAround);
                ReplacingAppendable appendable = new ReplacingAppendable(rewritableImportSection, lineSeparator, indentString, document, whitespaceHelper, this.replaceConverter);
                int i = 0;
                while (i < indentationLevel) {
                    appendable.increaseIndentation();
                    ++i;
                }
                return appendable;
            }
            catch (Exception exc) {
                LOG.error((Object)"Error initializing appendable", (Throwable)exc);
                return null;
            }
        }

        protected EObject getLocalVariableScopeContext(EObject context) {
            Set jvmElements = this.associations.getJvmElements(context);
            if (jvmElements.isEmpty()) {
                return null;
            }
            return (EObject)jvmElements.iterator().next();
        }

        protected int getIndentationLevelAtOffset(int offset, IDocument document) {
            block4: {
                if (offset > 0) break block4;
                return 0;
            }
            try {
                int currentOffset = offset - 1;
                char currentChr = document.getChar(currentOffset);
                int indentationOffset = 0;
                while (currentChr != '\n' && currentChr != '\r' && currentOffset > 0) {
                    indentationOffset = Character.isWhitespace(currentChr) ? ++indentationOffset : 0;
                    currentChr = document.getChar(--currentOffset);
                }
                return indentationOffset / this.indentInformation.getIndentString().length();
            }
            catch (BadLocationException e) {
                LOG.error((Object)"Error calculating indentation at offset", (Throwable)e);
                return 0;
            }
        }
    }
}

