/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.wizards;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.xtend.ide.wizards.AbstractNewXtendElementWizardPage;
import org.eclipse.xtend.ide.wizards.Messages;
import org.eclipse.xtend.ide.wizards.XtendTypeCreatorUtil;

public class NewXtendClassWizardPage
extends AbstractNewXtendElementWizardPage {
    public NewXtendClassWizardPage() {
        super(1, "Xtend Class");
        this.setTitle("Xtend Class");
        this.setDescription(Messages.XTEND_CLASS_WIZARD_DESCRIPTION);
    }

    public void createControl(Composite parent) {
        Composite composite = this.createCommonControls(parent);
        this.createSuperClassControls(composite, 4);
        this.createSuperInterfacesControls(composite, 4);
        this.setControl((Control)composite);
    }

    protected void doStatusUpdate() {
        IStatus[] status = new IStatus[]{this.fContainerStatus, this.fPackageStatus, this.fTypeNameStatus, this.fSuperClassStatus, this.fSuperInterfacesStatus};
        this.updateStatus(status);
    }

    protected int createXtendElement(IProgressMonitor monitor, IFile xtendFile, String indentation, String lineSperator) {
        int size = 0;
        try {
            String contents = XtendTypeCreatorUtil.createClass(this.getTypeName(), this.getPackageFragment(), this.getSuperClass(), this.getSuperInterfaces(), indentation, lineSperator, monitor);
            size = contents.length();
            xtendFile.create((InputStream)new ByteArrayInputStream(contents.getBytes()), true, monitor);
            this.setResource((IResource)xtendFile);
        }
        catch (CoreException e) {
            this.displayError(Messages.ERROR_CREATING_CLASS, e.getMessage());
        }
        return size;
    }

    protected String getElementCreationErrorMessage() {
        return Messages.ERROR_CREATING_CLASS;
    }
}

