/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.outline;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtend.core.dispatch.DispatchingSupport;
import org.eclipse.xtend.core.jvmmodel.IXtendJvmAssociations;
import org.eclipse.xtend.core.xtend.XtendClass;
import org.eclipse.xtend.core.xtend.XtendField;
import org.eclipse.xtend.core.xtend.XtendFile;
import org.eclipse.xtend.core.xtend.XtendFunction;
import org.eclipse.xtend.core.xtend.XtendMember;
import org.eclipse.xtend.core.xtend.XtendPackage;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtend.ide.labeling.XtendImages;
import org.eclipse.xtend.ide.outline.XtendFeatureNode;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.common.types.util.FeatureOverridesService;
import org.eclipse.xtext.common.types.util.SuperTypeCollector;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.common.types.util.VisibilityService;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.ui.editor.outline.IOutlineNode;
import org.eclipse.xtext.ui.editor.outline.impl.DocumentRootNode;
import org.eclipse.xtext.ui.editor.outline.impl.EObjectNode;
import org.eclipse.xtext.ui.editor.outline.impl.ModeAwareOutlineTreeProvider;
import org.eclipse.xtext.ui.editor.outline.impl.OutlineMode;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.TextRegion;
import org.eclipse.xtext.xbase.jvmmodel.JvmTypeExtensions;
import org.eclipse.xtext.xtype.XImportDeclaration;
import org.eclipse.xtext.xtype.XtypePackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XtendOutlineTreeProvider
extends ModeAwareOutlineTreeProvider {
    private static final OutlineMode SHOW_INHERITED_MODE = new OutlineMode("show", "show inherited members");
    private static final OutlineMode HIDE_INHERITED_MODE = new OutlineMode("hide", "hide inherited members");
    private static final List<OutlineMode> MODES = Lists.newArrayList((Object[])new OutlineMode[]{HIDE_INHERITED_MODE, SHOW_INHERITED_MODE});
    @Inject
    private XtendImages images;
    @Inject
    private IXtendJvmAssociations associations;
    @Inject
    private DispatchingSupport dispatchingSupport;
    @Inject
    private FeatureOverridesService featureOverridesService;
    @Inject
    private TypeReferences typeReferences;
    @Inject
    private VisibilityService visibilityService;
    @Inject
    private JvmTypeExtensions typeExtensions;
    @Inject
    private SuperTypeCollector superTypeCollector;

    protected void _createChildren(DocumentRootNode parentNode, XtendFile xtendFile) {
        if (xtendFile.getPackage() != null) {
            this.createEStructuralFeatureNode((IOutlineNode)parentNode, (EObject)xtendFile, (EStructuralFeature)XtendPackage.Literals.XTEND_FILE__PACKAGE, this.images.forPackage(), xtendFile.getPackage(), true);
        }
        if (xtendFile.getImportSection() != null && !xtendFile.getImportSection().getImportDeclarations().isEmpty()) {
            this.createEStructuralFeatureNode((IOutlineNode)parentNode, (EObject)xtendFile.getImportSection(), (EStructuralFeature)XtypePackage.Literals.XIMPORT_SECTION__IMPORT_DECLARATIONS, this.images.forImportContainer(), "import declarations", false);
        }
        for (XtendTypeDeclaration xtendType : xtendFile.getXtendTypes()) {
            EObjectNode classNode = this.createEObjectNode((IOutlineNode)parentNode, (EObject)xtendType);
            this.createFeatureNodes((IOutlineNode)classNode, xtendType);
        }
    }

    protected void createFeatureNodes(IOutlineNode parentNode, XtendTypeDeclaration xtendType) {
        JvmDeclaredType inferredType = this.associations.getInferredType(xtendType);
        if (inferredType != null) {
            HashSet processedFeatures = Sets.newHashSet();
            if (xtendType instanceof XtendClass) {
                Multimap dispatcher2dispatched = this.dispatchingSupport.getDispatcher2dispatched((XtendClass)xtendType, this.getCurrentMode() == HIDE_INHERITED_MODE);
                for (JvmOperation dispatcher : dispatcher2dispatched.keySet()) {
                    Object dispatcherNode = this.createNodeForFeature(parentNode, inferredType, (JvmFeature)dispatcher, (EObject)dispatcher);
                    if (dispatcherNode == null) continue;
                    ((XtendFeatureNode)((Object)dispatcherNode)).setDispatch(true);
                    processedFeatures.add(dispatcher);
                    for (JvmOperation dispatchCase : dispatcher2dispatched.get((Object)dispatcher)) {
                        XtendFunction xtendFunction = this.associations.getXtendFunction(dispatchCase);
                        if (xtendFunction == null) {
                            this.createNodeForFeature((IOutlineNode)dispatcherNode, inferredType, (JvmFeature)dispatchCase, (EObject)dispatchCase);
                        } else {
                            this.createNodeForFeature((IOutlineNode)dispatcherNode, inferredType, (JvmFeature)dispatchCase, (EObject)xtendFunction);
                        }
                        processedFeatures.add(dispatchCase);
                    }
                }
            }
            ArrayList remainingFeatures = Lists.newArrayList();
            remainingFeatures.addAll(inferredType.getMembers());
            if (this.getCurrentMode() == SHOW_INHERITED_MODE) {
                Set superTypes = this.superTypeCollector.collectSuperTypes((JvmType)inferredType);
                for (JvmTypeReference superType : superTypes) {
                    JvmDeclaredType type = (JvmDeclaredType)superType.getType();
                    for (JvmMember member : type.getMembers()) {
                        if (member.getVisibility() == JvmVisibility.PRIVATE) continue;
                        remainingFeatures.add(member);
                    }
                }
            }
            for (JvmFeature feature : Iterables.filter((Iterable)remainingFeatures, JvmFeature.class)) {
                if (processedFeatures.contains(feature)) continue;
                EObject primarySourceElement = this.associations.getPrimarySourceElement((EObject)feature);
                this.createNodeForFeature(parentNode, inferredType, feature, (EObject)(primarySourceElement != null ? primarySourceElement : feature));
            }
        } else {
            for (XtendMember member : xtendType.getMembers()) {
                this.createEObjectNode(parentNode, (EObject)member);
            }
        }
    }

    protected XtendFeatureNode createNodeForFeature(IOutlineNode parentNode, JvmDeclaredType inferredType, JvmFeature jvmFeature, EObject semanticFeature) {
        Object text = this.textDispatcher.invoke(new Object[]{semanticFeature});
        Image image = (Image)this.imageDispatcher.invoke(new Object[]{semanticFeature});
        boolean synthetic = this.typeExtensions.isSynthetic((JvmIdentifiableElement)jvmFeature);
        if (synthetic) {
            text = this.textDispatcher.invoke(new Object[]{jvmFeature});
            image = (Image)this.imageDispatcher.invoke(new Object[]{jvmFeature});
        }
        if (jvmFeature.getDeclaringType() != inferredType) {
            if (this.getCurrentMode() == SHOW_INHERITED_MODE) {
                StyledString label = text instanceof StyledString ? (StyledString)text : new StyledString(text.toString());
                label.append(new StyledString(" - " + jvmFeature.getDeclaringType().getIdentifier(), StyledString.COUNTER_STYLER));
                return this.createXtendFeatureNode(parentNode, (EObject)jvmFeature, image, label, true, synthetic);
            }
            return null;
        }
        return this.createXtendFeatureNode(parentNode, semanticFeature, image, text, true, synthetic);
    }

    protected XtendFeatureNode createXtendFeatureNode(IOutlineNode parentNode, EObject modelElement, Image image, Object text, boolean isLeaf, boolean synthetic) {
        XtendFeatureNode featureNode = new XtendFeatureNode(modelElement, parentNode, image, text, isLeaf);
        ICompositeNode parserNode = NodeModelUtils.getNode((EObject)modelElement);
        if (parserNode != null) {
            featureNode.setTextRegion((ITextRegion)new TextRegion(parserNode.getOffset(), parserNode.getLength()));
        }
        if (this.isLocalElement(parentNode, modelElement)) {
            featureNode.setShortTextRegion(this.locationInFileProvider.getSignificantTextRegion(modelElement));
        }
        featureNode.setStatic(this.isStatic(modelElement));
        featureNode.setSynthetic(synthetic);
        return featureNode;
    }

    protected boolean isStatic(EObject element) {
        if (element instanceof JvmField) {
            return ((JvmField)element).isStatic();
        }
        if (element instanceof JvmOperation) {
            return ((JvmOperation)element).isStatic();
        }
        if (element instanceof XtendField) {
            return ((XtendField)element).isStatic();
        }
        if (element instanceof XtendFunction) {
            return ((XtendFunction)element).isStatic();
        }
        return false;
    }

    protected boolean _isLeaf(EObject element) {
        return true;
    }

    protected Object _text(XImportDeclaration importDeclaration) {
        return importDeclaration.getImportedNamespace() != null ? importDeclaration.getImportedNamespace() : importDeclaration.getImportedTypeName();
    }

    public List<OutlineMode> getOutlineModes() {
        return MODES;
    }
}

