/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.labeling;

import com.google.inject.Inject;
import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtend.core.jvmmodel.IXtendJvmAssociations;
import org.eclipse.xtend.core.xtend.XtendAnnotationType;
import org.eclipse.xtend.core.xtend.XtendClass;
import org.eclipse.xtend.core.xtend.XtendConstructor;
import org.eclipse.xtend.core.xtend.XtendEnum;
import org.eclipse.xtend.core.xtend.XtendEnumLiteral;
import org.eclipse.xtend.core.xtend.XtendField;
import org.eclipse.xtend.core.xtend.XtendFile;
import org.eclipse.xtend.core.xtend.XtendFunction;
import org.eclipse.xtend.core.xtend.XtendInterface;
import org.eclipse.xtend.ide.labeling.XtendImages;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.xbase.ui.labeling.XbaseLabelProvider;
import org.eclipse.xtext.xbase.validation.UIStrings;
import org.eclipse.xtext.xtype.XImportDeclaration;

public class XtendLabelProvider
extends XbaseLabelProvider {
    @Inject
    private UIStrings uiStrings;
    @Inject
    private XtendImages images;
    @Inject
    private IXtendJvmAssociations associations;

    public XtendLabelProvider() {
        super(null);
    }

    public Image image(XtendFile element) {
        return this.images.forFile();
    }

    public Image image(XImportDeclaration element) {
        return this.images.forImport();
    }

    public Image image(XtendClass element) {
        return this.images.forClass(element.getVisibility());
    }

    public Image image(XtendInterface element) {
        return this.images.forInterface(element.getVisibility());
    }

    public Image image(XtendEnum element) {
        return this.images.forEnum(element.getVisibility());
    }

    public Image image(XtendAnnotationType element) {
        return this.images.forAnnotation(element.getVisibility());
    }

    public Image image(XtendFunction element) {
        return this.images.forOperation(element.getVisibility(), element.isAbstract(), element.isStatic(), element.isFinal());
    }

    public Image image(XtendConstructor element) {
        return this.images.forConstructor(element.getVisibility());
    }

    public Image image(XtendField element) {
        return this.images.forField(element.getVisibility(), element.isStatic(), element.isFinal(), element.isExtension());
    }

    public Image image(XtendEnumLiteral element) {
        return this.images.forField(element.getVisibility(), element.isStatic(), element.isFinal(), false);
    }

    public String text(XtendFile element) {
        return element.eResource().getURI().trimFileExtension().lastSegment();
    }

    public String text(XImportDeclaration element) {
        return element.getImportedNamespace();
    }

    public String text(XtendClass element) {
        return String.valueOf(element.getName()) + (element.getTypeParameters().isEmpty() ? "" : this.uiStrings.typeParameters((Iterable)element.getTypeParameters()));
    }

    public String text(XtendConstructor element) {
        return "new" + this.uiStrings.parameters((JvmIdentifiableElement)this.associations.getInferredConstructor(element));
    }

    public Object text(XtendFunction element) {
        return this.signature(element.getName(), (JvmIdentifiableElement)this.associations.getDirectlyInferredOperation(element));
    }

    public StyledString text(XtendField element) {
        String type;
        if (element.getName() == null && element.isExtension()) {
            return new StyledString(this.uiStrings.referenceToString(element.getType(), "extension"), StyledString.DECORATIONS_STYLER);
        }
        JvmTypeReference fieldType = this.getType(element);
        if (fieldType != null && (type = this.uiStrings.referenceToString(fieldType, "")).length() != 0) {
            return new StyledString(element.getName()).append(new StyledString(" : " + type, StyledString.DECORATIONS_STYLER));
        }
        return new StyledString(element.getName());
    }

    protected JvmTypeReference getType(XtendField field) {
        EObject next;
        JvmField jvmField = this.associations.getJvmField(field);
        if (jvmField != null) {
            return jvmField.getType();
        }
        Iterator i = this.associations.getJvmElements((EObject)field).iterator();
        if (i.hasNext() && (next = (EObject)i.next()) instanceof JvmOperation) {
            return ((JvmOperation)next).getReturnType();
        }
        return null;
    }
}

