/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.editor;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.xtend.core.typing.XtendOverridesService;
import org.eclipse.xtend.core.xtend.XtendClass;
import org.eclipse.xtend.core.xtend.XtendFile;
import org.eclipse.xtend.core.xtend.XtendFunction;
import org.eclipse.xtend.ide.editor.OverrideIndicatorAnnotation;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.IXtextEditorCallback;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.IXtextModelListener;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OverrideIndicatorModelListener
extends IXtextEditorCallback.NullImpl
implements IXtextModelListener {
    private XtextEditor xtextEditor;
    private Set<Annotation> overrideIndicatorAnnotations = Sets.newHashSet();
    private XtendOverridesService xtendOverridesService;

    @Inject
    public void setXtendOverridesService(XtendOverridesService xtendOverridesService) {
        this.xtendOverridesService = xtendOverridesService;
    }

    public void afterCreatePartControl(XtextEditor xtextEditor) {
        this.xtextEditor = xtextEditor;
        this.asyncUpdateAnnotationModel();
        xtextEditor.getDocument().addModelListener((IXtextModelListener)this);
    }

    public void beforeDispose(XtextEditor xtextEditor) {
        if (this.xtextEditor != null) {
            this.xtextEditor = null;
        }
    }

    public void modelChanged(XtextResource resource) {
        this.asyncUpdateAnnotationModel();
    }

    private void asyncUpdateAnnotationModel() {
        Runnable runnable = new Runnable(){

            public void run() {
                OverrideIndicatorModelListener.this.updateAnnotationModel();
            }
        };
        Display display = this.getDisplay();
        if (display == null) {
            return;
        }
        display.asyncExec(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAnnotationModel() {
        if (this.xtextEditor == null || this.xtextEditor.getDocument() == null || this.xtextEditor.getInternalSourceViewer().getAnnotationModel() == null) {
            return;
        }
        IXtextDocument xtextDocument = this.xtextEditor.getDocument();
        IAnnotationModel annotationModel = this.xtextEditor.getInternalSourceViewer().getAnnotationModel();
        Map annotationToPosition = (Map)xtextDocument.readOnly((IUnitOfWork)new IUnitOfWork<Map<Annotation, Position>, XtextResource>(){

            public Map<Annotation, Position> exec(XtextResource xtextResource) {
                if (xtextResource == null) {
                    return Collections.emptyMap();
                }
                return OverrideIndicatorModelListener.this.createOverrideIndicatorAnnotationMap(xtextResource);
            }
        });
        if (annotationModel instanceof IAnnotationModelExtension) {
            Object lockObject;
            IAnnotationModelExtension annotationModelExtension = (IAnnotationModelExtension)annotationModel;
            Object object = lockObject = this.getLockObject(annotationModel);
            synchronized (object) {
                annotationModelExtension.replaceAnnotations(this.overrideIndicatorAnnotations.toArray(new Annotation[0]), annotationToPosition);
            }
            this.overrideIndicatorAnnotations = annotationToPosition.keySet();
        }
    }

    private Object getLockObject(IAnnotationModel annotationModel) {
        Object lock;
        if (annotationModel instanceof ISynchronizable && (lock = ((ISynchronizable)annotationModel).getLockObject()) != null) {
            return lock;
        }
        return annotationModel;
    }

    private Display getDisplay() {
        if (this.xtextEditor == null) {
            return null;
        }
        IWorkbenchPartSite site = this.xtextEditor.getSite();
        if (site == null) {
            return null;
        }
        Shell shell = site.getShell();
        if (shell == null || shell.isDisposed()) {
            return null;
        }
        Display display = shell.getDisplay();
        if (display == null || display.isDisposed()) {
            return null;
        }
        return display;
    }

    protected Map<Annotation, Position> createOverrideIndicatorAnnotationMap(XtextResource xtextResource) {
        EObject eObject = xtextResource.getEObject("/");
        if (!(eObject instanceof XtendFile)) {
            return Maps.newHashMap();
        }
        XtendFile xtendFile = (XtendFile)eObject;
        HashMap annotationToPosition = Maps.newHashMap();
        for (XtendFunction xtendFunction : this.getXtendFunctions(xtendFile)) {
            ICompositeNode compositeNode;
            JvmOperation jvmOperation = this.xtendOverridesService.findOverriddenOperation(xtendFunction);
            if (!xtendFunction.isOverride() || jvmOperation == null || (compositeNode = NodeModelUtils.getNode((EObject)xtendFunction)) == null) continue;
            boolean overwriteIndicator = this.isOverwriteIndicator(jvmOperation);
            String text = String.valueOf(overwriteIndicator ? "overrides " : "implements ") + jvmOperation.getQualifiedName();
            annotationToPosition.put(new OverrideIndicatorAnnotation(overwriteIndicator, text, xtextResource.getURIFragment((EObject)xtendFunction)), new Position(compositeNode.getOffset()));
        }
        return annotationToPosition;
    }

    private Iterable<XtendFunction> getXtendFunctions(XtendFile xtendFile) {
        XtendClass xtendClass;
        XtendClass xtendClass2 = xtendClass = xtendFile.getXtendClasses().isEmpty() ? null : (XtendClass)xtendFile.getXtendClasses().get(0);
        if (xtendClass == null || xtendClass.getMembers() == null) {
            return Collections.emptyList();
        }
        return Iterables.filter((Iterable)xtendClass.getMembers(), XtendFunction.class);
    }

    protected boolean isOverwriteIndicator(JvmOperation jvmOperation) {
        JvmGenericType jvmGenericType;
        JvmDeclaredType jvmDeclaredType = jvmOperation.getDeclaringType();
        return !(jvmDeclaredType instanceof JvmGenericType) || !(jvmGenericType = (JvmGenericType)jvmDeclaredType).isInterface();
    }
}

