/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.parser.packrat;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.EnumLiteralDeclaration;
import org.eclipse.xtext.IGrammarAccess;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.parser.AbstractParser;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.parser.packrat.AbstractParserConfiguration;
import org.eclipse.xtext.parser.packrat.CharArrayWriterAsSequence;
import org.eclipse.xtext.parser.packrat.IBacktracker;
import org.eclipse.xtext.parser.packrat.ICharSequenceWithOffset;
import org.eclipse.xtext.parser.packrat.IHiddenTokenHandler;
import org.eclipse.xtext.parser.packrat.IMarkerFactory;
import org.eclipse.xtext.parser.packrat.IPackratParser;
import org.eclipse.xtext.parser.packrat.IParseResultFactory;
import org.eclipse.xtext.parser.packrat.IParserConfiguration;
import org.eclipse.xtext.parser.packrat.consumers.EnumLiteralConsumer;
import org.eclipse.xtext.parser.packrat.consumers.IConsumerUtility;
import org.eclipse.xtext.parser.packrat.consumers.INonTerminalConsumer;
import org.eclipse.xtext.parser.packrat.consumers.INonTerminalConsumerConfiguration;
import org.eclipse.xtext.parser.packrat.consumers.IRootConsumerListener;
import org.eclipse.xtext.parser.packrat.consumers.ITerminalConsumer;
import org.eclipse.xtext.parser.packrat.consumers.KeywordConsumer;
import org.eclipse.xtext.parser.packrat.consumers.NonTerminalConsumer;
import org.eclipse.xtext.parser.packrat.debug.DebugBacktracker;
import org.eclipse.xtext.parser.packrat.debug.DebugCharSequenceWithOffset;
import org.eclipse.xtext.parser.packrat.debug.DebugConsumerUtility;
import org.eclipse.xtext.parser.packrat.debug.DebugHiddenTokenHandler;
import org.eclipse.xtext.parser.packrat.debug.DebugMarkerFactory;
import org.eclipse.xtext.parser.packrat.debug.DebugParsedTokenAcceptor;
import org.eclipse.xtext.parser.packrat.debug.DebugUtil;
import org.eclipse.xtext.parser.packrat.internal.Backtracker;
import org.eclipse.xtext.parser.packrat.internal.Marker;
import org.eclipse.xtext.parser.packrat.matching.ICharacterClass;
import org.eclipse.xtext.parser.packrat.matching.ISequenceMatcher;
import org.eclipse.xtext.parser.packrat.tokens.AbstractParsedToken;
import org.eclipse.xtext.parser.packrat.tokens.ErrorToken;
import org.eclipse.xtext.parser.packrat.tokens.IParsedTokenAcceptor;
import org.eclipse.xtext.parser.packrat.tokens.IParsedTokenSource;
import org.eclipse.xtext.parser.packrat.tokens.ParsedAction;
import org.eclipse.xtext.parser.packrat.tokens.ParsedToken;

public abstract class AbstractPackratParser
extends AbstractParser
implements IPackratParser,
Marker.IMarkerClient,
ICharSequenceWithOffset,
IParsedTokenAcceptor,
IHiddenTokenHandler,
IConsumerUtility {
    private static Logger log = Logger.getLogger(AbstractPackratParser.class);
    private static final IHiddenTokenHandler.IHiddenTokenState NULL_HIDDEN_TOKEN_STATE = new IHiddenTokenHandler.IHiddenTokenState(){

        public void restore() {
        }
    };
    private final IParseResultFactory parseResultFactory;
    private final IGrammarAccess grammarAccess;
    private CharSequence input;
    private ITerminalConsumer[] hiddens;
    private int offset;
    private final KeywordConsumer keywordConsumer;
    private final EnumLiteralConsumer literalConsumer;
    private final IParserConfiguration parserConfiguration;
    private final IBacktracker backtracker;
    private static final int MARKER_BUFFER_SIZE = 100;
    private final Marker[] markerBuffer;
    private int markerBufferSize;
    private Marker activeMarker;

    protected AbstractPackratParser(IParseResultFactory parseResultFactory, IGrammarAccess grammarAccess) {
        this.grammarAccess = grammarAccess;
        this.parseResultFactory = parseResultFactory;
        this.backtracker = new Backtracker(this);
        this.parserConfiguration = this.createParserConfiguration();
        this.keywordConsumer = this.createKeywordConsumer();
        this.literalConsumer = this.createLiteralConsumer();
        this.markerBuffer = new Marker[100];
        ITerminalConsumer[] iTerminalConsumerArray = this.hiddens = this.parserConfiguration.getInitialHiddenTerminals();
        int n = this.hiddens.length;
        int n2 = 0;
        while (n2 < n) {
            ITerminalConsumer hidden = iTerminalConsumerArray[n2];
            hidden.setHidden(true);
            ++n2;
        }
    }

    private IParserConfiguration createParserConfiguration() {
        final ICharSequenceWithOffset localInput = DebugUtil.INPUT_DEBUG ? new DebugCharSequenceWithOffset(this) : this;
        final IMarkerFactory localMarkerFactory = DebugUtil.MARKER_FACTORY_DEBUG ? new DebugMarkerFactory(this) : this;
        final IParsedTokenAcceptor localTokenAcceptor = DebugUtil.TOKEN_ACCEPTOR_DEBUG ? new DebugParsedTokenAcceptor(this) : this;
        final IHiddenTokenHandler localHiddenTokenHandler = DebugUtil.HIDDEN_TOKEN_HANDLER_DEBUG ? new DebugHiddenTokenHandler(this) : this;
        final IConsumerUtility localConsumerUtil = DebugUtil.CONSUMER_UTIL_DEBUG ? new DebugConsumerUtility(this) : this;
        final IBacktracker localBacktracker = DebugUtil.BACKTRACKER_DEBUG ? new DebugBacktracker(this.backtracker) : this.backtracker;
        IParserConfiguration result = this.createParserConfiguration(new AbstractParserConfiguration.IInternalParserConfiguration(){

            public IConsumerUtility getConsumerUtil() {
                return localConsumerUtil;
            }

            public IHiddenTokenHandler getHiddenTokenHandler() {
                return localHiddenTokenHandler;
            }

            public ICharSequenceWithOffset getInput() {
                return localInput;
            }

            public IMarkerFactory getMarkerFactory() {
                return localMarkerFactory;
            }

            public IParsedTokenAcceptor getTokenAcceptor() {
                return localTokenAcceptor;
            }

            public IBacktracker getBacktracker() {
                return localBacktracker;
            }
        });
        result.createTerminalConsumers();
        result.createNonTerminalConsumers();
        result.configureConsumers();
        return result;
    }

    protected abstract IParserConfiguration createParserConfiguration(AbstractParserConfiguration.IInternalParserConfiguration var1);

    protected KeywordConsumer createKeywordConsumer() {
        return this.parserConfiguration.createKeywordConsumer();
    }

    protected EnumLiteralConsumer createLiteralConsumer() {
        return this.parserConfiguration.createLiteralConsumer();
    }

    public CharSequence getInput() {
        return this.input;
    }

    public final IParseResult parse(CharSequence input) {
        return this.parse(input, this.getRootConsumer());
    }

    public final IParseResult parse(CharSequence input, INonTerminalConsumer consumer) {
        this.input = input;
        this.offset = 0;
        Arrays.fill(this.markerBuffer, null);
        this.markerBufferSize = 0;
        return this.parse(consumer);
    }

    protected final IParseResult parse(INonTerminalConsumer consumer) {
        if (this.activeMarker != null) {
            throw new IllegalStateException("cannot parse now. Active marker is already assigned.");
        }
        IMarkerFactory.IMarker rootMarker = this.mark();
        RootConsumerListener listener = new RootConsumerListener();
        try {
            consumer.consumeAsRoot(listener);
            IParseResult result = this.getParseResultFactory().createParseResult(this.activeMarker, this.input);
            rootMarker.commit();
            if (this.activeMarker != null) {
                throw new IllegalStateException("cannot finish parse: active marker is still present.");
            }
            return result;
        }
        catch (Exception e) {
            throw new WrappedException(e);
        }
    }

    protected INonTerminalConsumer getRootConsumer() {
        return this.parserConfiguration.getRootConsumer();
    }

    protected void consumeHiddens() {
        boolean anySuccess = true;
        block0: while (anySuccess) {
            anySuccess = false;
            ITerminalConsumer[] iTerminalConsumerArray = this.hiddens;
            int n = this.hiddens.length;
            int n2 = 0;
            while (n2 < n) {
                ITerminalConsumer consumer = iTerminalConsumerArray[n2];
                IMarkerFactory.IMarker marker = this.mark();
                if (consumer.consume(null, false, false, null, ISequenceMatcher.Factory.nullMatcher(), true) == -2) {
                    anySuccess = true;
                    marker.commit();
                    continue block0;
                }
                marker.rollback();
                ++n2;
            }
        }
    }

    public IMarkerFactory.IMarker mark() {
        return this.getNextMarker(this.activeMarker, this.offset);
    }

    public Marker getActiveMarker() {
        return this.activeMarker;
    }

    public Marker getNextMarker(Marker parent, int offset) {
        return this.markerBufferSize > 0 ? this.markerBuffer[--this.markerBufferSize].reInit(offset, parent, this, this) : new Marker(parent, offset, this, this);
    }

    public void setActiveMarker(Marker marker) {
        this.activeMarker = marker;
    }

    public void releaseMarker(Marker marker) {
        if (this.markerBufferSize < 100) {
            this.markerBuffer[this.markerBufferSize++] = marker;
        }
    }

    public int consumeKeyword(Keyword keyword, String feature, boolean isMany, boolean isBoolean, ICharacterClass notFollowedBy, boolean optional) {
        this.keywordConsumer.configure(keyword, notFollowedBy);
        return this.consumeTerminal(this.keywordConsumer, feature, isMany, isBoolean, keyword, ISequenceMatcher.Factory.nullMatcher(), optional);
    }

    public int consumeEnum(EnumLiteralDeclaration literal, ICharacterClass notFollowedBy) {
        this.literalConsumer.configure(literal, notFollowedBy);
        return this.consumeTerminal(this.literalConsumer, null, false, false, literal, ISequenceMatcher.Factory.nullMatcher(), false);
    }

    public int consumeTerminal(ITerminalConsumer consumer, String feature, boolean isMany, boolean isBoolean, AbstractElement grammarElement, ISequenceMatcher notMatching, boolean optional) {
        IMarkerFactory.IMarker marker = this.mark();
        this.consumeHiddens();
        int result = consumer.consume(feature, isMany, isBoolean, grammarElement, notMatching != null ? notMatching : ISequenceMatcher.Factory.nullMatcher(), optional);
        if (result == -2) {
            marker.commit();
            return result;
        }
        marker.rollback();
        return result;
    }

    public int consumeNonTerminal(INonTerminalConsumer consumer, String feature, boolean isMany, boolean isDatatype, boolean isBoolean, AbstractElement grammarElement, boolean optional) throws Exception {
        if (!consumer.isDefiningHiddens()) {
            return consumer.consume(feature, isMany, isDatatype, isBoolean, grammarElement, optional);
        }
        IMarkerFactory.IMarker bestMarker = this.mark();
        IMarkerFactory.IMarker currentMarker = bestMarker.fork();
        int result = consumer.consume(feature, isMany, isDatatype, isBoolean, grammarElement, optional);
        if (result == -2) {
            bestMarker = currentMarker.join(bestMarker);
            bestMarker.commit();
            return result;
        }
        bestMarker = currentMarker.join(bestMarker);
        currentMarker = bestMarker.fork();
        this.consumeHiddens();
        int nextResult = consumer.consume(feature, isMany, isDatatype, isBoolean, grammarElement, optional);
        if (nextResult == -2) {
            bestMarker = currentMarker.join(bestMarker);
            bestMarker.commit();
            return nextResult;
        }
        if (nextResult > result) {
            bestMarker = currentMarker.join(bestMarker);
            result = nextResult;
        } else {
            bestMarker = bestMarker.join(currentMarker);
        }
        bestMarker.commit();
        return result;
    }

    public void consumeAction(final Action action, final boolean isMany) {
        this.accept(new ParsedAction(this.offset, action, isMany, new IParsedTokenSource(){

            public int parseAgain(ParsedToken token) throws Exception {
                AbstractPackratParser.this.consumeAction(action, isMany);
                return -2;
            }
        }));
    }

    protected IParseResultFactory getParseResultFactory() {
        return this.parseResultFactory;
    }

    protected IGrammarAccess getGrammarAccess() {
        return this.grammarAccess;
    }

    public int getOffset() {
        return this.offset;
    }

    public char charAt(int index) {
        return this.input.charAt(index);
    }

    public int length() {
        return this.input.length();
    }

    public CharSequence subSequence(int start, int end) {
        return this.input.subSequence(start, end);
    }

    public void incOffset() {
        ++this.offset;
    }

    public void incOffset(int amount) {
        this.offset += amount;
    }

    public void accept(AbstractParsedToken token) {
        this.activeMarker.accept(token);
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public IHiddenTokenHandler.IHiddenTokenState replaceHiddenTokens(ITerminalConsumer ... consumers) {
        if (consumers == null) {
            return NULL_HIDDEN_TOKEN_STATE;
        }
        HiddenTokenState result = new HiddenTokenState(this.hiddens);
        this.setHiddens(consumers);
        return result;
    }

    private void setHiddens(ITerminalConsumer ... hiddenConsumers) {
        ITerminalConsumer hidden;
        ITerminalConsumer[] iTerminalConsumerArray = this.hiddens;
        int n = this.hiddens.length;
        int n2 = 0;
        while (n2 < n) {
            hidden = iTerminalConsumerArray[n2];
            hidden.setHidden(false);
            ++n2;
        }
        iTerminalConsumerArray = this.hiddens = hiddenConsumers;
        n = this.hiddens.length;
        n2 = 0;
        while (n2 < n) {
            hidden = iTerminalConsumerArray[n2];
            hidden.setHidden(true);
            ++n2;
        }
    }

    protected IParseResult doParse(Reader reader) {
        return this.doParse(this.createCharSequence(reader));
    }

    protected CharSequence createCharSequence(Reader reader0) {
        try {
            char[] buff = new char[1024];
            BufferedReader reader = new BufferedReader(reader0);
            CharArrayWriterAsSequence result = new CharArrayWriterAsSequence();
            int chars = 0;
            while ((chars = reader.read(buff)) != -1) {
                result.write(buff, 0, chars);
            }
            reader.close();
            return result;
        }
        catch (IOException ex) {
            throw new WrappedException((Exception)ex);
        }
    }

    protected IParseResult doParse(CharSequence sequence) {
        return this.parse(sequence);
    }

    private class HiddenTokenState
    implements IHiddenTokenHandler.IHiddenTokenState {
        private final ITerminalConsumer[] hiddens;

        public HiddenTokenState(ITerminalConsumer[] previousHiddens) {
            this.hiddens = previousHiddens;
        }

        public void restore() {
            AbstractPackratParser.this.setHiddens(this.hiddens);
        }

        public String toString() {
            return "HiddenTokenState holding " + Arrays.toString(this.hiddens);
        }
    }

    private class RootConsumerListener
    implements IRootConsumerListener {
        private RootConsumerListener() {
        }

        public void beforeNonTerminalEnd(INonTerminalConsumer nonTerminalConsumer, int result, INonTerminalConsumerConfiguration configuration) {
            if (result == -2) {
                if (AbstractPackratParser.this.offset != AbstractPackratParser.this.length()) {
                    AbstractPackratParser.this.consumeHiddens();
                }
                if (AbstractPackratParser.this.offset != AbstractPackratParser.this.length()) {
                    configuration.getTokenAcceptor().accept(new ErrorToken(AbstractPackratParser.this.offset, AbstractPackratParser.this.length() - AbstractPackratParser.this.offset, null, "<EOF> expected."));
                    AbstractPackratParser.this.offset = AbstractPackratParser.this.length();
                }
            }
        }

        public void afterNonTerminalBegin(INonTerminalConsumer nonTerminalConsumer, INonTerminalConsumerConfiguration configuration) {
            AbstractPackratParser.this.consumeHiddens();
        }

        public void handleException(NonTerminalConsumer nonTerminalConsumer, Exception e, INonTerminalConsumerConfiguration configuration) {
            log.error((Object)("handle Exception: " + e.getMessage()), (Throwable)e);
            configuration.getTokenAcceptor().accept(new ErrorToken(AbstractPackratParser.this.offset, AbstractPackratParser.this.length() - AbstractPackratParser.this.offset, null, e.getMessage()));
            AbstractPackratParser.this.offset = AbstractPackratParser.this.length();
        }
    }
}

