/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.ui.editor.autoedit;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.xtext.ui.editor.autoedit.AbstractEditStrategyProvider;
import org.eclipse.xtext.ui.editor.autoedit.DefaultAutoEditStrategyProvider;
import org.eclipse.xtext.ui.editor.autoedit.MultiLineTerminalsEditStrategy;
import org.eclipse.xtext.ui.editor.autoedit.SingleLineTerminalsStrategy;
import org.eclipse.xtext.ui.editor.model.DocumentUtil;

public class XtextAutoEditStrategy
extends DefaultAutoEditStrategyProvider {
    private static final Pattern singleColonPattern = Pattern.compile("[^:]:($|[^:])");
    private static final Pattern returnsPattern = Pattern.compile("\\sreturns\\s");
    private static final Pattern doubleColonPattern = Pattern.compile("::");

    protected void configure(AbstractEditStrategyProvider.IEditStrategyAcceptor acceptor) {
        super.configure(acceptor);
        acceptor.accept((IAutoEditStrategy)this.singleLineTerminals.newInstance(":", ";", new SingleLineTerminalsStrategy.StrategyPredicate(){

            public boolean isInsertClosingBracket(IDocument doc, int offset) throws BadLocationException {
                String currentRuleUptoOffset = XtextAutoEditStrategy.this.getCurrentRuleUptoOffset(offset, doc);
                Matcher matcher = singleColonPattern.matcher(currentRuleUptoOffset);
                boolean isInsideRuleBody = matcher.find();
                if (isInsideRuleBody) {
                    return false;
                }
                Matcher returnsPatternMatcher = returnsPattern.matcher(currentRuleUptoOffset);
                if (returnsPatternMatcher.find()) {
                    return doubleColonPattern.matcher(currentRuleUptoOffset).find(returnsPatternMatcher.end());
                }
                return true;
            }
        }), "__dftl_partition_content_type");
        MultiLineTerminalsEditStrategy configure = this.multiLineTerminals.newInstance(":", null, ";");
        configure.setDocumentUtil(new DocumentUtil(){

            protected String preProcessSearchString(String string) {
                return string.replace("::", "  ");
            }
        });
        acceptor.accept((IAutoEditStrategy)configure, "__dftl_partition_content_type");
    }

    protected String getCurrentRuleUptoOffset(int offset, IDocument doc) throws BadLocationException {
        ITypedRegion currentPartition = doc.getPartition(offset);
        String partitionType = currentPartition.getType();
        String currentSegment = doc.get(currentPartition.getOffset(), offset - currentPartition.getOffset());
        StringBuilder ruleAsString = new StringBuilder();
        while (currentSegment.indexOf(59) == -1) {
            ruleAsString.insert(0, currentSegment);
            do {
                if (currentPartition.getOffset() == 0) {
                    return ruleAsString.toString();
                }
                currentPartition = doc.getPartition(currentPartition.getOffset() - 1);
                currentSegment = doc.get(currentPartition.getOffset(), currentPartition.getLength());
            } while (!partitionType.equals(currentPartition.getType()));
        }
        ruleAsString.insert(0, currentSegment.substring(currentSegment.lastIndexOf(59) + 1));
        return ruleAsString.toString();
    }
}

