/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.junit4.parameterized;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.xtext.junit4.parameterized.ActualCollection;
import org.eclipse.xtext.junit4.parameterized.ExpectationCollection;
import org.eclipse.xtext.junit4.parameterized.IParameterProvider;
import org.eclipse.xtext.junit4.parameterized.TestExpectationValidator;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.Pair;
import org.junit.Assert;
import org.junit.ComparisonFailure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Target(value={ElementType.METHOD})
@Retention(value=RetentionPolicy.RUNTIME)
@TestExpectationValidator(validator=LinesResultValidator.class)
public @interface XpectLines {
    public boolean caseSensitive() default true;

    public boolean whitespaceSensitive() default false;

    public boolean quoted() default false;

    public Class<? extends Function<Object, String>> itemFormatter() default ActualCollection.ToString.class;

    public boolean ordered() default false;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LinesResultValidator
    implements TestExpectationValidator.ITestExpectationValidator<Iterable<Object>> {
        protected XpectLines cfg;

        public LinesResultValidator(XpectLines cfg) {
            this.cfg = cfg;
        }

        @Override
        public void validate(XtextResource res, IParameterProvider.IExpectation expectation, @TestExpectationValidator.TestResult Iterable<Object> actual) {
            Assert.assertNotNull((Object)res);
            Assert.assertNotNull((Object)expectation);
            Assert.assertNotNull((Object)expectation.getExpectation());
            Assert.assertNotNull(actual);
            ExpectationCollection exp = new ExpectationCollection();
            exp.setCaseSensitive(this.cfg.caseSensitive());
            exp.setOrdered(this.cfg.ordered());
            exp.setQuoted(this.cfg.quoted());
            exp.setSeparator('\n');
            exp.setWhitespaceSensitive(this.cfg.whitespaceSensitive());
            exp.init(expectation.getExpectation());
            ActualCollection act = new ActualCollection();
            act.setCaseSensitive(this.cfg.caseSensitive());
            act.setOrdered(this.cfg.ordered());
            act.setQuoted(this.cfg.quoted());
            act.setSeparator('\n');
            act.setWhitespaceSensitive(this.cfg.whitespaceSensitive());
            act.init(actual, this.cfg.itemFormatter());
            if (!exp.matches(act)) {
                ArrayList expString = Lists.newArrayList();
                ArrayList actString = Lists.newArrayList();
                for (Pair<Collection<ExpectationCollection.ExpectationItem>, ActualCollection.ActualItem> pair : exp.map(act)) {
                    if (pair.getFirst() != null && !((Collection)pair.getFirst()).isEmpty()) {
                        if (pair.getSecond() != null) {
                            expString.add(((ActualCollection.ActualItem)pair.getSecond()).getEscaped());
                        } else {
                            expString.add(((ExpectationCollection.ExpectationItem)((Collection)pair.getFirst()).iterator().next()).getEscaped());
                        }
                    }
                    if (pair.getSecond() == null) continue;
                    actString.add(((ActualCollection.ActualItem)pair.getSecond()).getEscaped());
                }
                String expDoc = IParameterProvider.IExpectation.Util.replace(res, expectation, Joiner.on((char)'\n').join((Iterable)expString));
                String actDoc = IParameterProvider.IExpectation.Util.replace(res, expectation, Joiner.on((char)'\n').join((Iterable)actString));
                throw new ComparisonFailure("", expDoc, actDoc);
            }
        }
    }
}

