/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.clustering;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Queue;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.builder.builderState.AbstractBuilderState;
import org.eclipse.xtext.builder.builderState.BuilderStateUtil;
import org.eclipse.xtext.builder.builderState.ResourceDescriptionsData;
import org.eclipse.xtext.builder.builderState.impl.ResourceDescriptionImpl;
import org.eclipse.xtext.builder.clustering.CopiedResourceDescription;
import org.eclipse.xtext.builder.clustering.CurrentDescriptions;
import org.eclipse.xtext.builder.clustering.IResourceClusteringPolicy;
import org.eclipse.xtext.builder.impl.BuildData;
import org.eclipse.xtext.builder.resourceloader.IResourceLoader;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.impl.DefaultResourceDescriptionDelta;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusteringBuilderState
extends AbstractBuilderState {
    public static final String RESOURCELOADER_CROSS_LINKING = "org.eclipse.xtext.builder.resourceloader.crossLinking";
    public static final String RESOURCELOADER_GLOBAL_INDEX = "org.eclipse.xtext.builder.resourceloader.globalIndex";
    private static final Logger LOGGER = Logger.getLogger(ClusteringBuilderState.class);
    @Inject
    private IResourceServiceProvider.Registry managerRegistry;
    @Inject
    private IResourceClusteringPolicy clusteringPolicy;
    @Inject
    @Named(value="org.eclipse.xtext.builder.resourceloader.globalIndex")
    private IResourceLoader globalIndexResourceLoader;
    @Inject
    @Named(value="org.eclipse.xtext.builder.resourceloader.crossLinking")
    private IResourceLoader crossLinkingResourceLoader;
    @Inject
    private IWorkspace workspace;

    @Override
    protected Collection<IResourceDescription.Delta> doUpdate(BuildData buildData, ResourceDescriptionsData newData, IProgressMonitor monitor) {
        final SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        Set<URI> toBeDeleted = buildData.getAndRemoveToBeDeleted();
        ResourceSet resourceSet = buildData.getResourceSet();
        CurrentDescriptions newState = new CurrentDescriptions(resourceSet, newData);
        this.writeNewResourceDescriptions(buildData, this, newState, (IProgressMonitor)progress.newChild(20));
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        for (URI uri : toBeDeleted) {
            newData.removeDescription(uri);
        }
        LinkedHashSet allRemainingURIs = Sets.newLinkedHashSet(newData.getAllURIs());
        allRemainingURIs.removeAll(buildData.getToBeUpdated());
        for (URI remainingURI : buildData.getAllRemainingURIs()) {
            allRemainingURIs.remove(remainingURI);
        }
        HashSet allDeltas = Sets.newHashSet();
        if (!toBeDeleted.isEmpty()) {
            for (URI uri : toBeDeleted) {
                IResourceDescription oldDescription = this.getResourceDescription(uri);
                if (oldDescription == null) continue;
                allDeltas.add(new DefaultResourceDescriptionDelta(oldDescription, null));
            }
        }
        Collection<IResourceDescription.Delta> pendingDeltas = buildData.getAndRemovePendingDeltas();
        allDeltas.addAll(pendingDeltas);
        this.queueAffectedResources(allRemainingURIs, this, newState, allDeltas, buildData, (IProgressMonitor)progress.newChild(1));
        IProject currentProject = this.getBuiltProject(buildData);
        IResourceLoader.LoadOperation loadOperation = null;
        try {
            Queue<URI> queue = buildData.getURIQueue();
            loadOperation = this.crossLinkingResourceLoader.create(resourceSet, currentProject);
            loadOperation.load(queue);
            SubMonitor subProgress = progress.newChild(80);
            CancelIndicator cancelMonitor = new CancelIndicator(){

                public boolean isCanceled() {
                    return progress.isCanceled();
                }
            };
            int index = 1;
            while (!queue.isEmpty()) {
                subProgress.setWorkRemaining(queue.size() + 2);
                ArrayList newDeltas = Lists.newArrayList();
                ArrayList changedDeltas = Lists.newArrayList();
                while (!queue.isEmpty()) {
                    DefaultResourceDescriptionDelta newDelta;
                    block25: {
                        if (subProgress.isCanceled()) {
                            loadOperation.cancel();
                            throw new OperationCanceledException();
                        }
                        if (!this.clusteringPolicy.continueProcessing(resourceSet, null, newDeltas.size())) break;
                        URI changedURI = null;
                        Resource resource = null;
                        newDelta = null;
                        try {
                            IResourceLoader.LoadResult loadResult = loadOperation.next();
                            changedURI = loadResult.getUri();
                            resource = this.addResource(loadResult.getResource(), resourceSet);
                            subProgress.subTask("Updating resource description for " + changedURI.lastSegment() + " (" + index + " of " + (index + queue.size()) + ")");
                            queue.remove(changedURI);
                            if (toBeDeleted.contains(changedURI)) break;
                            IResourceDescription.Manager manager = this.getResourceDescriptionManager(changedURI);
                            if (manager != null) {
                                try {
                                    EcoreUtil2.resolveLazyCrossReferences((Resource)resource, (CancelIndicator)cancelMonitor);
                                    IResourceDescription description = manager.getResourceDescription(resource);
                                    ResourceDescriptionImpl copiedDescription = BuilderStateUtil.create(description);
                                    newDelta = manager.createDelta(this.getResourceDescription(changedURI), (IResourceDescription)copiedDescription);
                                }
                                catch (RuntimeException e) {
                                    LOGGER.error((Object)("Error resolving cross references on resource '" + resource.getURI() + "'"), (Throwable)e);
                                }
                            }
                        }
                        catch (WrappedException ex) {
                            ResourceDescriptionImpl indexReadyDescription;
                            if (ex instanceof IResourceLoader.LoadOperationException) {
                                changedURI = ((IResourceLoader.LoadOperationException)ex).getUri();
                            }
                            Throwable cause = ex.getCause();
                            boolean wasResourceNotFound = false;
                            if (cause instanceof CoreException && 368 == ((CoreException)cause).getStatus().getCode()) {
                                wasResourceNotFound = true;
                            }
                            if (changedURI == null) {
                                LOGGER.error((Object)"Error loading resource", (Throwable)ex);
                            }
                            queue.remove(changedURI);
                            if (toBeDeleted.contains(changedURI)) break;
                            if (!wasResourceNotFound) {
                                LOGGER.error((Object)("Error loading resource from: " + changedURI.toString()), (Throwable)ex);
                            }
                            if (resource != null) {
                                resourceSet.getResources().remove((Object)resource);
                            }
                            IResourceDescription oldDescription = this.getResourceDescription(changedURI);
                            IResourceDescription newDesc = newState.getResourceDescription(changedURI);
                            ResourceDescriptionImpl resourceDescriptionImpl = indexReadyDescription = newDesc != null ? BuilderStateUtil.create(newDesc) : null;
                            if (oldDescription == null && indexReadyDescription == null || oldDescription == indexReadyDescription) break block25;
                            newDelta = new DefaultResourceDescriptionDelta(oldDescription, (IResourceDescription)indexReadyDescription);
                        }
                    }
                    if (newDelta != null) {
                        newDeltas.add(newDelta);
                        if (newDelta.haveEObjectDescriptionsChanged()) {
                            changedDeltas.add(newDelta);
                        }
                        newState.register((IResourceDescription.Delta)newDelta);
                    }
                    subProgress.worked(1);
                    ++index;
                }
                loadOperation.cancel();
                this.queueAffectedResources(allRemainingURIs, this, newState, changedDeltas, buildData, (IProgressMonitor)subProgress.newChild(1));
                if (queue.size() > 0) {
                    loadOperation = this.crossLinkingResourceLoader.create(resourceSet, currentProject);
                    loadOperation.load(queue);
                }
                this.updateMarkers(resourceSet, (ImmutableList<IResourceDescription.Delta>)ImmutableList.copyOf((Collection)newDeltas), (IProgressMonitor)subProgress.newChild(1));
                allDeltas.addAll(newDeltas);
                if (queue.isEmpty()) continue;
                this.clearResourceSet(resourceSet);
            }
        }
        finally {
            if (loadOperation != null) {
                loadOperation.cancel();
            }
        }
        return allDeltas;
    }

    protected void writeNewResourceDescriptions(BuildData buildData, IResourceDescriptions oldState, CurrentDescriptions newState, IProgressMonitor monitor) {
        int index = 0;
        Set<URI> toBeUpdated = buildData.getToBeUpdated();
        ResourceSet resourceSet = buildData.getResourceSet();
        int n = toBeUpdated.size();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Write new resource descriptions", (int)n);
        IProject currentProject = this.getBuiltProject(buildData);
        IResourceLoader.LoadOperation loadOperation = null;
        try {
            loadOperation = this.globalIndexResourceLoader.create(resourceSet, currentProject);
            loadOperation.load(toBeUpdated);
            while (loadOperation.hasNext()) {
                block14: {
                    if (subMonitor.isCanceled()) {
                        loadOperation.cancel();
                        throw new OperationCanceledException();
                    }
                    if (!this.clusteringPolicy.continueProcessing(resourceSet, null, index)) {
                        this.clearResourceSet(resourceSet);
                    }
                    URI uri = null;
                    Resource resource = null;
                    try {
                        IResourceLoader.LoadResult loadResult = loadOperation.next();
                        uri = loadResult.getUri();
                        resource = this.addResource(loadResult.getResource(), resourceSet);
                        subMonitor.subTask("Writing new resource description for " + uri.lastSegment() + " (" + index++ + " of " + n + ")");
                        IResourceDescription.Manager manager = this.getResourceDescriptionManager(uri);
                        if (manager != null) {
                            IResourceDescription description = manager.getResourceDescription(resource);
                            CopiedResourceDescription copiedDescription = new CopiedResourceDescription(description);
                            newState.register((IResourceDescription.Delta)new DefaultResourceDescriptionDelta(oldState.getResourceDescription(uri), (IResourceDescription)copiedDescription));
                            buildData.queueURI(uri);
                        }
                    }
                    catch (WrappedException ex) {
                        IResourceDescription oldDescription;
                        if (ex instanceof IResourceLoader.LoadOperationException) {
                            uri = ((IResourceLoader.LoadOperationException)ex).getUri();
                        }
                        if (uri == null) {
                            LOGGER.error((Object)"Error loading resource", (Throwable)ex);
                        }
                        if (resourceSet.getURIConverter().exists(uri, Collections.emptyMap())) {
                            LOGGER.error((Object)("Error loading resource from: " + uri.toString()), (Throwable)ex);
                        }
                        if (resource != null) {
                            resourceSet.getResources().remove((Object)resource);
                        }
                        if ((oldDescription = oldState.getResourceDescription(uri)) == null) break block14;
                        newState.register((IResourceDescription.Delta)new DefaultResourceDescriptionDelta(oldDescription, null));
                    }
                }
                subMonitor.worked(1);
            }
        }
        finally {
            if (loadOperation != null) {
                loadOperation.cancel();
            }
        }
    }

    protected IProject getBuiltProject(BuildData buildData) {
        if (Strings.isEmpty((String)buildData.getProjectName())) {
            return null;
        }
        return this.workspace.getRoot().getProject(buildData.getProjectName());
    }

    protected void clearResourceSet(ResourceSet resourceSet) {
        boolean wasDeliver = resourceSet.eDeliver();
        try {
            resourceSet.eSetDeliver(false);
            resourceSet.getResources().clear();
        }
        finally {
            resourceSet.eSetDeliver(wasDeliver);
        }
    }

    protected Resource addResource(Resource resource, ResourceSet resourceSet) {
        URI uri = resource.getURI();
        Resource r = resourceSet.getResource(uri, false);
        if (r == null) {
            resourceSet.getResources().add((Object)resource);
            return resource;
        }
        return r;
    }

    protected void queueAffectedResources(Set<URI> allRemainingURIs, IResourceDescriptions oldState, CurrentDescriptions newState, Collection<IResourceDescription.Delta> deltas, BuildData buildData, IProgressMonitor monitor) {
        if (deltas.isEmpty()) {
            return;
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)allRemainingURIs.size());
        Iterator<URI> iter = allRemainingURIs.iterator();
        while (iter.hasNext()) {
            if (progress.isCanceled()) {
                throw new OperationCanceledException();
            }
            URI candidateURI = iter.next();
            IResourceDescription candidateDescription = oldState.getResourceDescription(candidateURI);
            IResourceDescription.Manager manager = this.getResourceDescriptionManager(candidateURI);
            if (candidateDescription == null || manager == null) {
                iter.remove();
            } else if (manager.isAffected(deltas, candidateDescription, (IResourceDescriptions)newState)) {
                buildData.queueURI(candidateURI);
                iter.remove();
            }
            progress.worked(1);
        }
    }

    protected IResourceDescription.Manager getResourceDescriptionManager(URI uri) {
        IResourceServiceProvider resourceServiceProvider = this.managerRegistry.getResourceServiceProvider(uri);
        if (resourceServiceProvider == null) {
            return null;
        }
        return resourceServiceProvider.getResourceDescriptionManager();
    }
}

